/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.dbutils;

import java.sql.ResultSet;

public class IndexData {
    private String table;
    private boolean unique;
    private String qualifier;
    private String name;
    private short type;
    private short ordPos;
    private String colName;
    private String ascdesc;

    public IndexData(ResultSet rs) throws Exception {
        this.table = rs.getString("TABLE_NAME");
        this.unique = rs.getBoolean("NON_UNIQUE");
        this.qualifier = rs.getString("INDEX_QUALIFIER");
        this.name = rs.getString("INDEX_NAME");
        this.type = rs.getShort("TYPE");
        this.ordPos = rs.getShort("ORDINAL_POSITION");
        this.colName = rs.getString("COLUMN_NAME");
        this.ascdesc = rs.getString("ASC_OR_DESC");
    }

    public String getTable() {
        return this.table;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getName() {
        return this.name;
    }

    public short getType() {
        return this.type;
    }

    public short getOrdPos() {
        return this.ordPos;
    }

    public String getColName() {
        return this.colName;
    }

    public String getAscdesc() {
        return this.ascdesc;
    }

    public String toString() {
        return "Index " + this.name + " (" + this.table + "." + this.colName + " of type " + this.type + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexData indexData = (IndexData)o;
        if (this.ordPos != indexData.ordPos) {
            return false;
        }
        if (this.type != indexData.type) {
            return false;
        }
        if (this.unique != indexData.unique) {
            return false;
        }
        if (this.ascdesc != null ? !this.ascdesc.equals(indexData.ascdesc) : indexData.ascdesc != null) {
            return false;
        }
        if (this.colName != null ? !this.colName.equals(indexData.colName) : indexData.colName != null) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifier.equals(indexData.qualifier) : indexData.qualifier != null) {
            return false;
        }
        if (this.name != null && !this.name.startsWith("SYS") && !this.name.equals(indexData.name)) {
            return false;
        }
        return this.table.equals(indexData.table);
    }

    public int hashCode() {
        int result = this.table.hashCode();
        result = 29 * result + (this.unique ? 1 : 0);
        result = 29 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        result = 29 * result + this.type;
        result = 29 * result + this.ordPos;
        result = 29 * result + (this.colName != null ? this.colName.hashCode() : 0);
        result = 29 * result + (this.ascdesc != null ? this.ascdesc.hashCode() : 0);
        result = 29 * result + (this.name != null && !this.name.startsWith("SYS") ? this.name.hashCode() : 0);
        return result;
    }
}

