/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.dbutils;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.dbutils.comparison.DbComparator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class CompareHsqlDbs {
    public static Connection getConnection(Properties cfg) throws ClassNotFoundException, SQLException {
        Class.forName(cfg.getProperty("jdbcDriverClass"));
        return DriverManager.getConnection(cfg.getProperty("jdbcUrl"), cfg.getProperty("jdbcUsername"), cfg.getProperty("jdbcPassword"));
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("Usage: comparedbs path/to/db1 path/to/db2");
            }
            Properties cfg = new Properties();
            cfg.setProperty("jdbcDriverClass", "org.hsqldb.jdbcDriver");
            cfg.setProperty("jdbcUsername", "sa");
            cfg.setProperty("jdbcPassword", "");
            cfg.setProperty("jdbcUrl", "jdbc:hsqldb:file:" + args[0]);
            Connection c1 = CompareHsqlDbs.getConnection(cfg);
            cfg.setProperty("jdbcUrl", "jdbc:hsqldb:file:" + args[1]);
            Connection c2 = CompareHsqlDbs.getConnection(cfg);
            DbComparator dbc = new DbComparator(DBType.HSQL, c1, DBType.HSQL, c2, true);
            if (dbc.areEqual()) {
                System.out.println("database meta data is equivalent");
            } else {
                System.out.println("database meta data is NOT equivalent");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

