/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.dbutils;

import com.cenqua.dbutils.comparison.StringCompareSet;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;

public class BaseData {
    protected HashMap<String, Object> row = new HashMap();

    public BaseData(ResultSet rs, StringCompareSet ignoreColumns) throws Exception {
        int numCols = rs.getMetaData().getColumnCount();
        for (int i = 1; i < numCols; ++i) {
            String name = rs.getMetaData().getColumnName(i).toLowerCase();
            if (ignoreColumns.isIn(name, false)) continue;
            this.row.put(name, rs.getObject(i));
        }
    }

    public HashMap getRow() {
        return this.row;
    }

    public String compareReport(BaseData baseData) {
        StringBuilder report = new StringBuilder("{ ");
        HashMap compRow = baseData.getRow();
        for (String key : this.row.keySet()) {
            if (compRow.containsKey(key)) {
                Object o = compRow.get(key);
                if (o == null || o.equals(this.row.get(key))) continue;
                report.append("column ").append(key).append(" ").append(this.row.get(key)).append(" != ").append(compRow.get(key)).append(" ");
                continue;
            }
            report.append("column ").append(key).append(" doesn't exisit\n");
        }
        return report.append("}").toString();
    }

    public String printRow() {
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = this.row.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            result.append(key).append("=").append(this.row.get(key));
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseData baseData = (BaseData)o;
        return this.row.equals(baseData.row);
    }

    public int hashCode() {
        return this.row.hashCode();
    }
}

