/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewIterator;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.util.ReviewSort;
import com.cenqua.crucible.view.ReviewsToDo;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ReviewsToDoTest {
    @Mock
    private EffectiveUserProvider effectiveUserProvider;
    @Mock
    private CurrentUserPermissions currentUserPermissions;
    @Mock
    private ReviewManager reviewManager;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.reviewManager.getReviewIteratorForIds(Mockito.anyCollection(), Mockito.anyInt())).thenAnswer(invocation -> {
            Collection ids = (Collection)invocation.getArguments()[0];
            return new ReviewIterator(ids, this.reviewManager, 1);
        });
        Mockito.when((Object)this.reviewManager.getReviewsOrderedByIds(Mockito.anyList())).thenAnswer(invocation -> {
            Collection ids = (Collection)invocation.getArguments()[0];
            return ids.stream().map(id -> {
                Review r = new Review();
                r.setId(id);
                r.setName("review" + id);
                return r;
            }).collect(Collectors.toList());
        });
        Mockito.when((Object)this.currentUserPermissions.canViewReview((Review)Mockito.any(Review.class))).thenReturn((Object)true);
    }

    @Test
    public void testListLessThenDemanded() throws Exception {
        this.mockFilteredReviews(10, 11);
        ReviewsToDo reviewsToDo = ReviewsToDo.forCurrentUser((EffectiveUserProvider)this.effectiveUserProvider, (CurrentUserPermissions)this.currentUserPermissions, (ReviewManager)this.reviewManager, (int)3);
        Assert.assertThat((Object)reviewsToDo.isPartialList(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat(reviewsToDo.getReviews().stream().map(Review::getId).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new Integer[]{10, 11}));
        Assert.assertThat((Object)reviewsToDo.getSize(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testListEqualToDemanded() throws Exception {
        this.mockFilteredReviews(10, 11, 12);
        ReviewsToDo reviewsToDo = ReviewsToDo.forCurrentUser((EffectiveUserProvider)this.effectiveUserProvider, (CurrentUserPermissions)this.currentUserPermissions, (ReviewManager)this.reviewManager, (int)3);
        Assert.assertThat((Object)reviewsToDo.isPartialList(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat(reviewsToDo.getReviews().stream().map(Review::getId).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new Integer[]{10, 11, 12}));
        Assert.assertThat((Object)reviewsToDo.getSize(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testListGreaterThenDemanded() throws Exception {
        this.mockFilteredReviews(10, 11, 12, 13);
        ReviewsToDo reviewsToDo = ReviewsToDo.forCurrentUser((EffectiveUserProvider)this.effectiveUserProvider, (CurrentUserPermissions)this.currentUserPermissions, (ReviewManager)this.reviewManager, (int)3);
        Assert.assertThat((Object)reviewsToDo.isPartialList(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(reviewsToDo.getReviews().stream().map(Review::getId).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new Integer[]{10, 11, 12}));
        Assert.assertThat((Object)reviewsToDo.getSize(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void testListDoesntContainInaccessibleReviews() throws Exception {
        this.mockFilteredReviews(10, 11, 12, 13);
        Mockito.when((Object)this.currentUserPermissions.canViewReview((Review)Mockito.any(Review.class))).thenAnswer(invocation -> {
            Review review = (Review)invocation.getArguments()[0];
            return !ImmutableSet.of((Object)11, (Object)12).contains((Object)review.getId());
        });
        ReviewsToDo reviewsToDo = ReviewsToDo.forCurrentUser((EffectiveUserProvider)this.effectiveUserProvider, (CurrentUserPermissions)this.currentUserPermissions, (ReviewManager)this.reviewManager, (int)3);
        Assert.assertThat((Object)reviewsToDo.isPartialList(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat(reviewsToDo.getReviews().stream().map(Review::getId).collect(Collectors.toList()), (Matcher)Matchers.contains((Object[])new Integer[]{10, 13}));
        Assert.assertThat((Object)reviewsToDo.getSize(), (Matcher)Matchers.is((Object)2));
    }

    private void mockFilteredReviews(int ... reviewIds) {
        Mockito.when((Object)this.reviewManager.getMatchingReviewIds((ReviewFilterDef)Mockito.any(ReviewFilterDef.class), Mockito.anyString(), (ReviewSort)Mockito.any(ReviewSort.class))).thenReturn((Object)Ints.asList((int[])reviewIds));
    }
}

