/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.view.ReviewParticipantDO;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ReviewParticipantDOTest {
    private ReviewParticipant participant;
    private ReviewParticipantDO participantDO;
    private static final long THIRTY_SEC_IN_MS = 30000L;
    private static final long ONE_MINUTE_IN_MS = 60000L;
    private static final long TWO_MINUTES_IN_MS = 120000L;
    private static final long FIVE_MINUTES_IN_MS = 300000L;
    private static final long TEN_MINUTES_IN_MS = 600000L;

    @Before
    public void setUp() throws Exception {
        this.participant = (ReviewParticipant)Mockito.mock(ReviewParticipant.class);
        this.participantDO = (ReviewParticipantDO)Mockito.mock(ReviewParticipantDO.class);
        this.resetMocks();
    }

    private void resetMocks() {
        Mockito.reset((Object[])new ReviewParticipant[]{this.participant});
        Mockito.reset((Object[])new ReviewParticipantDO[]{this.participantDO});
        Mockito.when((Object)this.participantDO.getParticipant()).thenReturn((Object)this.participant);
        Mockito.when((Object)this.participantDO.getTimeSpent()).thenCallRealMethod();
        Mockito.when((Object)this.participantDO.getTimeSubmitted()).thenCallRealMethod();
        Mockito.when((Object)this.participantDO.getTimeToSubmit()).thenCallRealMethod();
        Mockito.when((Object)this.participantDO.getHasSpentTime()).thenCallRealMethod();
        Mockito.when((Object)this.participantDO.getHasLoggedTime()).thenCallRealMethod();
        Mockito.when((Object)this.participantDO.getHasTimeToSubmit()).thenCallRealMethod();
    }

    @Test
    public void testGetTimeSpent() throws Exception {
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn(null);
        Assert.assertEquals((long)0L, (long)this.participantDO.getTimeSpent());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)30000L);
        Assert.assertEquals((long)30000L, (long)this.participantDO.getTimeSpent());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)60000L);
        Assert.assertEquals((long)60000L, (long)this.participantDO.getTimeSpent());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)300000L);
        Assert.assertEquals((long)300000L, (long)this.participantDO.getTimeSpent());
    }

    @Test
    public void testGetTimeSubmitted() throws Exception {
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn(null);
        Assert.assertEquals((long)0L, (long)this.participantDO.getTimeSubmitted());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)30000L);
        Assert.assertEquals((long)30000L, (long)this.participantDO.getTimeSubmitted());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)60000L);
        Assert.assertEquals((long)60000L, (long)this.participantDO.getTimeSubmitted());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)300000L);
        Assert.assertEquals((long)300000L, (long)this.participantDO.getTimeSubmitted());
    }

    @Test
    public void testGetTimeToSubmit() throws Exception {
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn(null);
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn(null);
        Assert.assertEquals((long)0L, (long)this.participantDO.getTimeToSubmit());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn(null);
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)600000L);
        Assert.assertEquals((long)600000L, (long)this.participantDO.getTimeToSubmit());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)600000L);
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn(null);
        Assert.assertEquals((long)0L, (long)this.participantDO.getTimeToSubmit());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)300000L);
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)600000L);
        Assert.assertEquals((long)300000L, (long)this.participantDO.getTimeToSubmit());
    }

    @Test
    public void testGetHasSpentTime() throws Exception {
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn(null);
        Assert.assertFalse((boolean)this.participantDO.getHasSpentTime());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)0L);
        Assert.assertFalse((boolean)this.participantDO.getHasSpentTime());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)30000L);
        Assert.assertFalse((boolean)this.participantDO.getHasSpentTime());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)60000L);
        Assert.assertTrue((boolean)this.participantDO.getHasSpentTime());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)300000L);
        Assert.assertTrue((boolean)this.participantDO.getHasSpentTime());
    }

    @Test
    public void testGetHasLoggedTime() throws Exception {
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn(null);
        Assert.assertFalse((boolean)this.participantDO.getHasLoggedTime());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)0L);
        Assert.assertFalse((boolean)this.participantDO.getHasLoggedTime());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)30000L);
        Assert.assertFalse((boolean)this.participantDO.getHasLoggedTime());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)60000L);
        Assert.assertTrue((boolean)this.participantDO.getHasLoggedTime());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)300000L);
        Assert.assertTrue((boolean)this.participantDO.getHasLoggedTime());
    }

    @Test
    public void testGetHasTimeToSubmit() throws Exception {
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn(null);
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn(null);
        Assert.assertFalse((boolean)this.participantDO.getHasTimeToSubmit());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)30000L);
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)0L);
        Assert.assertFalse((boolean)this.participantDO.getHasTimeToSubmit());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)300000L);
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)300000L);
        Assert.assertFalse((boolean)this.participantDO.getHasTimeToSubmit());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)60000L);
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)120000L);
        Assert.assertFalse((boolean)this.participantDO.getHasTimeToSubmit());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)120000L);
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)60000L);
        Assert.assertTrue((boolean)this.participantDO.getHasTimeToSubmit());
        this.resetMocks();
        Mockito.when((Object)this.participant.getTimeSpent()).thenReturn((Object)600000L);
        Mockito.when((Object)this.participant.getTimeSubmitted()).thenReturn((Object)300000L);
        Assert.assertTrue((boolean)this.participantDO.getHasTimeToSubmit());
    }
}

