/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.crucible.activity.review.ActivityItemTestBase;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.view.reviewfilters.ReviewFilterDef;
import com.cenqua.crucible.view.reviewfilters.ReviewFilters;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.util.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ReviewFiltersTest
extends ActivityItemTestBase {
    private Set<Pair<ReviewFilters.FilterKey, String>> getFilterKeyPairs() {
        HashSet<Pair<ReviewFilters.FilterKey, String>> pairs = new HashSet<Pair<ReviewFilters.FilterKey, String>>();
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.ALL_REVIEWS, (Object)"allReviews"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.ALL_OPEN_REVIEWS, (Object)"allOpenReviews"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.ALL_CLOSED_REVIEWS, (Object)"allClosedReviews"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.ALL_DRAFT_REVIEWS, (Object)"draftReviews"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.INBOX, (Object)"inbox"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.OUTBOX, (Object)"outbox"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.ARCHIVE, (Object)"archive"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.TO_REVIEW, (Object)"toReview"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.ACTIVE_PARTICIPANT, (Object)"activeParticipant"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.REQUIRE_MY_APPROVAL, (Object)"requireMyApproval"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.TO_SUMMARIZE, (Object)"toSummarize"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.OUT_FOR_REVIEW, (Object)"outForReview"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.MY_DRAFT, (Object)"drafts"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.MY_OPEN, (Object)"open"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.MY_COMPLETED, (Object)"completed"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.MY_CLOSED, (Object)"closed"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.MY_TRASH, (Object)"trash"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.MY_SUMMARIZED, (Object)"summarized"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.MY_TODO, (Object)"todo"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.CUSTOM, (Object)"custom"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.ALL_SNIPPETS, (Object)"allSnippets"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.ALL_OPEN_SNIPPETS, (Object)"allOpenSnippets"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.MY_SNIPPETS, (Object)"mySnippets"));
        pairs.add(Pair.newInstance((Object)ReviewFilters.FilterKey.MY_OPEN_SNIPPETS, (Object)"myOpenSnippets"));
        return pairs;
    }

    @Test
    public void testAllFilterKeysTested() {
        HashSet<ReviewFilters.FilterKey> allKeys = new HashSet<ReviewFilters.FilterKey>();
        allKeys.addAll(Arrays.asList(ReviewFilters.FilterKey.values()));
        for (Pair<ReviewFilters.FilterKey, String> pair : this.getFilterKeyPairs()) {
            allKeys.remove(pair.getFirst());
        }
        Assert.assertTrue((String)"Not all filter keys have had backwards compatibility checks added", (boolean)allKeys.isEmpty());
    }

    @Test
    public void testKeyNameFilterFactory() {
        for (Pair<ReviewFilters.FilterKey, String> pair : this.getFilterKeyPairs()) {
            this.assertFilterKeyByName((ReviewFilters.FilterKey)pair.getFirst(), (String)pair.getSecond());
        }
    }

    private void assertFilterKeyByName(ReviewFilters.FilterKey expected, String key) {
        Assert.assertEquals((String)("The filter id " + key + " did not provide the expected Filter " + expected), (Object)expected, (Object)ReviewFilters.FilterKey.fromId((String)key));
    }

    @Test
    public void testAllKeysReturnFilters() {
        ReviewFilters filters = new ReviewFilters(this.pm.getDefaultProject());
        for (ReviewFilters.FilterKey key : ReviewFilters.FilterKey.values()) {
            Assert.assertNotNull((Object)filters.getFilterDefByKey(key));
        }
    }

    @Test
    public void testProjectReviewFilters() throws Exception {
        ReviewFilters filters = new ReviewFilters(this.pm.getDefaultProject());
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        Review review1 = this.createReview("review1 1", this.currentUser);
        this.reviewManager.addReviewer(review1, ModelUtils.makeAndSaveUser("reviewer"));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_DRAFT_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_OPEN_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_CLOSED_REVIEWS));
        HibernateUtil.beginTransaction();
        this.reviewManager.changeState(review1, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_DRAFT_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_OPEN_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_CLOSED_REVIEWS));
        HibernateUtil.beginTransaction();
        this.reviewManager.changeState(review1, UserActionManager.ACTION_CLOSE, this.currentUser);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_DRAFT_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_OPEN_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_CLOSED_REVIEWS));
        Review review2 = this.createReview("review2", this.currentUser);
        this.assertFilterCount(2, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_DRAFT_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_OPEN_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_CLOSED_REVIEWS));
        HibernateUtil.beginTransaction();
        this.reviewManager.changeState(review2, UserActionManager.ACTION_ABANDON, this.currentUser);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_DRAFT_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_OPEN_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_CLOSED_REVIEWS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserProjectFilters() throws Exception {
        ReviewFilters filters = new ReviewFilters(this.currentUser);
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        HibernateUtil.beginTransaction();
        Review review = this.createReview("other review 1", this.reviewer);
        review.setCreator(this.reviewer);
        review.setAuthor(this.reviewer);
        review.setModerator(this.reviewer);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT));
        HibernateUtil.beginTransaction();
        this.reviewManager.addReviewer(review, this.currentUser);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.INBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUTBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_OPEN));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_COMPLETED));
        HibernateUtil.beginTransaction();
        try {
            this.effectiveUserProvider.pushEffectivePrincipal((Principal)this.reviewerUserLogin, this.reviewer);
            this.reviewManager.changeState(review, UserActionManager.ACTION_APPROVE, this.reviewer);
        }
        finally {
            this.effectiveUserProvider.popEffectivePrincipal();
        }
        HibernateUtil.commitTransaction();
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.INBOX));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUTBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUT_FOR_REVIEW));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_OPEN));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_COMPLETED));
        HibernateUtil.beginTransaction();
        review.setReviewerComplete(this.currentUser);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.INBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUTBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUT_FOR_REVIEW));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_OPEN));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_COMPLETED));
        review = this.createReview("my review 1", this.currentUser);
        HibernateUtil.beginTransaction();
        this.reviewManager.addReviewer(review, this.reviewer);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(2, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.INBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_DRAFT));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUTBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUT_FOR_REVIEW));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_OPEN));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_COMPLETED));
        HibernateUtil.beginTransaction();
        this.reviewManager.changeState(review, UserActionManager.ACTION_APPROVE, this.currentUser);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(2, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.INBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_SUMMARIZE));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_DRAFT));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT));
        this.assertFilterCount(2, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUTBOX));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUT_FOR_REVIEW));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_OPEN));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_COMPLETED));
        HibernateUtil.beginTransaction();
        try {
            this.setProjectPermissionScheme(review.getProject().getProjKey(), "default");
            this.reviewManager.changeState(review, UserActionManager.ACTION_SUMMARIZE, this.currentUser);
        }
        finally {
            this.setProjectPermissionScheme(review.getProject().getProjKey(), "agile");
        }
        HibernateUtil.commitTransaction();
        this.assertFilterCount(2, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.INBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_SUMMARIZE));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_DRAFT));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUTBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUT_FOR_REVIEW));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_OPEN));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_COMPLETED));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_SUMMARIZED));
        HibernateUtil.beginTransaction();
        this.reviewManager.changeState(review, UserActionManager.ACTION_REOPEN, this.currentUser);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(2, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.INBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_SUMMARIZE));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_DRAFT));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT));
        this.assertFilterCount(2, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUTBOX));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUT_FOR_REVIEW));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_OPEN));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_COMPLETED));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_SUMMARIZED));
        HibernateUtil.beginTransaction();
        review.setReviewerComplete(this.reviewer);
        HibernateUtil.commitTransaction();
        this.assertFilterCount(2, filters.getFilterDefByKey(ReviewFilters.FilterKey.ALL_REVIEWS));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.INBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_REVIEW));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.TO_SUMMARIZE));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_DRAFT));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.ACTIVE_PARTICIPANT));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUTBOX));
        this.assertFilterCount(0, filters.getFilterDefByKey(ReviewFilters.FilterKey.OUT_FOR_REVIEW));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_OPEN));
        this.assertFilterCount(1, filters.getFilterDefByKey(ReviewFilters.FilterKey.MY_COMPLETED));
    }

    private void setProjectPermissionScheme(String projectKey, String permissionSchemeName) {
        PermissionManager permissionManager = (PermissionManager)SpringContext.getComponentByClass(PermissionManager.class);
        PermissionScheme permissionScheme = permissionManager.findPermissionSchemeByName(permissionSchemeName);
        ProjectManager projectManager = (ProjectManager)SpringContext.getComponentByClass(ProjectManager.class);
        Project project = projectManager.getProjectByKey(projectKey);
        project.setPermissionScheme(permissionScheme);
    }

    private Review createReview(String name, FecruUser user) throws Exception {
        HibernateUtil.beginTransaction();
        Review review = this.reviewManager.createReviewWithDefaults(ModelUtils.getProjectManager(), this.pm.getDefaultProject(), name, user);
        review.setCreator(user);
        review.setAuthor(user);
        review.setModerator(user);
        HibernateUtil.commitTransaction();
        return review;
    }

    private void assertFilterCount(int filterCount, ReviewFilterDef f) {
        int count = this.reviewManager.getMatchingReviewCount(f);
        Assert.assertEquals((String)("Filter " + f.filterName + " returned " + count + " reviews, but was expecting " + filterCount), (long)filterCount, (long)count);
    }
}

