/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.UserProfileManager;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.StoredPathFactoryTestHelper;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.spi.ServiceTestBase;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.crucible.view.FRXNavList;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class FRXNavListTest
extends ServiceTestBase {
    private FRXNavList frxNavList;
    private List<FRXDO> frxDOs;
    private List<FRXNavList.FRXNavListNode> nodes;
    private UnreadManager unreadManager;
    private UnreadFileManager unreadFileManager;
    private UserProfileManager userProfileManager;
    private static final String REPO = "cvs";
    private int frxId = 1;
    private int frxRevId = 1;
    private int crId = 1;

    @Before
    public void setUp() throws Exception {
        this.unreadManager = new UnreadManager();
        this.unreadFileManager = new UnreadFileManager();
        this.userProfileManager = AppConfig.getsConfig().getUserProfileManager();
        this.frxDOs = new ArrayList<FRXDO>();
        this.frxDOs.add(this.createFrxDO("/the/quick/fox"));
        this.frxDOs.add(this.createFrxDO("/the/quick/jumps/lazy"));
        this.frxDOs.add(this.createDirectoryFrxDO("/the/brown"));
        this.frxDOs.add(this.createFrxDO("/the/brown/over/the/dog"));
        this.frxNavList = new FRXNavList(this.frxDOs.iterator(), (SourceFactory)this.sourceFactory, this.txTemplate.getEffectivePrincipal());
        this.nodes = this.frxNavList.getNavList();
    }

    private FRXDO createFrxDO(String path) {
        FileRevisionExtraInfo frx = new FileRevisionExtraInfo();
        frx.setId(Integer.valueOf(this.frxId++));
        CrucibleRevision cr = new CrucibleRevision();
        cr.setId(Integer.valueOf(this.crId++));
        cr.setStoredPath(StoredPathFactoryTestHelper.makeStoredPath(path));
        cr.setSourceName(REPO);
        FRXRevision frxRev = new FRXRevision(frx, cr, new Date());
        frxRev.setId(Integer.valueOf(this.frxRevId++));
        frx.getFrxRevisions().add(frxRev);
        return new FRXDO(this.contentManager, this.unreadManager, this.unreadFileManager, this.userProfileManager, frx, this.currentCrucibleUser, (Principal)this.txTemplate.getEffectiveUserLogin(), (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), null, false, false, (SourceFactory)this.sourceFactory, true, true);
    }

    private FRXDO createFrxDO(int id, Path path) {
        FRXDO frxDO = this.createFrxDO(path.getPath());
        frxDO.getFrx().setId(Integer.valueOf(id));
        return frxDO;
    }

    private FRXDO createFrxDOWithBranch(String branch, String path) {
        FRXDO frxDO = this.createFrxDO(path);
        frxDO.getFrx().getFileRevision().getDetails().put("branch", branch);
        return frxDO;
    }

    private FRXDO createDirectoryFrxDO(String path) {
        FRXDO frxDO = this.createFrxDO(path);
        CrucibleRevision crev = frxDO.getToFrxRevision().getRevision();
        crev.setFileType(ContentManager.FileType.DIRECTORY.name());
        return frxDO;
    }

    @Test
    public void testSimpleFrxTreeList() {
        this.assertNodeEquals(this.nodes.get(0), REPO, -1, false);
        this.assertNodeEquals(this.nodes.get(1), "the", 0, false);
        this.assertNodeEquals(this.nodes.get(2), "brown", 1, false);
        this.assertNodeEquals(this.nodes.get(3), "over/the", 2, false);
        this.assertNodeEquals(this.nodes.get(4), "dog", 3, true);
        this.assertNodeEquals(this.nodes.get(5), "quick", 1, false);
        this.assertNodeEquals(this.nodes.get(6), "jumps", 2, false);
        this.assertNodeEquals(this.nodes.get(7), "lazy", 3, true);
        this.assertNodeEquals(this.nodes.get(8), "fox", 2, true);
    }

    @Test
    public void testComplexFrxTreeList() {
        this.frxDOs.add(this.createFrxDO("/the2/quick2"));
        this.frxNavList = new FRXNavList(this.frxDOs.iterator(), (SourceFactory)this.sourceFactory, this.txTemplate.getEffectivePrincipal());
        this.nodes = this.frxNavList.getNavList();
        this.testSimpleFrxTreeList();
        this.assertNodeEquals(this.nodes.get(9), "the2", 0, false);
        this.assertNodeEquals(this.nodes.get(10), "quick2", 1, true);
    }

    @Test
    public void testFrxsWithTheSamePath() {
        this.frxDOs.add(this.createDirectoryFrxDO("/the/quick"));
        this.frxDOs.add(this.createFrxDO("/the/quick/fox"));
        this.frxNavList = new FRXNavList(this.frxDOs.iterator(), (SourceFactory)this.sourceFactory, this.txTemplate.getEffectivePrincipal());
        this.nodes = this.frxNavList.getNavList();
        this.assertNodeEquals(this.nodes.get(0), REPO, -1, false);
        this.assertNodeEquals(this.nodes.get(1), "the", 0, false);
        this.assertNodeEquals(this.nodes.get(2), "brown", 1, false);
        this.assertNodeEquals(this.nodes.get(3), "over/the", 2, false);
        this.assertNodeEquals(this.nodes.get(4), "dog", 3, true);
        this.assertNodeEquals(this.nodes.get(5), "quick", 1, false);
        this.assertNodeEquals(this.nodes.get(6), "jumps", 2, false);
        this.assertNodeEquals(this.nodes.get(7), "lazy", 3, true);
        this.assertNodeEquals(this.nodes.get(8), "fox", 2, true);
        this.assertNodeEquals(this.nodes.get(9), "fox", 2, true);
    }

    private void assertNodeEquals(FRXNavList.FRXNavListNode node, String path, int depth, boolean isLeaf) {
        Assert.assertEquals((Object)path, (Object)node.getPath());
        Assert.assertEquals((long)depth, (long)node.getDepth());
        Assert.assertEquals((Object)isLeaf, (Object)node.isLeaf());
    }

    @Test
    public void testEmptyFolderOrdering() {
        this.frxDOs = new ArrayList<FRXDO>();
        this.frxDOs.add(this.createDirectoryFrxDO("/e-dir/"));
        this.frxDOs.add(this.createFrxDO("/a-dir/file"));
        this.frxDOs.add(this.createFrxDO("/b-file"));
        this.frxDOs.add(this.createFrxDO("/c-file"));
        this.frxDOs.add(this.createDirectoryFrxDO("/d-dir"));
        this.frxNavList = new FRXNavList(this.frxDOs.iterator(), (SourceFactory)this.sourceFactory, this.txTemplate.getEffectivePrincipal());
        this.nodes = this.frxNavList.getNavList();
        this.assertNodeEquals(this.nodes.get(0), REPO, -1, false);
        this.assertNodeEquals(this.nodes.get(1), "a-dir", 0, false);
        this.assertNodeEquals(this.nodes.get(2), "file", 1, true);
        this.assertNodeEquals(this.nodes.get(3), "d-dir", 0, true);
        this.assertNodeEquals(this.nodes.get(4), "e-dir", 0, true);
        this.assertNodeEquals(this.nodes.get(5), "b-file", 0, true);
        this.assertNodeEquals(this.nodes.get(6), "c-file", 0, true);
    }

    @Test
    public void testSortedFrxs() {
        Path p0 = new Path((CharSequence)"trunk/src/java/com/atlassian/crucible/activity/review/annotation/");
        Path p1 = new Path((CharSequence)"trunk/src/java/com/atlassian/crucible/activity/review/annotation/CrucibleActivity.java");
        Path p2 = new Path((CharSequence)"trunk/src/java/com/atlassian/crucible/activity/review/ssss");
        Path p3 = new Path((CharSequence)"trunk/src/java/com/atlassian/crucible/activity/review/ssss/1234");
        Path p4 = new Path((CharSequence)"trunk/src/java/com/atlassian/crucible/activity/review/ReviewCommentActivityItemProvider.java");
        Path p5 = new Path((CharSequence)"trunk/src/java/com/atlassian/crucible/activity/review/ReviewCompletionActivityItemProvider.java");
        Path p6 = new Path((CharSequence)"trunk/src/java/com/atlassian/crucible/activity/review/ReviewStateChangeActivityItemProvider.java");
        Path p7 = new Path((CharSequence)"trunk/src/java/com/atlassian/crucible/activity/review/qqqq");
        Path p8 = new Path((CharSequence)"trunk/src/java/com/atlassian/fisheye/activity/annotation/ActivityProvider.java");
        Path p9 = new Path((CharSequence)"trunk/src/java/com/atlassian/fisheye/activity/annotation/ActivityProviderType.java");
        Path p10 = new Path((CharSequence)"trunk/src/java/com/atlassian/fisheye/activity/annotation/FisheyeActivity.java");
        Path p11 = new Path((CharSequence)"trunk/src/java/com/atlassian/fisheye/activity/external/jira/annotation/");
        Path p12 = new Path((CharSequence)"trunk/src/java/com/atlassian/fisheye/activity/external/jira/annotation/JiraActivity.java");
        Path p13 = new Path((CharSequence)"trunk/src/java/com/atlassian/fisheye/activity/external/jira/JiraActivityItemProvider.java");
        Path p14 = new Path((CharSequence)"trunk/src/java/com/atlassian/fisheye/activity/DefaultActivityItemManager.java");
        Path p15 = new Path((CharSequence)"trunk/src/java/com/cenqua/fisheye/rep/DelegatingRepositorySearcher.java");
        this.frxDOs = new ArrayList<FRXDO>();
        this.frxDOs.add(this.createFrxDO(2, p2));
        this.frxDOs.add(this.createFrxDO(5, p5));
        this.frxDOs.add(this.createFrxDO(14, p14));
        this.frxDOs.add(this.createFrxDO(15, p15));
        this.frxDOs.add(this.createFrxDO(0, p0));
        this.frxDOs.add(this.createFrxDO(11, p11));
        this.frxDOs.add(this.createFrxDO(3, p3));
        this.frxDOs.add(this.createFrxDO(6, p6));
        this.frxDOs.add(this.createFrxDO(10, p10));
        this.frxDOs.add(this.createFrxDO(4, p4));
        this.frxDOs.add(this.createFrxDO(7, p7));
        this.frxDOs.add(this.createFrxDO(9, p9));
        this.frxDOs.add(this.createFrxDO(8, p8));
        this.frxDOs.add(this.createFrxDO(13, p13));
        this.frxDOs.add(this.createFrxDO(1, p1));
        this.frxDOs.add(this.createFrxDO(12, p12));
        this.frxNavList = new FRXNavList(this.frxDOs.iterator(), (SourceFactory)this.sourceFactory, this.txTemplate.getEffectivePrincipal());
        this.nodes = this.frxNavList.getNavList();
        List frxs = FRXManager.filterNodesForFrxs(this.nodes);
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((Object)new Integer(i), (Object)((FileRevisionExtraInfo)frxs.get(i)).getId());
        }
    }

    @Test
    public void testRootPath() {
        this.frxDOs = new ArrayList<FRXDO>();
        this.frxDOs.add(this.createDirectoryFrxDO("/"));
        this.frxDOs.add(this.createFrxDO("/file.txt"));
        this.frxNavList = new FRXNavList(this.frxDOs.iterator(), (SourceFactory)this.sourceFactory, this.txTemplate.getEffectivePrincipal());
        this.nodes = this.frxNavList.getNavList();
        this.assertNodeEquals(this.nodes.get(0), REPO, -1, false);
        this.assertNodeEquals(this.nodes.get(1), "/", 0, false);
        this.assertNodeEquals(this.nodes.get(2), "file.txt", 1, true);
    }

    @Test
    public void testRootPathReverseOrdering() {
        this.frxDOs = new ArrayList<FRXDO>();
        this.frxDOs.add(this.createFrxDO("/file.txt"));
        this.frxDOs.add(this.createDirectoryFrxDO("/"));
        this.frxNavList = new FRXNavList(this.frxDOs.iterator(), (SourceFactory)this.sourceFactory, this.txTemplate.getEffectivePrincipal());
        this.nodes = this.frxNavList.getNavList();
        this.assertNodeEquals(this.nodes.get(0), REPO, -1, false);
        this.assertNodeEquals(this.nodes.get(1), "/", 0, false);
        this.assertNodeEquals(this.nodes.get(2), "file.txt", 1, true);
    }

    @Test
    public void testSameFilesInDifferentBranches() {
        this.frxDOs = new ArrayList<FRXDO>();
        this.frxDOs.add(this.createFrxDOWithBranch("trunk", "/file.txt"));
        this.frxDOs.add(this.createFrxDOWithBranch("otherBranch", "/file.txt"));
        this.frxDOs.add(this.createFrxDOWithBranch("other-branch", "/file.txt"));
        this.frxNavList = new FRXNavList(this.frxDOs.iterator(), (SourceFactory)this.sourceFactory, this.txTemplate.getEffectivePrincipal());
        this.nodes = this.frxNavList.getNavList();
        this.assertNodeEquals(this.nodes.get(0), "cvs (other-branch)", -1, false);
        this.assertNodeEquals(this.nodes.get(1), "file.txt", 0, true);
        this.assertNodeEquals(this.nodes.get(2), "cvs (otherBranch)", -1, false);
        this.assertNodeEquals(this.nodes.get(3), "file.txt", 0, true);
        this.assertNodeEquals(this.nodes.get(4), "cvs (trunk)", -1, false);
        this.assertNodeEquals(this.nodes.get(5), "file.txt", 0, true);
    }
}

