/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.AnchorData;
import com.atlassian.crucible.testutil.MockFrxRevisionBuilder;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.UserProfileManager;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StoredPathFactoryTestHelper;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.spi.ServiceTestBase;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class FRXDOIntegrationTest
extends ServiceTestBase {
    private UnreadManager unreadManager;
    private UnreadFileManager unreadFileManager;
    private UserProfileManager userProfileManager;

    @Before
    public void setUp() throws Exception {
        ProjectManager projectManager = ModelUtils.getProjectManager();
        projectManager.createProject("Test Project", "TP");
        this.unreadManager = new UnreadManager();
        this.unreadFileManager = new UnreadFileManager();
        this.userProfileManager = (UserProfileManager)SpringContext.getComponentByClass(UserProfileManager.class);
    }

    @Test
    public void testAnchoring() throws Exception {
        FRXDO frxDO;
        HibernateUtil.beginTransaction();
        ProjectManager pm = ModelUtils.getProjectManager();
        Review review = this.reviewManager.createReviewWithDefaults(pm, pm.getDefaultProject(), "My Unanchored Patch Review", this.currentCrucibleUser);
        review.setCreator(this.currentCrucibleUser);
        review.setAuthor(this.currentCrucibleUser);
        File file = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/cru-testfiles/spi/anchor.patch");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(file);
        IOUtils.copy((InputStream)fis, (OutputStream)baos);
        PermId permaId = new PermId(review.getPermaId());
        this.reviewService.addPatchToReview(permaId, new String(baos.toByteArray()));
        review = this.reviewManager.getReviewById(review.getId());
        for (FileRevisionExtraInfo frx : review.getFrxs()) {
            FRXDO frxDO2 = this.contentManager.makeFRXDO(frx, this.currentCrucibleUser, this.txTemplate.getEffectivePrincipal(), (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), "", false, false, false);
            Assert.assertTrue((boolean)frxDO2.isPatch());
            Assert.assertEquals(null, (Object)frxDO2.getAnchoredSourceName());
            Assert.assertFalse((boolean)frxDO2.isAnchorFailure());
        }
        review = this.reviewManager.createReviewWithDefaults(pm, pm.getDefaultProject(), "My Anchored Patch Review", this.currentCrucibleUser);
        review.setCreator(this.currentCrucibleUser);
        review.setAuthor(this.currentCrucibleUser);
        permaId = new PermId(review.getPermaId());
        AnchorData anchorData = new AnchorData("cvs");
        this.reviewService.addPatchToReview(permaId, new String(baos.toByteArray()), anchorData);
        review = this.reviewManager.getReviewById(review.getId());
        for (FileRevisionExtraInfo frx : review.getFrxs()) {
            frxDO = this.contentManager.makeFRXDO(frx, this.currentCrucibleUser, this.txTemplate.getEffectivePrincipal(), (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), "", false, false, false);
            Assert.assertTrue((boolean)frxDO.isPatch());
            Assert.assertEquals((Object)"cvs", (Object)frxDO.getAnchoredSourceName());
            Assert.assertFalse((boolean)frxDO.isAnchorFailure());
        }
        review = this.reviewManager.createReviewWithDefaults(pm, pm.getDefaultProject(), "My Half Anchored Patch Review", this.currentCrucibleUser);
        review.setCreator(this.currentCrucibleUser);
        review.setAuthor(this.currentCrucibleUser);
        file = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/cru-testfiles/spi/half-anchor.patch");
        baos = new ByteArrayOutputStream();
        fis = new FileInputStream(file);
        IOUtils.copy((InputStream)fis, (OutputStream)baos);
        permaId = new PermId(review.getPermaId());
        this.reviewService.addPatchToReview(permaId, new String(baos.toByteArray()), anchorData);
        review = this.reviewManager.getReviewById(review.getId());
        for (FileRevisionExtraInfo frx : review.getFrxs()) {
            frxDO = this.contentManager.makeFRXDO(frx, this.currentCrucibleUser, this.txTemplate.getEffectivePrincipal(), (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), "", false, false, false);
            Assert.assertTrue((boolean)frxDO.isPatch());
            if ("an-unknown-file".equals(frxDO.getFePath().getName())) {
                Assert.assertEquals((Object)"cvs", (Object)frxDO.getAnchoredSourceName());
                Assert.assertTrue((boolean)frxDO.isAnchorFailure());
                continue;
            }
            Assert.assertEquals((Object)"cvs", (Object)frxDO.getAnchoredSourceName());
            Assert.assertFalse((boolean)frxDO.isAnchorFailure());
        }
        HibernateUtil.forceRollbackTransaction();
    }

    @Test
    public void testIsBinary() throws Exception {
        String path = "CRUC-729/file.ext";
        HibernateUtil.beginTransaction();
        ProjectManager pm = ModelUtils.getProjectManager();
        Review review = this.reviewManager.createReviewWithDefaults(pm, pm.getDefaultProject(), "My Review", this.txTemplate.getEffectiveCrucibleUser());
        Source source = this.sourceFactory.getSource("svn", (Principal)this.txTemplate.getEffectiveUserLogin());
        CrucibleRevision to = this.contentManager.getCrucibleRevision(source, new RevInfoKey(new Path((CharSequence)"CRUC-729/file.ext"), "7"));
        FileRevisionExtraInfo frxInfo = review.addRevision(to);
        CrucibleRevision revToRemove = frxInfo.getFromRevision();
        frxInfo.addRevision(0, this.contentManager.getCrucibleRevision(source, new RevInfoKey(new Path((CharSequence)"CRUC-729/file.ext"), "6")));
        frxInfo.removeRevision(revToRemove);
        FRXDO frxdo = new FRXDO(this.contentManager, this.unreadManager, this.unreadFileManager, this.userProfileManager, frxInfo, this.currentCrucibleUser, (Principal)this.txTemplate.getEffectiveUserLogin(), (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), null, false, false, (SourceFactory)this.sourceFactory, true, true);
        Assert.assertEquals((Object)"CRUC-729/file.ext", (Object)frxdo.getPath());
        Assert.assertFalse((boolean)frxdo.isDir());
        Assert.assertFalse((boolean)frxdo.isDeleted());
        Assert.assertTrue((boolean)frxdo.isBinary());
        Assert.assertFalse((boolean)frxdo.isText());
        CrucibleRevision revToRemove2 = frxInfo.getFromRevision();
        frxInfo.addRevision(0, this.contentManager.getCrucibleRevision(source, new RevInfoKey(new Path((CharSequence)"CRUC-729/file.ext"), "5")));
        frxInfo.removeRevision(revToRemove2);
        revToRemove2 = frxInfo.getFileRevision();
        frxInfo.removeRevision(revToRemove2);
        frxInfo.addRevision(frxInfo.getFrxRevisions().size(), this.contentManager.getCrucibleRevision(source, new RevInfoKey(new Path((CharSequence)"CRUC-729/file.ext"), "6")));
        FRXDO frxdo2 = new FRXDO(this.contentManager, this.unreadManager, this.unreadFileManager, this.userProfileManager, frxInfo, this.currentCrucibleUser, (Principal)this.txTemplate.getEffectiveUserLogin(), (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), null, false, false, (SourceFactory)this.sourceFactory, true, true);
        Assert.assertEquals((Object)"CRUC-729/file.ext", (Object)frxdo2.getPath());
        Assert.assertFalse((boolean)frxdo2.isDir());
        Assert.assertFalse((boolean)frxdo2.isDeleted());
        Assert.assertTrue((boolean)frxdo2.isBinary());
        Assert.assertFalse((boolean)frxdo2.isText());
        revToRemove2 = frxInfo.getFromRevision();
        frxInfo.addRevision(0, this.contentManager.getCrucibleRevision(source, new RevInfoKey(new Path((CharSequence)"CRUC-729/file.ext"), "5")));
        frxInfo.removeRevision(revToRemove2);
        revToRemove2 = frxInfo.getFileRevision();
        frxInfo.addRevision(frxInfo.getFrxRevisions().size(), this.contentManager.getCrucibleRevision(source, new RevInfoKey(new Path((CharSequence)"CRUC-729/file.ext"), "7")));
        frxInfo.removeRevision(revToRemove2);
        frxdo2 = new FRXDO(this.contentManager, this.unreadManager, this.unreadFileManager, this.userProfileManager, frxInfo, this.currentCrucibleUser, (Principal)this.txTemplate.getEffectiveUserLogin(), (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), null, false, false, (SourceFactory)this.sourceFactory, true, true);
        Assert.assertEquals((Object)"CRUC-729/file.ext", (Object)frxdo2.getPath());
        Assert.assertFalse((boolean)frxdo2.isDir());
        Assert.assertFalse((boolean)frxdo2.isDeleted());
        Assert.assertFalse((boolean)frxdo2.isBinary());
        Assert.assertTrue((boolean)frxdo2.isText());
        String toRevPath = "fred/jim/file.txt";
        CrucibleRevision toRev = FileRevisionManager.createRevision((String)"svn", (String)toRevPath, (String)"1234", (String)"1234", (Date)new Date());
        CrucibleRevision fromRev = FileRevisionManager.createRevision((String)"svn", (String)toRevPath, (String)"1233", (String)"1233", (Date)new Date());
        toRev.setDeletion(Boolean.TRUE);
        toRev.getDetails().put("binary", "true");
        fromRev.getDetails().put("binary", "true");
        CrucibleRevision revToRemove3 = frxInfo.getFileRevision();
        frxInfo.addRevision(frxInfo.getFrxRevisions().size(), toRev);
        frxInfo.removeRevision(revToRemove3);
        revToRemove3 = frxInfo.getFromRevision();
        frxInfo.addRevision(0, fromRev);
        frxInfo.removeRevision(revToRemove3);
        FRXDO frxdo3 = new FRXDO(this.contentManager, this.unreadManager, this.unreadFileManager, this.userProfileManager, frxInfo, this.currentCrucibleUser, (Principal)this.txTemplate.getEffectiveUserLogin(), (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), null, false, false, (SourceFactory)this.sourceFactory, true, true);
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertTrue((boolean)frxdo3.isDeleted());
        Assert.assertTrue((boolean)frxdo3.isBinary());
        Assert.assertFalse((boolean)frxdo3.isText());
        fromRev.getDetails().put("binary", "false");
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertTrue((boolean)frxdo3.isDeleted());
        Assert.assertFalse((boolean)frxdo3.isBinary());
        Assert.assertTrue((boolean)frxdo3.isText());
        fromRev.getDetails().remove("binary");
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertTrue((boolean)frxdo3.isDeleted());
        Assert.assertFalse((boolean)frxdo3.isBinary());
        Assert.assertTrue((boolean)frxdo3.isText());
        toRev.setStoredPath(StoredPathFactoryTestHelper.makeStoredPath("picture.jpg"));
        Assert.assertEquals((Object)"picture.jpg", (Object)frxdo3.getPath());
        Assert.assertTrue((boolean)frxdo3.isDeleted());
        Assert.assertTrue((boolean)frxdo3.isBinary());
        Assert.assertFalse((boolean)frxdo3.isText());
        frxInfo.removeRevision(frxInfo.getFromRevision());
        Assert.assertEquals((Object)"picture.jpg", (Object)frxdo3.getPath());
        Assert.assertTrue((boolean)frxdo3.isDeleted());
        Assert.assertTrue((boolean)frxdo3.isBinary());
        Assert.assertFalse((boolean)frxdo3.isText());
        toRev.getDetails().put("binary", "false");
        Assert.assertEquals((Object)"picture.jpg", (Object)frxdo3.getPath());
        Assert.assertTrue((boolean)frxdo3.isDeleted());
        Assert.assertTrue((boolean)frxdo3.isBinary());
        Assert.assertFalse((boolean)frxdo3.isText());
        toRev.setStoredPath(StoredPathFactoryTestHelper.makeStoredPath(toRevPath));
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertTrue((boolean)frxdo3.isDeleted());
        Assert.assertFalse((boolean)frxdo3.isBinary());
        Assert.assertTrue((boolean)frxdo3.isText());
        toRev.setDeletion(Boolean.FALSE);
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertFalse((boolean)frxdo3.isDeleted());
        Assert.assertFalse((boolean)frxdo3.isBinary());
        Assert.assertTrue((boolean)frxdo3.isText());
        toRev.getDetails().put("binary", "true");
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertFalse((boolean)frxdo3.isDeleted());
        Assert.assertTrue((boolean)frxdo3.isBinary());
        Assert.assertFalse((boolean)frxdo3.isText());
        toRev.getDetails().remove("binary");
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertFalse((boolean)frxdo3.isDeleted());
        Assert.assertFalse((boolean)frxdo3.isBinary());
        Assert.assertTrue((boolean)frxdo3.isText());
        toRev.setStoredPath(StoredPathFactoryTestHelper.makeStoredPath("picture.jpg"));
        Assert.assertEquals((Object)"picture.jpg", (Object)frxdo3.getPath());
        Assert.assertFalse((boolean)frxdo3.isDeleted());
        Assert.assertTrue((boolean)frxdo3.isBinary());
        Assert.assertFalse((boolean)frxdo3.isText());
        revToRemove3 = frxInfo.getFromRevision();
        frxInfo.addRevision(0, fromRev);
        frxInfo.removeRevision(revToRemove3);
        fromRev.getDetails().put("binary", "true");
        toRev.setStoredPath(StoredPathFactoryTestHelper.makeStoredPath(toRevPath));
        toRev.getDetails().put("binary", "false");
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertFalse((boolean)frxdo3.isDeleted());
        Assert.assertTrue((boolean)frxdo3.isBinary());
        Assert.assertFalse((boolean)frxdo3.isText());
        fromRev.getDetails().put("binary", "false");
        Assert.assertFalse((boolean)frxdo3.isBinary());
        Assert.assertTrue((boolean)frxdo3.isText());
        toRev.getDetails().put("binary", "true");
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertFalse((boolean)frxdo3.isDeleted());
        Assert.assertTrue((boolean)frxdo3.isBinary());
        Assert.assertFalse((boolean)frxdo3.isText());
        toRev.getDetails().remove("binary");
        Assert.assertEquals((Object)toRevPath, (Object)frxdo3.getPath());
        Assert.assertFalse((boolean)frxdo3.isDeleted());
        Assert.assertFalse((boolean)frxdo3.isBinary());
        Assert.assertTrue((boolean)frxdo3.isText());
        toRev.setStoredPath(StoredPathFactoryTestHelper.makeStoredPath("picture.jpg"));
        Assert.assertEquals((Object)"picture.jpg", (Object)frxdo3.getPath());
        Assert.assertFalse((boolean)frxdo3.isDeleted());
        Assert.assertTrue((boolean)frxdo3.isBinary());
        Assert.assertFalse((boolean)frxdo3.isText());
        HibernateUtil.forceRollbackTransaction();
    }

    @Test
    public void testSbsDiffNotOverriddenWhenAddRevision() throws Exception {
        SourceFactory sourceFactory = (SourceFactory)Mockito.mock(SourceFactory.class);
        Source source = (Source)Mockito.mock(Source.class);
        Mockito.when((Object)source.isAvailable()).thenReturn((Object)true);
        Mockito.when((Object)sourceFactory.getSource(Matchers.anyString(), (Principal)Matchers.any(Principal.class))).thenReturn((Object)source);
        FileRevisionExtraInfo frx = (FileRevisionExtraInfo)Mockito.mock(FileRevisionExtraInfo.class);
        FRXRevision frxRev = MockFrxRevisionBuilder.newInstance().build();
        Mockito.when((Object)frx.getFileFRXRevision()).thenReturn((Object)frxRev);
        FRXDO frxdo = new FRXDO((ContentManager)Mockito.mock(ContentManager.class), (UnreadManager)Mockito.mock(UnreadManager.class), (UnreadFileManager)Mockito.mock(UnreadFileManager.class), (UserProfileManager)Mockito.mock(UserProfileManager.class), frx, null, (Principal)Principal.Anonymous.ANON, (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), null, false, false, sourceFactory, false, false);
        Assert.assertFalse((boolean)frxdo.isSideBySide());
        Assert.assertFalse((boolean)frxdo.isSetToSideBySide());
        FRXRevision fromFrxRev = MockFrxRevisionBuilder.newInstance().build();
        frxdo.setFromFrxRevision(frxRev);
        frxdo.setToFrxRevision(frxRev);
        frxdo.resetDiff();
        frxdo.setSideBySide(true);
        Assert.assertFalse((boolean)frxdo.isSideBySide());
        Assert.assertTrue((boolean)frxdo.isSetToSideBySide());
        frxdo.setFromFrxRevision(fromFrxRev);
        frxdo.setToFrxRevision(frxRev);
        frxdo.resetDiff();
        Assert.assertTrue((boolean)frxdo.isSideBySide());
        Assert.assertTrue((boolean)frxdo.isSetToSideBySide());
    }
}

