/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.atlassian.crucible.spi.data.FisheyeReviewItemData;
import com.atlassian.crucible.testutil.MockCrucibleRevisionBuilder;
import com.atlassian.crucible.testutil.MockFileRevisionExtraInfoBuilder;
import com.atlassian.crucible.testutil.MockFrxRevisionBuilder;
import com.atlassian.fecru.security.CurrentUserPermissions;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfileManager;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.UnreadFileManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.SourceFactory;
import com.cenqua.crucible.view.FRXDO;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class FRXDOCommitTypeTest {
    @Test
    public void commitTypeShouldBeUnknown_noStatesSet() throws Exception {
        FRXDO frxdoNotAsDiff = this.buildFRXDO(false, MockCrucibleRevisionBuilder.newInstance(), MockCrucibleRevisionBuilder.newInstance());
        FRXDO frxdoShowAsDiff = this.buildFRXDO(true, MockCrucibleRevisionBuilder.newInstance(), MockCrucibleRevisionBuilder.newInstance());
        FisheyeReviewItemData.CommitType notAsDiffType = frxdoNotAsDiff.getCommitType();
        FisheyeReviewItemData.CommitType showAsDiffType = frxdoShowAsDiff.getCommitType();
        Assert.assertThat((Object)notAsDiffType, (Matcher)Matchers.equalTo((Object)FisheyeReviewItemData.CommitType.Unknown));
        Assert.assertThat((Object)showAsDiffType, (Matcher)Matchers.equalTo((Object)FisheyeReviewItemData.CommitType.Unknown));
    }

    @Test
    public void commitTypeShouldBeAdded_firstRevisionIsAdded_toIsNotRemoved() throws Exception {
        FRXDO frxdo = this.buildFRXDO(false, MockCrucibleRevisionBuilder.newInstance().added(true), MockCrucibleRevisionBuilder.newInstance());
        FisheyeReviewItemData.CommitType type = frxdo.getCommitType();
        Assert.assertThat((Object)type, (Matcher)Matchers.equalTo((Object)FisheyeReviewItemData.CommitType.Added));
    }

    @Test
    public void commitTypeShouldBeRemoved_firstRevisionIsAdded_toIsRemoved() throws Exception {
        MockCrucibleRevisionBuilder addedRev = MockCrucibleRevisionBuilder.newInstance().added(true);
        MockCrucibleRevisionBuilder removedRev = MockCrucibleRevisionBuilder.newInstance().deletion(true);
        FRXDO frxdoNotAsDiff = this.buildFRXDO(false, addedRev, removedRev);
        FRXDO frxdoShowAsDiff = this.buildFRXDO(true, addedRev, removedRev);
        FisheyeReviewItemData.CommitType notAsDiffType = frxdoNotAsDiff.getCommitType();
        FisheyeReviewItemData.CommitType showAsDiffType = frxdoShowAsDiff.getCommitType();
        Assert.assertThat((Object)notAsDiffType, (Matcher)Matchers.equalTo((Object)FisheyeReviewItemData.CommitType.Deleted));
        Assert.assertThat((Object)showAsDiffType, (Matcher)Matchers.equalTo((Object)FisheyeReviewItemData.CommitType.Deleted));
    }

    @Test
    public void commitTypeShouldBeCopied_toRevisionCopied() throws Exception {
        FRXDO frxdo = this.buildFRXDO(true, MockCrucibleRevisionBuilder.newInstance(), MockCrucibleRevisionBuilder.newInstance().copied(true));
        FisheyeReviewItemData.CommitType type = frxdo.getCommitType();
        Assert.assertThat((Object)type, (Matcher)Matchers.equalTo((Object)FisheyeReviewItemData.CommitType.Copied));
    }

    @Test
    public void commitTypeShouldBeMoved_toRevisionMoved() throws Exception {
        FRXDO frxdo = this.buildFRXDO(false, MockCrucibleRevisionBuilder.newInstance(), MockCrucibleRevisionBuilder.newInstance().moved(true));
        FisheyeReviewItemData.CommitType type = frxdo.getCommitType();
        Assert.assertThat((Object)type, (Matcher)Matchers.equalTo((Object)FisheyeReviewItemData.CommitType.Moved));
    }

    @Test
    public void commitTypeShouldBeModified_toRevisionModified() throws Exception {
        FRXDO frxdo = this.buildFRXDO(false, MockCrucibleRevisionBuilder.newInstance(), MockCrucibleRevisionBuilder.newInstance().modified(true));
        FisheyeReviewItemData.CommitType type = frxdo.getCommitType();
        Assert.assertThat((Object)type, (Matcher)Matchers.equalTo((Object)FisheyeReviewItemData.CommitType.Modified));
    }

    private FRXDO buildFRXDO(boolean showAsDiff, MockCrucibleRevisionBuilder ... revisions) {
        ImmutableList frxRevisions = ImmutableList.copyOf((Iterable)Iterables.transform(Arrays.asList(revisions), (Function)new Function<MockCrucibleRevisionBuilder, FRXRevision>(){

            @Nullable
            public FRXRevision apply(MockCrucibleRevisionBuilder rev) {
                return MockFrxRevisionBuilder.newInstance().cruRevision(rev.build()).build();
            }
        }));
        FileRevisionExtraInfo frx = MockFileRevisionExtraInfoBuilder.newInstance().addFrxRevisions((Iterable<FRXRevision>)frxRevisions).showAsDiff(showAsDiff).build();
        FRXDO frxdo = new FRXDO((ContentManager)Mockito.mock(ContentManager.class), (UnreadManager)Mockito.mock(UnreadManager.class), (UnreadFileManager)Mockito.mock(UnreadFileManager.class), (UserProfileManager)Mockito.mock(UserProfileManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS), frx, (FecruUser)Mockito.mock(FecruUser.class), (Principal)Mockito.mock(Principal.class), (CurrentUserPermissions)Mockito.mock(CurrentUserPermissions.class), null, true, true, (SourceFactory)Mockito.mock(SourceFactory.class, (Answer)Mockito.RETURNS_DEEP_STUBS), true, false);
        frxdo.setFromFrxRevision((FRXRevision)frxRevisions.get(0));
        frxdo.setToFrxRevision((FRXRevision)frxRevisions.get(frxRevisions.size() - 1));
        return frxdo;
    }
}

