/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.util.DummyReviewItemIndexer;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import org.junit.After;
import org.junit.Before;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class UseTestSpringContextTestCase {
    private String myContextFile;
    private static final String STD_TEST_CONTEXT = "com/cenqua/crucible/util/testApplicationContext.xml";
    protected DefaultReviewManager reviewManager;

    @Before
    public final void setupSpringContext() throws Exception {
        TestFishEyeInstances.checkCleanStart();
        String[] contexts = this.myContextFile != null ? new String[]{STD_TEST_CONTEXT, this.myContextFile} : new String[]{STD_TEST_CONTEXT};
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(contexts);
        SpringContext.setApplicationContext((ApplicationContext)context);
        AppConfig.getsConfig().setUserManager(null);
        this.reviewManager = ModelUtils.getReviewManagerWithMockedManagersAndRealDAOs();
        this.reviewManager.setReviewItemIndexer((ReviewItemIndexer)new DummyReviewItemIndexer());
        DefaultReviewManager.set((ReviewManager)this.reviewManager);
    }

    @After
    public final void teardownSpringContext() throws Exception {
        if (SpringContext.isSetup()) {
            DisposableBean context = (DisposableBean)SpringContext.getApplicationContext();
            context.destroy();
        }
        SpringContext.setApplicationContext(null);
        AppConfig.getsConfig().setUserManager(null);
        TestFishEyeInstances.checkCleanStart();
    }
}

