/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.managers.ParticipantManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.util.DateHelper;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReviewUtilTest
extends UseTestSpringContextTestCase {
    private ModelUtils mu;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
        this.mu = new ModelUtils();
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testIsShowJoinReviewNoReviewers() throws Exception {
        HibernateUtil.beginTransaction();
        ReviewUtilTest reviewUtilTest = this;
        ProjectManager pm = reviewUtilTest.mu.getProjectManager();
        Project project = pm.createProject("test", "TEST");
        project.setDefaultReviewerUsers(new HashSet());
        project.setAllowedReviewerUsers(new HashSet());
        project.setAllowedReviewerGroups(new HashSet());
        Review review = ModelUtils.createBlankTestReview("testreview");
        review.setAllowReviewerToJoin(true);
        review.setProject(project);
        FecruUser any_user = ModelUtils.makeAndSaveUser("any_user");
        HibernateUtil.commitTransaction();
        Assert.assertTrue((boolean)ReviewUtil.isShowJoinReview((Review)review, (FecruUser)any_user));
    }

    @Test
    public void testIsShowJoinReviewWithReviewers() throws Exception {
        HibernateUtil.beginTransaction();
        ReviewUtilTest reviewUtilTest = this;
        ProjectManager pm = reviewUtilTest.mu.getProjectManager();
        final FecruUser default_user = ModelUtils.makeAndSaveUser("default_user");
        final FecruUser allowed_user = ModelUtils.makeAndSaveUser("allowed_user");
        FecruUser no_permission_user = ModelUtils.makeAndSaveUser("no_permission_user");
        Project project = pm.createProject("test", "TEST");
        project.setDefaultReviewerUsers((Set)new HashSet<FecruUser>(){
            {
                this.add(default_user);
            }
        });
        project.setAllowedReviewerGroups(new HashSet());
        project.setAllowedReviewerUsers((Set)new HashSet<FecruUser>(){
            {
                this.add(default_user);
                this.add(allowed_user);
            }
        });
        Review review = ModelUtils.createBlankTestReview("testreview", project);
        ReviewParticipant p1 = ParticipantManager.getOrCreateParticipant((Review)review, (FecruUser)default_user);
        review.setAllowReviewerToJoin(true);
        HibernateUtil.commitTransaction();
        Assert.assertFalse((boolean)ReviewUtil.isShowJoinReview((Review)review, (FecruUser)no_permission_user));
        Assert.assertTrue((boolean)ReviewUtil.isShowJoinReview((Review)review, (FecruUser)allowed_user));
        Assert.assertFalse((boolean)ReviewUtil.isShowJoinReview((Review)review, (FecruUser)default_user));
        HibernateUtil.beginTransaction();
        review.setAllowReviewerToJoin(false);
        HibernateUtil.commitTransaction();
        Assert.assertFalse((boolean)ReviewUtil.isShowJoinReview((Review)review, (FecruUser)no_permission_user));
        Assert.assertFalse((boolean)ReviewUtil.isShowJoinReview((Review)review, (FecruUser)allowed_user));
        Assert.assertFalse((boolean)ReviewUtil.isShowJoinReview((Review)review, (FecruUser)default_user));
    }

    @Test
    public void testMakePeriod() {
        TimeZone tz = AppConfig.getsConfig().getTimezone();
        Period p = ReviewUtil.makePeriod((int)7, (String)"days");
        Calendar cal = DateHelper.getStartOfTodayAsCalendar((TimeZone)tz);
        cal.add(5, -6);
        Assert.assertEquals((Object)p.getFrom(), (Object)cal.getTime());
        p = ReviewUtil.makePeriod((int)1, (String)"week");
        Assert.assertEquals((Object)p.getFrom(), (Object)cal.getTime());
        p = ReviewUtil.makePeriod((int)2, (String)"months");
        cal = DateHelper.getStartOfTodayAsCalendar((TimeZone)tz);
        cal.add(5, 1);
        cal.add(2, -2);
        Assert.assertEquals((Object)p.getFrom(), (Object)cal.getTime());
        p = ReviewUtil.makePeriod((int)3, (String)"hours");
        cal = DateHelper.getStartOfTodayAsCalendar((TimeZone)tz);
        cal.add(5, 1);
        cal.add(10, -3);
        Assert.assertEquals((Object)p.getFrom(), (Object)cal.getTime());
        try {
            p = ReviewUtil.makePeriod((int)1, (String)"zinc");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleExtraction() {
        Assert.assertEquals((Object)"foo bar baz", (Object)ReviewUtil.extractReviewTitle((String)"foo bar baz"));
        Assert.assertEquals((Object)"foo", (Object)ReviewUtil.extractReviewTitle((String)"foo\nbar\r\nbaz"));
        Assert.assertEquals((Object)"foo", (Object)ReviewUtil.extractReviewTitle((String)"foo\r\nbar\n\n\nbaz"));
        Assert.assertEquals((Object)"this is a very long title this is a very long title this is a very long title this is a very long...", (Object)ReviewUtil.extractReviewTitle((String)"this is a very long title this is a very long title this is a very long title this is a very long title\nthis is a very long title\nthis is a very long title\nthis is a very long title\nthis is a very long title\nthis is a very long title\nthis is a very long title\n"));
        Assert.assertEquals((Object)"", (Object)ReviewUtil.extractReviewTitle(null));
        Assert.assertEquals((Object)"", (Object)ReviewUtil.extractReviewTitle((String)""));
    }
}

