/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.crucible.event.ReviewItemRevisionDataChangedEventImpl;
import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.crucible.spi.services.ContentTooLargeException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.scm.SCMModuleManager;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXComment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.FRXCommentManager;
import com.cenqua.crucible.model.managers.FRXManager;
import com.cenqua.crucible.model.managers.FRXRevisionManager;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.managers.DefaultContentManager;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.DefaultSourceFactory;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.DummyEventPublisher;
import com.cenqua.crucible.util.DummyReviewItemIndexer;
import com.cenqua.crucible.util.DummySPIUtils;
import com.cenqua.crucible.util.DummyScmModuleManager;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.crucible.util.ReviewCreationTestHelper;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.util.TestUtil;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ReviewCreationHelperTest {
    private RepositoryHandle cvsHandle;
    private RepositoryHandle svnHandle;
    private RepositoryHandle svnPropsHandle;
    private Review review;
    private FecruUser currentCrucibleUser;
    private UserLogin currentUser;
    private Source cvsSource;
    private Source svnSource;
    private Source svnPropsSource;
    private ReviewCreationHelper cvsRch;
    private ReviewCreationHelper svnRch;
    private ReviewCreationHelper svnPropsRch;
    private ContentManager contentManager;
    private DefaultSourceFactory sourceFactory;
    private DefaultReviewManager reviewManager;
    private EffectiveUserProviderImpl effectiveUserProvider;
    private CommentManager commentManager;
    private EncodedContentProvider encodedContentProvider;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.stop();
        Disposer.pushThreadInstance();
        this.cvsHandle = TestFishEyeInstances.getSanity1Repos();
        this.svnHandle = TestFishEyeInstances.getSanity1SvnRepo();
        this.svnPropsHandle = TestFishEyeInstances.getSanity1SvnPropsRepo();
        AppConfig.getsConfig().getUserManager().addGroup("team-1");
        ((GlobalPermissionManager)SpringContext.getComponentByClass(GlobalPermissionManager.class)).setPermissionsForGroup("team-1", GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        TestUtil.addFisheyeUser("fred", "Fred Nurk", "fred@Test.com");
        this.currentCrucibleUser = ModelUtils.makeAndSaveUser("fred");
        this.currentUser = this.createTrustedUserLogin("fred");
        this.encodedContentProvider = (EncodedContentProvider)Mockito.mock(EncodedContentProvider.class);
        this.contentManager = new DefaultContentManager(null, null, null, null, this.encodedContentProvider, (TxTemplate)new DummyTxTemplate(), (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), (PatchManager)Mockito.mock(PatchManager.class));
        this.sourceFactory = new DefaultSourceFactory();
        this.sourceFactory.setContentManager(this.contentManager);
        this.sourceFactory.setNotificationManager((NotificationManager)Mockito.mock(NotificationManager.class));
        this.sourceFactory.setScmModuleManager((SCMModuleManager)new DummyScmModuleManager());
        this.effectiveUserProvider = (EffectiveUserProviderImpl)SpringContext.getComponent(EffectiveUserProviderImpl.class, (String)"effectiveUserProvider");
        this.effectiveUserProvider.pushEffectivePrincipal((Principal)this.currentUser, this.currentCrucibleUser);
        CrucibleFilter.setContext((CrucibleFilter.Context)new CrucibleFilter.Context((ServletRequest)new DummyHttpServletRequest(), null));
        this.cvsSource = this.sourceFactory.getSource(this.cvsHandle.acquireEngine().getRevisionCache().getRepositoryName(), (Principal)this.currentUser);
        this.svnSource = this.sourceFactory.getSource(this.svnHandle.acquireEngine().getRevisionCache().getRepositoryName(), (Principal)this.currentUser);
        this.svnPropsSource = this.sourceFactory.getSource(this.svnPropsHandle.acquireEngine().getRevisionCache().getRepositoryName(), (Principal)this.currentUser);
        this.reviewManager = ModelUtils.getReviewManagerWithMockedManagersAndRealDAOs();
        this.reviewManager.setReviewItemIndexer((ReviewItemIndexer)new DummyReviewItemIndexer());
        ProjectManager pm = ModelUtils.getProjectManager();
        this.commentManager = new DefaultCommentManager((EventPublisher)Mockito.mock(EventPublisher.class), (SPIUserUtils)Mockito.mock(SPIUserUtils.class), (UnreadManager)Mockito.mock(UnreadManager.class), null, (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), (LogItemManager)Mockito.mock(LogItemManager.class));
        HibernateUtil.ensureTransaction();
        this.review = this.reviewManager.createReview(pm, pm.getDefaultProject(), "test review", this.currentCrucibleUser);
        HibernateUtil.commitTransaction();
        this.cvsRch = new ReviewCreationHelper(this.cvsSource, this.review, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), (SPIUtils)new DummySPIUtils(), (CommentManager)Mockito.mock(CommentManager.class), (EventPublisher)Mockito.mock(EventPublisher.class));
        this.svnRch = new ReviewCreationHelper(this.svnSource, this.review, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), (SPIUtils)new DummySPIUtils(), (CommentManager)Mockito.mock(CommentManager.class), (EventPublisher)Mockito.mock(EventPublisher.class));
        this.svnPropsRch = new ReviewCreationHelper(this.svnPropsSource, this.review, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), (SPIUtils)new DummySPIUtils(), (CommentManager)Mockito.mock(CommentManager.class), (EventPublisher)Mockito.mock(EventPublisher.class));
    }

    @After
    public void tearDown() throws Exception {
        this.cvsRch = null;
        this.svnRch = null;
        this.currentCrucibleUser = null;
        this.currentUser = null;
        this.cvsSource = null;
        this.svnSource = null;
        this.review = null;
        this.cvsHandle = null;
        this.svnHandle = null;
        this.effectiveUserProvider.popEffectivePrincipal();
        Disposer.popThreadInstance();
        HibernateUtil.forceRollbackTransaction();
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
        CrucibleFilter.setContext(null);
    }

    @Test
    public void testAddRevisionWithComments() throws Exception {
        FileRevisionExtraInfo frx = null;
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "2", null, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertTrue((this.review.getFrxs().size() == 2 ? 1 : 0) != 0);
        for (FileRevisionExtraInfo f : this.review.getFrxs()) {
            if (!"CRUC-694/gpl-2.0.txt".equals(f.getFileRevision().getPath())) continue;
            frx = f;
            break;
        }
        Assert.assertNotNull(frx);
        HibernateUtil.beginTransaction();
        Comment comment = this.commentManager.createComment("some message", this.review, this.currentCrucibleUser);
        FRXComment rc = FRXCommentManager.createAndAddFrxComment((Comment)comment, (FileRevisionExtraInfo)frx);
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "3", null, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertTrue((this.review.getFrxs().size() == 2 ? 1 : 0) != 0);
        for (FileRevisionExtraInfo f : this.review.getFrxs()) {
            if ("CRUC-694/gpl-2.0.txt".equals(f.getFileRevision().getPath())) {
                Assert.assertEquals((Object)"3", (Object)f.getFileRevision().getRevision());
                continue;
            }
            if ("CRUC-694/gpl-3.0.txt".equals(f.getFileRevision().getPath())) {
                Assert.assertEquals((Object)"3", (Object)f.getFileRevision().getRevision());
                continue;
            }
            Assert.fail();
        }
    }

    @Test
    public void testNewDiffToReviewed() throws SourceException, ContentTooLargeException {
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "2", Review.AttachMethod.REVIEWED_DIFF, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Set frxs = this.review.getFrxs();
        Assert.assertTrue((frxs.size() == 2 ? 1 : 0) != 0);
        for (FileRevisionExtraInfo frx : frxs) {
            Assert.assertTrue((frx.getFromRevision() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAddRevisions() throws Exception {
        CrucibleRevision fr;
        String path = "emptytests/notempty/a.txt";
        String csId = "MAIN:matt:20040916025519";
        FileRevisionExtraInfo frx = null;
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.cvsRch, this.cvsSource, this.currentCrucibleUser, csId, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertTrue((this.review.getFrxs().size() == 2 ? 1 : 0) != 0);
        for (FileRevisionExtraInfo tFrx : this.review.getFrxs()) {
            if (tFrx.getFileRevision().getPath().equals(path)) {
                frx = tFrx;
                Assert.assertEquals((Object)"1.29", (Object)tFrx.getFileRevision().getRevision());
                Assert.assertEquals((Object)"1.28", (Object)tFrx.getFromRevision().getRevision());
                continue;
            }
            if (tFrx.getFileRevision().getPath().equals("test/a.txt")) {
                Assert.assertEquals((Object)"1.29", (Object)tFrx.getFileRevision().getRevision());
                Assert.assertEquals((Object)"1.28", (Object)tFrx.getFromRevision().getRevision());
                continue;
            }
            Assert.fail((String)("File revisions " + tFrx.getFileRevision().getId() + " should not be in review."));
        }
        Assert.assertTrue((frx != null ? 1 : 0) != 0);
        Collection repRevisions = this.cvsHandle.acquireEngine().getRevisionCache().getFileHistory(new Path((CharSequence)path)).getRevisions();
        ArrayList<CrucibleRevision> revisions = new ArrayList<CrucibleRevision>();
        for (FileRevision repfr : repRevisions) {
            fr = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, repfr.getPath().getPath(), repfr.getRevision());
            if (fr.getRevision().equals("1.32") || fr.getRevision().length() != 4) continue;
            revisions.add(fr);
        }
        HibernateUtil.beginTransaction();
        this.cvsRch.addRevisions(this.currentCrucibleUser, revisions, Review.AttachMethod.SPECIFIC_DIFF, "1.6", ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((Object)"1.6", (Object)frx.getFromRevision().getRevision());
        Assert.assertEquals((Object)"1.31", (Object)frx.getFileRevision().getRevision());
        Assert.assertTrue((frx.getFrxRevisions().size() == 4 ? 1 : 0) != 0);
        revisions = new ArrayList();
        for (FileRevision repfr : repRevisions) {
            fr = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, repfr.getPath().getPath(), repfr.getRevision());
            revisions.add(fr);
        }
        HibernateUtil.beginTransaction();
        this.cvsRch.addRevisions(this.currentCrucibleUser, revisions, Review.AttachMethod.WHOLE_FILE, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertTrue((frx.getShowAsDiff() == false ? 1 : 0) != 0);
        Assert.assertEquals((Object)"1.32", (Object)frx.getFileRevision().getRevision());
        Assert.assertTrue((frx.getShowAsDiff() == false ? 1 : 0) != 0);
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.cvsRch, this.cvsSource, this.currentCrucibleUser, csId, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertTrue((this.review.getFrxs().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((frx.getFrxRevisions().size() == 5 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"1.32", (Object)frx.getFileRevision().getRevision());
        Assert.assertTrue((frx.getShowAsDiff() == false ? 1 : 0) != 0);
    }

    @Test
    public void testAddAndRemoveRevisions() throws Exception {
        String path = "test/test.text";
        Collection repRevisions = this.cvsHandle.acquireEngine().getRevisionCache().getFileHistory(new Path((CharSequence)path)).getRevisions();
        ArrayList<CrucibleRevision> revisions = new ArrayList<CrucibleRevision>();
        for (FileRevision repfr : repRevisions) {
            CrucibleRevision fr = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, repfr.getPath().getPath(), repfr.getRevision());
            revisions.add(fr);
        }
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.cvsRch, this.cvsSource, this.currentCrucibleUser, "MAIN:matt:20031204035011", null, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((long)1L, (long)this.review.getFrxs().size());
        for (FileRevisionExtraInfo frx : this.review.getFrxs()) {
            Assert.assertEquals((Object)"1.1", (Object)frx.getFileRevision().getRevision());
            Assert.assertTrue((frx.getFromRevision() == null ? 1 : 0) != 0);
        }
        HibernateUtil.beginTransaction();
        this.cvsRch.addRevisions(this.currentCrucibleUser, revisions, null, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((long)3L, (long)this.review.getFrxs().size());
        for (FileRevisionExtraInfo frx : this.review.getFrxs()) {
            String expectedFileRevision = "";
            String expectedFromRevision = "";
            String branch = (String)frx.getFileRevision().getDetails().get("branch");
            if (branch.equals("BRANCH2")) {
                expectedFileRevision = "1.9.2.3";
                expectedFromRevision = "1.1";
            } else if (branch.equals("MAIN")) {
                expectedFileRevision = "1.88";
                expectedFromRevision = "1.1";
            } else if (branch.equals("yoyo")) {
                expectedFileRevision = "1.1.1.1";
                expectedFromRevision = "1.1";
            } else {
                Assert.fail((String)("File revision " + frx.getFileRevision().getId() + " should not be in review."));
            }
            Assert.assertEquals((Object)expectedFileRevision, (Object)frx.getFileRevision().getRevision());
            Assert.assertEquals((Object)expectedFromRevision, frx.getFromRevision() != null ? frx.getFromRevision().getRevision() : null);
        }
        HibernateUtil.beginTransaction();
        this.cvsRch.removeAllRevisions(this.currentCrucibleUser);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((long)0L, (long)this.review.getFrxs().size());
    }

    @Test
    public void testAddingMultipleRevisions() throws Exception {
        String path = "test/test.text";
        FileHistory fh = this.cvsHandle.acquireEngine().getRevisionCache().getFileHistory(new Path((CharSequence)path));
        FileRevision rev1 = fh.getRevision("1.1");
        FileRevision rev2 = fh.getRevision("1.2");
        FileRevision rev3 = fh.getRevision("1.3");
        FileRevision rev4 = fh.getRevision("1.4");
        FileRevision rev5 = fh.getRevision("1.5");
        FileRevision rev6 = fh.getRevision("1.6");
        FileRevision rev7 = fh.getRevision("1.7");
        FileRevision rev8 = fh.getRevision("1.8");
        FileRevision rev9 = fh.getRevision("1.9");
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev3.getPath().getPath(), rev3.getRevision());
        CrucibleRevision fr4 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev4.getPath().getPath(), rev4.getRevision());
        HibernateUtil.ensureTransaction();
        this.cvsRch.addRevisions(this.currentCrucibleUser, Collections.singletonList(fr4), Review.AttachMethod.ITERATION, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((long)1L, (long)this.review.getFrxs().size());
        FileRevisionExtraInfo frx = (FileRevisionExtraInfo)this.review.getFrxs().iterator().next();
        List frxRevs = frx.getFrxRevisions();
        Assert.assertEquals((long)2L, (long)frxRevs.size());
        Assert.assertEquals((Object)"1.3", (Object)((FRXRevision)frxRevs.get(0)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.4", (Object)((FRXRevision)frxRevs.get(1)).getRevision().getRevision());
        this.closeAndOpenNewSession();
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev3.getPath().getPath(), rev3.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev4.getPath().getPath(), rev4.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev8.getPath().getPath(), rev8.getRevision());
        CrucibleRevision fr9 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev9.getPath().getPath(), rev9.getRevision());
        Assert.assertEquals((long)1L, (long)this.review.getFrxs().size());
        frx = (FileRevisionExtraInfo)this.review.getFrxs().iterator().next();
        frxRevs = frx.getFrxRevisions();
        Assert.assertEquals((long)2L, (long)frxRevs.size());
        Assert.assertEquals((Object)"1.3", (Object)((FRXRevision)frxRevs.get(0)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.4", (Object)((FRXRevision)frxRevs.get(1)).getRevision().getRevision());
        HibernateUtil.ensureTransaction();
        this.cvsRch.addRevisions(this.currentCrucibleUser, Collections.singletonList(fr9), Review.AttachMethod.ITERATION, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((long)1L, (long)this.review.getFrxs().size());
        frx = (FileRevisionExtraInfo)this.review.getFrxs().iterator().next();
        frxRevs = frx.getFrxRevisions();
        Assert.assertEquals((long)3L, (long)frxRevs.size());
        Assert.assertEquals((Object)"1.3", (Object)((FRXRevision)frxRevs.get(0)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.4", (Object)((FRXRevision)frxRevs.get(1)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.9", (Object)((FRXRevision)frxRevs.get(2)).getRevision().getRevision());
        this.closeAndOpenNewSession();
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev3.getPath().getPath(), rev3.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev4.getPath().getPath(), rev4.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev8.getPath().getPath(), rev8.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev9.getPath().getPath(), rev9.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev5.getPath().getPath(), rev5.getRevision());
        CrucibleRevision fr6 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev6.getPath().getPath(), rev6.getRevision());
        HibernateUtil.ensureTransaction();
        this.cvsRch.addRevisions(this.currentCrucibleUser, Collections.singletonList(fr6), Review.AttachMethod.ITERATION, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((long)1L, (long)this.review.getFrxs().size());
        frx = (FileRevisionExtraInfo)this.review.getFrxs().iterator().next();
        frxRevs = frx.getFrxRevisions();
        Assert.assertEquals((long)4L, (long)frxRevs.size());
        Assert.assertEquals((Object)"1.3", (Object)((FRXRevision)frxRevs.get(0)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.4", (Object)((FRXRevision)frxRevs.get(1)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.6", (Object)((FRXRevision)frxRevs.get(2)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.9", (Object)((FRXRevision)frxRevs.get(3)).getRevision().getRevision());
        this.closeAndOpenNewSession();
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev1.getPath().getPath(), rev1.getRevision());
        CrucibleRevision fr2 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev2.getPath().getPath(), rev2.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev3.getPath().getPath(), rev3.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev4.getPath().getPath(), rev4.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev8.getPath().getPath(), rev8.getRevision());
        ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev9.getPath().getPath(), rev9.getRevision());
        HibernateUtil.ensureTransaction();
        this.cvsRch.addRevisions(this.currentCrucibleUser, Collections.singletonList(fr2), Review.AttachMethod.ITERATION, null, ReviewCreationHelper.MetadataFilter.NONE);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((long)1L, (long)this.review.getFrxs().size());
        frx = (FileRevisionExtraInfo)this.review.getFrxs().iterator().next();
        frxRevs = frx.getFrxRevisions();
        Assert.assertEquals((long)6L, (long)frxRevs.size());
        Assert.assertEquals((Object)"1.1", (Object)((FRXRevision)frxRevs.get(0)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.2", (Object)((FRXRevision)frxRevs.get(1)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.3", (Object)((FRXRevision)frxRevs.get(2)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.4", (Object)((FRXRevision)frxRevs.get(3)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.6", (Object)((FRXRevision)frxRevs.get(4)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.9", (Object)((FRXRevision)frxRevs.get(5)).getRevision().getRevision());
    }

    @Test
    public void testAddingMultipleRevisionsFromManager() throws Exception {
        String path = "test/test.text";
        FileHistory fh = this.cvsHandle.acquireEngine().getRevisionCache().getFileHistory(new Path((CharSequence)path));
        FileRevision rev1 = fh.getRevision("1.1");
        FileRevision rev2 = fh.getRevision("1.2");
        FileRevision rev3 = fh.getRevision("1.3");
        FileRevision rev4 = fh.getRevision("1.4");
        FileRevision rev5 = fh.getRevision("1.5");
        FileRevision rev6 = fh.getRevision("1.6");
        FileRevision rev7 = fh.getRevision("1.7");
        FileRevision rev8 = fh.getRevision("1.8");
        FileRevision rev9 = fh.getRevision("1.9");
        CrucibleRevision fr3 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev3.getPath().getPath(), rev3.getRevision());
        CrucibleRevision fr4 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev4.getPath().getPath(), rev4.getRevision());
        FRXRevisionManager frxrm = new FRXRevisionManager();
        HibernateUtil.ensureTransaction();
        FileRevisionExtraInfo frx = FRXManager.createAndAddFRX((CrucibleRevision)fr3, (Review)this.review);
        frxrm.createFRXRevisionAndUnread(frx, 1, fr4);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((long)1L, (long)this.review.getFrxs().size());
        frx = (FileRevisionExtraInfo)this.review.getFrxs().iterator().next();
        List frxRevs = frx.getFrxRevisions();
        Assert.assertEquals((long)2L, (long)frxRevs.size());
        Assert.assertEquals((Object)"1.3", (Object)((FRXRevision)frxRevs.get(0)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.4", (Object)((FRXRevision)frxRevs.get(1)).getRevision().getRevision());
        this.closeAndOpenNewSession();
        this.currentCrucibleUser = ModelUtils.makeAndSaveUser("fred");
        this.currentUser = this.createTrustedUserLogin("fred");
        this.cvsSource = this.sourceFactory.getSource(this.cvsHandle.acquireEngine().getRevisionCache().getRepositoryName(), (Principal)this.currentUser);
        this.review = this.reviewManager.getReviewById(this.review.getId());
        fr3 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev3.getPath().getPath(), rev3.getRevision());
        fr4 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev4.getPath().getPath(), rev4.getRevision());
        CrucibleRevision fr8 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev8.getPath().getPath(), rev8.getRevision());
        CrucibleRevision fr9 = ModelUtils.createFileRevision(this.contentManager, this.cvsSource, rev9.getPath().getPath(), rev9.getRevision());
        Assert.assertEquals((long)1L, (long)this.review.getFrxs().size());
        frx = (FileRevisionExtraInfo)this.review.getFrxs().iterator().next();
        frxRevs = frx.getFrxRevisions();
        Assert.assertEquals((long)2L, (long)frxRevs.size());
        Assert.assertEquals((Object)"1.3", (Object)((FRXRevision)frxRevs.get(0)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.4", (Object)((FRXRevision)frxRevs.get(1)).getRevision().getRevision());
        HibernateUtil.ensureTransaction();
        frxrm.createFRXRevisionAndUnread(frx, 2, fr8);
        frxrm.createFRXRevisionAndUnread(frx, 3, fr9);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((long)1L, (long)this.review.getFrxs().size());
        frx = (FileRevisionExtraInfo)this.review.getFrxs().iterator().next();
        frxRevs = frx.getFrxRevisions();
        Assert.assertEquals((long)4L, (long)frxRevs.size());
        Assert.assertEquals((Object)"1.3", (Object)((FRXRevision)frxRevs.get(0)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.4", (Object)((FRXRevision)frxRevs.get(1)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.8", (Object)((FRXRevision)frxRevs.get(2)).getRevision().getRevision());
        Assert.assertEquals((Object)"1.9", (Object)((FRXRevision)frxRevs.get(3)).getRevision().getRevision());
    }

    @Test
    public void canAddNonMetadataOnlyChangeSets() throws SourceException, ContentTooLargeException {
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnPropsRch, this.svnPropsSource, this.currentCrucibleUser, "1", null, null, ReviewCreationHelper.MetadataFilter.NONE);
        Assert.assertEquals((long)4L, (long)this.svnPropsRch.getAddedItems().size());
        Assert.assertEquals((Object)"", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getPath());
        Assert.assertEquals((Object)"1", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getRevision());
        Assert.assertEquals((Object)"trunk", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getPath());
        Assert.assertEquals((Object)"1", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getRevision());
        Assert.assertEquals((Object)"trunk/bar.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(2)).getPath());
        Assert.assertEquals((Object)"1", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(2)).getRevision());
        Assert.assertEquals((Object)"trunk/foo.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(3)).getPath());
        Assert.assertEquals((Object)"1", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(3)).getRevision());
        HibernateUtil.commitTransaction();
    }

    @Test
    public void cantAddMetadataOnlyChangeSets() throws SourceException, ContentTooLargeException {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        HibernateUtil.beginTransaction();
        try {
            ReviewCreationTestHelper.addChangeSet(this.svnPropsRch, this.svnPropsSource, this.currentCrucibleUser, "2", null, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
            Assert.fail((String)"Excepted an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            HibernateUtil.commitTransaction();
        }
    }

    @Test
    public void canAddMetadataOnlyChangeSetsIfNoFiltering() throws SourceException, ContentTooLargeException {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnPropsRch, this.svnPropsSource, this.currentCrucibleUser, "2", null, null, ReviewCreationHelper.MetadataFilter.NONE);
        Assert.assertEquals((long)4L, (long)this.svnPropsRch.getAddedItems().size());
        Assert.assertEquals((Object)"trunk/bar.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getPath());
        Assert.assertEquals((Object)"2", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getRevision());
        Assert.assertEquals((Object)"trunk/bar.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getPath());
        Assert.assertEquals((Object)"1", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getRevision());
        Assert.assertEquals((Object)"trunk/foo.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(2)).getPath());
        Assert.assertEquals((Object)"2", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(2)).getRevision());
        Assert.assertEquals((Object)"trunk/foo.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(3)).getPath());
        Assert.assertEquals((Object)"1", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(3)).getRevision());
        HibernateUtil.commitTransaction();
    }

    @Test
    public void canAddMetadataOnlyChangeSetsIfFilteringWithoutFailure() throws SourceException, ContentTooLargeException {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnPropsRch, this.svnPropsSource, this.currentCrucibleUser, "2", null, null, ReviewCreationHelper.MetadataFilter.ALL);
        Assert.assertEquals((long)0L, (long)this.svnPropsRch.getAddedItems().size());
        HibernateUtil.commitTransaction();
    }

    @Test
    public void canAddNonMetadataChangeSetsIfSysPropSetToFalse() throws SourceException, ContentTooLargeException {
        HibernateUtil.beginTransaction();
        boolean original = CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES;
        CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES = false;
        try {
            ReviewCreationTestHelper.addChangeSet(this.svnPropsRch, this.svnPropsSource, this.currentCrucibleUser, "2", null, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
            Assert.assertEquals((long)4L, (long)this.svnPropsRch.getAddedItems().size());
            Assert.assertEquals((Object)"trunk/bar.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getPath());
            Assert.assertEquals((Object)"2", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getRevision());
            Assert.assertEquals((Object)"trunk/bar.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getPath());
            Assert.assertEquals((Object)"1", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getRevision());
            Assert.assertEquals((Object)"trunk/foo.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(2)).getPath());
            Assert.assertEquals((Object)"2", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(2)).getRevision());
            Assert.assertEquals((Object)"trunk/foo.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(3)).getPath());
            Assert.assertEquals((Object)"1", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(3)).getRevision());
            HibernateUtil.commitTransaction();
        }
        finally {
            CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES = original;
        }
    }

    @Test
    public void canFilterChangeSetsWithMixedMetadataChanges() throws SourceException, ContentTooLargeException {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnPropsRch, this.svnPropsSource, this.currentCrucibleUser, "3", null, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        Assert.assertEquals((long)2L, (long)this.svnPropsRch.getAddedItems().size());
        Assert.assertEquals((Object)"trunk/foo.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getPath());
        Assert.assertEquals((Object)"3", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getRevision());
        Assert.assertEquals((Object)"trunk/foo.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getPath());
        Assert.assertEquals((Object)"2", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getRevision());
        HibernateUtil.commitTransaction();
    }

    @Test
    public void canFilterChangeSetsWithOverlappingMetadataChanges() throws SourceException, ContentTooLargeException {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnPropsRch, this.svnPropsSource, this.currentCrucibleUser, "4", null, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        Assert.assertEquals((long)4L, (long)this.svnPropsRch.getAddedItems().size());
        Assert.assertEquals((Object)"trunk/bar.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getPath());
        Assert.assertEquals((Object)"4", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(0)).getRevision());
        Assert.assertEquals((Object)"trunk/bar.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getPath());
        Assert.assertEquals((Object)"3", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(1)).getRevision());
        Assert.assertEquals((Object)"trunk/foo.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(2)).getPath());
        Assert.assertEquals((Object)"4", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(2)).getRevision());
        Assert.assertEquals((Object)"trunk/foo.txt", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(3)).getPath());
        Assert.assertEquals((Object)"3", (Object)((CrucibleRevision)this.svnPropsRch.getAddedItems().get(3)).getRevision());
        HibernateUtil.commitTransaction();
    }

    @Test
    public void testAdd2ChangesetsWithTheSameBranchPointModeShouldAddRevisions() throws SourceException, ContentTooLargeException {
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "24", Review.AttachMethod.LAST_BRANCH_POINT, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        this.svnRch = new ReviewCreationHelper(this.svnSource, this.review, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), (SPIUtils)new DummySPIUtils(), (CommentManager)Mockito.mock(CommentManager.class), (EventPublisher)Mockito.mock(EventPublisher.class));
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "22", Review.AttachMethod.LAST_BRANCH_POINT, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        HibernateUtil.commitTransaction();
        List changeset22Revisions = this.svnSource.getChangeSet("22").getRevisions();
        List addedItems = this.svnRch.getAddedItems();
        Assert.assertEquals((String)"Only one element should been added", (long)1L, (long)addedItems.size());
        Assert.assertEquals((String)"Only revisions from changeset 22 should be added", (Object)changeset22Revisions, (Object)addedItems);
        Assert.assertEquals((String)"0 messages are provided", (long)0L, (long)this.svnRch.getMessages().size());
    }

    @Test
    public void testAdd3OverlappingChangesetsShouldAddRevisions() throws SourceException, ContentTooLargeException {
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "24", Review.AttachMethod.ITERATION, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "22", Review.AttachMethod.ITERATION, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        HibernateUtil.commitTransaction();
        this.svnRch = new ReviewCreationHelper(this.svnSource, this.review, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), (SPIUtils)new DummySPIUtils(), (CommentManager)Mockito.mock(CommentManager.class), (EventPublisher)Mockito.mock(EventPublisher.class));
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "23", Review.AttachMethod.ITERATION, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        HibernateUtil.commitTransaction();
        List addedItems = this.svnRch.getAddedItems();
        Assert.assertEquals((String)"All revisions are already added", (long)0L, (long)addedItems.size());
        Assert.assertEquals((String)"0 messages are provided", (long)0L, (long)this.svnRch.getMessages().size());
    }

    @Test
    public void noneFilterFiltersNone() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertEquals((long)0L, (long)ReviewCreationHelper.MetadataFilter.NONE.filter(this.contentManager, this.svnPropsSource, Collections.emptyList()).size());
        Assert.assertEquals((long)1L, (long)ReviewCreationHelper.MetadataFilter.NONE.filter(this.contentManager, this.svnPropsSource, Arrays.asList(new CrucibleRevision())).size());
        Assert.assertEquals((long)1L, (long)ReviewCreationHelper.MetadataFilter.NONE.filter(this.contentManager, this.svnPropsSource, Arrays.asList(this.newMetadataOnlyRevision())).size());
        Assert.assertEquals((long)2L, (long)ReviewCreationHelper.MetadataFilter.NONE.filter(this.contentManager, this.svnPropsSource, Arrays.asList(new CrucibleRevision(), this.newMetadataOnlyRevision())).size());
    }

    @Test
    public void allFilterFiltersAll() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertEquals((long)0L, (long)ReviewCreationHelper.MetadataFilter.ALL.filter(this.contentManager, this.svnPropsSource, Collections.emptyList()).size());
        Assert.assertEquals((long)1L, (long)ReviewCreationHelper.MetadataFilter.ALL.filter(this.contentManager, this.svnPropsSource, Arrays.asList(new CrucibleRevision())).size());
        Assert.assertEquals((long)0L, (long)ReviewCreationHelper.MetadataFilter.ALL.filter(this.contentManager, this.svnPropsSource, Arrays.asList(this.newMetadataOnlyRevision())).size());
        Assert.assertEquals((long)2L, (long)ReviewCreationHelper.MetadataFilter.ALL.filter(this.contentManager, this.svnPropsSource, Arrays.asList(new CrucibleRevision(), new CrucibleRevision())).size());
        Assert.assertEquals((long)1L, (long)ReviewCreationHelper.MetadataFilter.ALL.filter(this.contentManager, this.svnPropsSource, Arrays.asList(new CrucibleRevision(), this.newMetadataOnlyRevision())).size());
        Assert.assertEquals((long)0L, (long)ReviewCreationHelper.MetadataFilter.ALL.filter(this.contentManager, this.svnPropsSource, Arrays.asList(this.newMetadataOnlyRevision(), this.newMetadataOnlyRevision())).size());
    }

    @Test
    public void allAndFailFilterFiltersButDoesntFailIfRevsRemain() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertEquals((long)0L, (long)ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL.filter(this.contentManager, this.svnPropsSource, Collections.emptyList()).size());
        Assert.assertEquals((long)1L, (long)ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL.filter(this.contentManager, this.svnPropsSource, Arrays.asList(new CrucibleRevision())).size());
        Assert.assertEquals((long)2L, (long)ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL.filter(this.contentManager, this.svnPropsSource, Arrays.asList(new CrucibleRevision(), new CrucibleRevision())).size());
        Assert.assertEquals((long)1L, (long)ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL.filter(this.contentManager, this.svnPropsSource, Arrays.asList(new CrucibleRevision(), this.newMetadataOnlyRevision())).size());
    }

    @Test
    public void allAndFailFilterFailsIfNoRevsRemain() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        try {
            ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL.filter(this.contentManager, this.svnPropsSource, Arrays.asList(this.newMetadataOnlyRevision(), this.newMetadataOnlyRevision()));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddNewFrxRevisionPublishedEventContainsAllCrucibleRevisions() throws Exception {
        final ArrayList publishedEvents = Lists.newArrayList();
        this.svnRch = new ReviewCreationHelper(this.svnSource, this.review, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), (SPIUtils)new DummySPIUtils(), (CommentManager)Mockito.mock(CommentManager.class), (EventPublisher)new DummyEventPublisher(){

            @Override
            public void publish(Object event) {
                publishedEvents.add(event);
            }
        });
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "24", Review.AttachMethod.LAST_BRANCH_POINT, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((String)"Only one event is published", (long)1L, (long)publishedEvents.size());
        Collection addedRevisions = ((ReviewItemRevisionDataChangedEventImpl)Iterables.getOnlyElement((Iterable)publishedEvents)).getAddedRevisions();
        Assert.assertEquals((String)"Published event contains 2 revisions", (long)2L, (long)addedRevisions.size());
    }

    @Test
    public void testAddOldFrxRevisionEventIsNotPublished() throws Exception {
        final ArrayList publishedEvents = Lists.newArrayList();
        this.svnRch = new ReviewCreationHelper(this.svnSource, this.review, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), (SPIUtils)new DummySPIUtils(), (CommentManager)Mockito.mock(CommentManager.class), (EventPublisher)new DummyEventPublisher(){

            @Override
            public void publish(Object event) {
                publishedEvents.add(event);
            }
        });
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "22", Review.AttachMethod.LAST_BRANCH_POINT, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        HibernateUtil.commitTransaction();
        publishedEvents.clear();
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "22", Review.AttachMethod.LAST_BRANCH_POINT, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((String)"0 events should be published", (long)0L, (long)publishedEvents.size());
    }

    @Test
    public void testNoAddingRevisionAlreadyExistNoMessageReturned() throws Exception {
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "22", Review.AttachMethod.LAST_BRANCH_POINT, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        HibernateUtil.commitTransaction();
        this.svnRch = new ReviewCreationHelper(this.svnSource, this.review, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), (SPIUtils)new DummySPIUtils(), (CommentManager)Mockito.mock(CommentManager.class), (EventPublisher)Mockito.mock(EventPublisher.class));
        HibernateUtil.beginTransaction();
        ReviewCreationTestHelper.addChangeSet(this.svnRch, this.svnSource, this.currentCrucibleUser, "22", Review.AttachMethod.LAST_BRANCH_POINT, null, ReviewCreationHelper.MetadataFilter.ALL_AND_FAIL);
        HibernateUtil.commitTransaction();
        Assert.assertEquals((String)"0 revisions should be added", (long)0L, (long)this.svnRch.getAddedItems().size());
        Assert.assertEquals((String)"0 messages are provided", (long)0L, (long)this.svnRch.getMessages().size());
    }

    private CrucibleRevision newMetadataOnlyRevision() {
        CrucibleRevision rev = new CrucibleRevision();
        rev.setModified(Boolean.valueOf(true));
        rev.setAdded(Boolean.valueOf(false));
        rev.setBinary(Boolean.valueOf(false));
        rev.setMoved(Boolean.valueOf(false));
        rev.setCopied(Boolean.valueOf(false));
        rev.setDeletion(Boolean.valueOf(false));
        return rev;
    }

    private void closeAndOpenNewSession() throws Exception {
        HibernateUtil.closeSession();
        HibernateUtil.currentSession();
        this.currentCrucibleUser = ModelUtils.makeAndSaveUser("fred");
        this.currentUser = this.createTrustedUserLogin("fred");
        this.cvsSource = this.sourceFactory.getSource(this.cvsHandle.acquireEngine().getRevisionCache().getRepositoryName(), (Principal)this.currentUser);
        this.review = this.reviewManager.getReviewById(this.review.getId());
        this.cvsRch = new ReviewCreationHelper(this.cvsSource, this.review, this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), (SPIUtils)new DummySPIUtils(), (CommentManager)Mockito.mock(CommentManager.class), (EventPublisher)Mockito.mock(EventPublisher.class));
    }

    private UserLogin createTrustedUserLogin(String username) throws DbException, LicensePolicyException {
        ((GroupMembershipManager)SpringContext.getComponentByClass(GroupMembershipManager.class)).addUserToGroup("team-1", username);
        return AppConfig.getsConfig().getUserManager().createTrustedUserLogin(username);
    }
}

