/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.fecru.util.EggTimer;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.PatchSource;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.util.PatchAnchorHelper;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.util.Pair;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class PatchAnchorHelperTest {
    private static final String SOURCE_NAME = "some-repo";
    private PatchAnchorHelper patchAnchorHelper;
    private ContentManager contentManager;
    private EggTimer eggTimer;
    private PatchSource patchSource;
    private RepositorySource source;

    @Before
    public void setUp() throws Exception {
        this.patchAnchorHelper = new PatchAnchorHelper();
        this.contentManager = (ContentManager)Mockito.mock(ContentManager.class);
        this.eggTimer = (EggTimer)Mockito.mock(EggTimer.class);
        this.patchSource = (PatchSource)Mockito.mock(PatchSource.class);
        this.source = (RepositorySource)Mockito.mock(RepositorySource.class);
        Mockito.when((Object)this.source.getName()).thenReturn((Object)SOURCE_NAME);
        Mockito.when((Object)this.source.isAvailable()).thenReturn((Object)true);
    }

    @Test
    public void testAnchorPatch_AddedRevisionsOnly_OneSource_Should_AnchorPatch() throws Exception {
        CrucibleRevision cr1 = (CrucibleRevision)Mockito.mock(CrucibleRevision.class);
        CrucibleRevision cr2 = (CrucibleRevision)Mockito.mock(CrucibleRevision.class);
        Mockito.when((Object)cr1.isAdded()).thenReturn((Object)true);
        Mockito.when((Object)cr2.isAdded()).thenReturn((Object)true);
        Patch patch = new Patch();
        patch.setId(Integer.valueOf(5));
        patch.setUploadItem((UploadItem)Mockito.mock(UploadItem.class));
        patch.setFileRevisions((List)Lists.newArrayList((Object[])new CrucibleRevision[]{cr1, cr2}));
        PatchAnchorHelper.PatchAnchorResult result = this.patchAnchorHelper.anchorPatch(this.contentManager, patch, this.patchSource, (Source)this.source, this.eggTimer);
        Assert.assertTrue((boolean)result.worked);
        Assert.assertTrue((String)"Patch should be anchored", (boolean)patch.isAnchored());
        Assert.assertEquals((String)"Patch anchored name should match the only source name given", (Object)SOURCE_NAME, (Object)patch.getAnchorSource());
    }

    @Test
    public void testAnchorPatch_AddedRevisionsOnly_OneUnavailableSource_ShouldNot_AnchorPatch() throws Exception {
        Mockito.when((Object)this.source.isAvailable()).thenReturn((Object)false);
        CrucibleRevision cr1 = (CrucibleRevision)Mockito.mock(CrucibleRevision.class);
        CrucibleRevision cr2 = (CrucibleRevision)Mockito.mock(CrucibleRevision.class);
        Mockito.when((Object)cr1.isAdded()).thenReturn((Object)true);
        Mockito.when((Object)cr2.isAdded()).thenReturn((Object)true);
        Patch patch = new Patch();
        patch.setId(Integer.valueOf(5));
        patch.setUploadItem((UploadItem)Mockito.mock(UploadItem.class));
        patch.setFileRevisions((List)Lists.newArrayList((Object[])new CrucibleRevision[]{cr1, cr2}));
        PatchAnchorHelper.PatchAnchorResult result = this.patchAnchorHelper.anchorPatch(this.contentManager, patch, this.patchSource, (Source)this.source, null);
        Assert.assertFalse((String)"Anchoring must not work", (boolean)result.worked);
        Assert.assertFalse((String)"Patch mustn't be anchored", (boolean)patch.isAnchored());
    }

    @Test
    public void testAnchorPatch_AddedRevisionsOnly_MultipleSource_ShouldNot_AnchorPatch() throws Exception {
        CrucibleRevision cr1 = (CrucibleRevision)Mockito.mock(CrucibleRevision.class);
        CrucibleRevision cr2 = (CrucibleRevision)Mockito.mock(CrucibleRevision.class);
        Mockito.when((Object)cr1.isAdded()).thenReturn((Object)true);
        Mockito.when((Object)cr2.isAdded()).thenReturn((Object)true);
        Patch patch = new Patch();
        patch.setId(Integer.valueOf(5));
        patch.setUploadItem((UploadItem)Mockito.mock(UploadItem.class));
        patch.setFileRevisions((List)Lists.newArrayList((Object[])new CrucibleRevision[]{cr1, cr2}));
        RepositorySource source2 = (RepositorySource)Mockito.mock(RepositorySource.class);
        this.mockSourceToReturnNothing(this.source);
        this.mockSourceToReturnNothing(source2);
        PatchAnchorHelper.PatchAnchorResult result = this.patchAnchorHelper.findSourceAndAnchorPatch(this.contentManager, patch, this.patchSource, (Iterable)Lists.newArrayList((Object[])new Source[]{this.source, source2}), this.eggTimer, Optional.empty());
        Assert.assertFalse((String)"Anchoring must not work", (boolean)result.worked);
        Assert.assertFalse((String)"Patch mustn't be anchored", (boolean)patch.isAnchored());
        Assert.assertEquals((Object)"Patch contains added revisions only. You have to specify repository to which it should be anchored.", (Object)result.errorMsg);
    }

    private void mockSourceToReturnNothing(RepositorySource source) throws IOException {
        RepositoryEngine engine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class);
        Mockito.when((Object)source.getRepoEngine()).thenReturn((Object)engine);
        Mockito.when((Object)source.getRootPaths((Patch)Matchers.any(), (EggTimer)Matchers.any())).thenReturn((Object)Pair.newInstance((Object)0, Collections.emptyMap()));
    }
}

