/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.crucible.util.FreemarkerUtil;
import com.cenqua.fisheye.config.RootConfigRule;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FreemarkerUtilTest {
    @Rule
    public RootConfigRule rootConfigRule = new RootConfigRule();

    @Test
    public void testNewlinesConvertedToBrs() {
        Assert.assertEquals((Object)"", (Object)FreemarkerUtil.newlinesToBrs((String)""));
        Assert.assertEquals((Object)"HelloGoodbye", (Object)FreemarkerUtil.newlinesToBrs((String)"HelloGoodbye"));
        Assert.assertEquals((Object)"Hello<br/>Goodbye", (Object)FreemarkerUtil.newlinesToBrs((String)"Hello\nGoodbye"));
        Assert.assertEquals((Object)"Hello<br/>Goodbye", (Object)FreemarkerUtil.newlinesToBrs((String)"Hello\rGoodbye"));
        Assert.assertEquals((Object)"Hello<br/>Goodbye", (Object)FreemarkerUtil.newlinesToBrs((String)"Hello\r\nGoodbye"));
        Assert.assertEquals((Object)"Hello<br/><br/><br/>Goodbye", (Object)FreemarkerUtil.newlinesToBrs((String)"Hello\r\n\r\n\r\nGoodbye"));
        Assert.assertEquals((Object)"Hello<br/><br/><br/>Goodbye", (Object)FreemarkerUtil.newlinesToBrs((String)"Hello\r\r\rGoodbye"));
        Assert.assertEquals((Object)"Hello<br/><br/><br/>Goodbye", (Object)FreemarkerUtil.newlinesToBrs((String)"Hello\n\n\nGoodbye"));
        Assert.assertEquals((Object)"<br/>Hello<br/>Goodbye<br/>", (Object)FreemarkerUtil.newlinesToBrs((String)"\r\nHello\r\nGoodbye\r\n"));
        Assert.assertEquals((Object)"<br/>Hello<br/>Goodbye<br/>", (Object)FreemarkerUtil.newlinesToBrs((String)"\rHello\rGoodbye\r"));
        Assert.assertEquals((Object)"<br/>Hello<br/>Goodbye<br/>", (Object)FreemarkerUtil.newlinesToBrs((String)"\nHello\nGoodbye\n"));
        Assert.assertEquals((Object)"<br/><br/>", (Object)FreemarkerUtil.newlinesToBrs((String)"\r\n\r\n"));
        Assert.assertEquals((Object)"<br/><br/>", (Object)FreemarkerUtil.newlinesToBrs((String)"\r\r"));
        Assert.assertEquals((Object)"<br/><br/>", (Object)FreemarkerUtil.newlinesToBrs((String)"\n\n"));
    }

    @Test
    public void testStripParagraph_ParagraphGetsStripped() throws Exception {
        Assert.assertThat((String)"paragraph gets p tag stripped", (Object)FreemarkerUtil.stripParagraph((String)"<p>some <p>nested</p> paragraph</p> \n"), (Matcher)Matchers.equalTo((Object)"some <p>nested</p> paragraph"));
    }

    @Test
    public void testStripParagraph_OnlyParagraphGetsStripped() throws Exception {
        Assert.assertThat((String)"lack of closing paragraph tag prevents strip", (Object)FreemarkerUtil.stripParagraph((String)"<p>some paragraph</p> with <ul><li>some list</li></ul>"), (Matcher)Matchers.equalTo((Object)"<p>some paragraph</p> with <ul><li>some list</li></ul>"));
        Assert.assertThat((String)"lack of closing paragraph tag prevents strip, even with trailing characters", (Object)FreemarkerUtil.stripParagraph((String)"<p>some paragraph</p> with <ul><li>some list</li></ul>\n"), (Matcher)Matchers.equalTo((Object)"<p>some paragraph</p> with <ul><li>some list</li></ul>"));
    }

    @Test
    public void testStripParagraph_NullAndEmptyIgnored() throws Exception {
        Assert.assertThat((String)"null string not stripped", (Object)FreemarkerUtil.stripParagraph(null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((String)"empty string not stripped", (Object)FreemarkerUtil.stripParagraph((String)""), (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    public void testInit() throws Exception {
        Mockito.when((Object)this.rootConfigRule.getRootConfig().getSiteURL()).thenReturn((Object)"https://my.server/with-context");
        Map params = FreemarkerUtil.init();
        Assert.assertThat((Object)params, (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)"staticPath", (Object)"currentstatic"), (Matcher)Matchers.hasEntry((Object)"siteurl", (Object)"https://my.server/with-context")));
    }
}

