/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.util.EmailAllCommentsFormatter;
import java.util.Arrays;
import junit.framework.TestCase;

public class EmailAllCommentsFormatterTest
extends TestCase {
    private final EmailAllCommentsFormatter formatter = new EmailAllCommentsFormatter();
    private Comment root = null;
    private Comment firstLevel = null;
    private Comment secondLevel = null;

    protected void setUp() throws Exception {
        this.root = new Comment();
        this.root.setId(Integer.valueOf(1));
        this.root.setMessage("foo");
        this.firstLevel = new Comment();
        this.firstLevel.setId(Integer.valueOf(2));
        this.firstLevel.setMessage("bar");
        this.secondLevel = new Comment();
        this.secondLevel.setId(Integer.valueOf(3));
        this.secondLevel.setMessage("foobar");
        this.root.addComment(this.firstLevel);
        this.firstLevel.addComment(this.secondLevel);
    }

    public void testIndentationDepth() {
        EmailAllCommentsFormatterTest.assertEquals((int)0, (int)this.formatter.getIndentationDepth(this.root));
        EmailAllCommentsFormatterTest.assertEquals((int)1, (int)this.formatter.getIndentationDepth(this.firstLevel));
        EmailAllCommentsFormatterTest.assertEquals((int)2, (int)this.formatter.getIndentationDepth(this.secondLevel));
    }

    public void testIndent() {
        EmailAllCommentsFormatter formatter = new EmailAllCommentsFormatter(" ", 2);
        EmailAllCommentsFormatterTest.assertEquals((String)"foo", (String)formatter.indent("foo", 0));
        EmailAllCommentsFormatterTest.assertEquals((String)" foo", (String)formatter.indent("foo", 1));
        EmailAllCommentsFormatterTest.assertEquals((String)"  foo", (String)formatter.indent("foo", 10));
    }

    public void testWrapAndIndent() {
    }

    public void testMaxIndentLevel() {
        EmailAllCommentsFormatterTest.assertEquals((String)("> " + this.firstLevel.getMessage()), (String)new EmailAllCommentsFormatter(" ", 0).wrapAndPrefixAndIndent(this.firstLevel, 80, "> "));
        EmailAllCommentsFormatterTest.assertEquals((String)("> " + this.secondLevel.getMessage()), (String)new EmailAllCommentsFormatter(" ", 0).wrapAndPrefixAndIndent(this.secondLevel, 80, "> "));
        EmailAllCommentsFormatterTest.assertEquals((String)("> " + this.root.getMessage()), (String)new EmailAllCommentsFormatter(" ", 1).wrapAndPrefixAndIndent(this.root, 80, "> "));
        EmailAllCommentsFormatterTest.assertEquals((String)(" > " + this.firstLevel.getMessage()), (String)new EmailAllCommentsFormatter(" ", 1).wrapAndPrefixAndIndent(this.firstLevel, 80, "> "));
        EmailAllCommentsFormatterTest.assertEquals((String)(" > " + this.secondLevel.getMessage()), (String)new EmailAllCommentsFormatter(" ", 1).wrapAndPrefixAndIndent(this.secondLevel, 80, "> "));
    }

    public void testJustifySimple() {
        this.root.setMessage("1234567890 1234567890 1234567890 1234567890 1234567890 1234567890");
        String output = this.formatter.wrapAndPrefixAndIndent(this.root, 10, "");
        EmailAllCommentsFormatterTest.assertEquals((String)"1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890", (String)output);
    }

    public void testJustifySimple2() {
        this.root.setMessage("12 34 567 890 00 1 23 456 78 1 25 67 890 1 23 453 3 36 7 89 0 1234 567890 1234 56 7890");
        String output = this.formatter.wrapAndPrefixAndIndent(this.root, 10, "");
        EmailAllCommentsFormatterTest.assertEquals((String)"12 34 567\n890 00 1\n23 456 78\n1 25 67\n890 1 23\n453 3 36 7\n89 0 1234\n567890\n1234 56\n7890", (String)output);
    }

    public void testJustifyNoSpace() {
        this.root.setMessage("abcdefg");
        String output = this.formatter.wrapAndPrefixAndIndent(this.root, 10, "");
        EmailAllCommentsFormatterTest.assertEquals((String)"abcdefg", (String)output);
    }

    public void testJustifyOneSpace() {
        this.root.setMessage(" ");
        String output = this.formatter.wrapAndPrefixAndIndent(this.root, 10, "");
        EmailAllCommentsFormatterTest.assertEquals((String)" ", (String)output);
    }

    public void testNewLineChars() {
        this.root.setMessage("1234\n1 34  \n\n\n\t   1 3 5");
        String output = this.formatter.wrapAndPrefixAndIndent(this.root, 6, ">");
        String expected = ">1234\n>1 34\n>\n>\n>\n>\t   1\n>3 5";
        EmailAllCommentsFormatterTest.assertEquals((String)">1234\n>1 34\n>\n>\n>\n>\t   1\n>3 5", (String)output);
    }

    public void testFormatSimple() {
        this.root.setMessage("1234567890 1234567890 1234567890 1234567890 1234567890 1234567890");
        String output = this.formatter.wrapAndPrefixAndIndent(this.root, 12, " >");
        String expected = " >1234567890\n >1234567890\n >1234567890\n >1234567890\n >1234567890\n >1234567890";
        EmailAllCommentsFormatterTest.assertEquals((String)" >1234567890\n >1234567890\n >1234567890\n >1234567890\n >1234567890\n >1234567890", (String)output);
    }

    public void testFormatSimpleWithTrailingWhiteSpace() {
        this.root.setMessage("1 ");
        String output = this.formatter.wrapAndPrefixAndIndent(this.root, 1, "");
        String expected = "1\n";
        EmailAllCommentsFormatterTest.assertEquals((String)"1\n", (String)output);
    }

    public void testFormatSimple2() {
        this.root.setMessage("12 34 567 890 00 1 23 456 78 1 25 67 890 1 23 453 3 36 7 89 0 1234 567890 1234 56 7890");
        String output = this.formatter.wrapAndPrefixAndIndent(this.root, 12, " >");
        String expected = " >12 34 567\n >890 00 1\n >23 456 78\n >1 25 67\n >890 1 23\n >453 3 36 7\n >89 0 1234\n >567890\n >1234 56\n >7890";
        EmailAllCommentsFormatterTest.assertEquals((String)" >12 34 567\n >890 00 1\n >23 456 78\n >1 25 67\n >890 1 23\n >453 3 36 7\n >89 0 1234\n >567890\n >1234 56\n >7890", (String)output);
    }

    public void testFormatWikiText() {
        this.root.setMessage("h1. heading 1\n\n*bold*\n\n * li\n * li blktokxyzkdtnhgnsbdfblktok2\n\n_emphasis_\n\nhttp://google.com\n\nCR-FE-1000\n\nh2. heading 2\n\n{noformat}\n*bold*\n{noformat}\n\n{cs:id=1023|rep=FE}\n\n!http://img.skitch.com/20090701-jjb9h8ajjk31asxy7g5epxk5j8.png!\n{noformat}\nh1. heading 1\n\n*bold*\n\n * li\n * li2\n\n_emphasis_\n\nhttp://google.com\n\nCR-FE-1000\n\nh2. heading 2\n\n\n{cs:id=1023|rep=FE}\n\n!http://img.skitch.com/20090701-jjb9h8ajjk31asxy7g5epxk5j8.png!\n\n{noformat}");
        String expected = "  >  h1. heading 1\n  >  \n  >  *bold*\n  >  \n  >   * li\n  >   * li blktokxyzkdtnhgnsbdfblktok2\n  >  \n  >  _emphasis_\n  >  \n  >  http://google.com\n  >  \n  >  CR-FE-1000\n  >  \n  >  h2. heading 2\n  >  \n  >  {noformat}\n  >  *bold*\n  >  {noformat}\n  >  \n  >  {cs:id=1023|rep=FE}\n  >  \n  >  !http://img.skitch.com/20090701-jjb9h8ajjk31asxy7g5epxk5j8.png!\n  >  {noformat}\n  >  h1. heading 1\n  >  \n  >  *bold*\n  >  \n  >   * li\n  >   * li2\n  >  \n  >  _emphasis_\n  >  \n  >  http://google.com\n  >  \n  >  CR-FE-1000\n  >  \n  >  h2. heading 2\n  >  \n  >  \n  >  {cs:id=1023|rep=FE}\n  >  \n  >  !http://img.skitch.com/20090701-jjb9h8ajjk31asxy7g5epxk5j8.png!\n  >  \n  >  {noformat}";
        String output = this.formatter.wrapAndPrefixAndIndent(this.root, 85, "  >  ");
        EmailAllCommentsFormatterTest.assertEquals((String)expected, (String)output);
    }

    public void testTrimEnd() {
        EmailAllCommentsFormatterTest.assertEquals((String)"", (String)EmailAllCommentsFormatter.trimEnd((String)""));
        EmailAllCommentsFormatterTest.assertEquals((String)"", (String)EmailAllCommentsFormatter.trimEnd((String)"  \t"));
        EmailAllCommentsFormatterTest.assertEquals((String)"foo", (String)EmailAllCommentsFormatter.trimEnd((String)"foo   \t "));
        EmailAllCommentsFormatterTest.assertEquals((String)"foo bar", (String)EmailAllCommentsFormatter.trimEnd((String)"foo bar   \t "));
        EmailAllCommentsFormatterTest.assertEquals((String)"   \t foo bar", (String)EmailAllCommentsFormatter.trimEnd((String)"   \t foo bar   \t "));
        EmailAllCommentsFormatterTest.assertEquals((String)"foo", (String)EmailAllCommentsFormatter.trimEnd((String)"foo  \n \t "));
    }

    public void testTrimStart() {
        EmailAllCommentsFormatterTest.assertEquals((String)"", (String)EmailAllCommentsFormatter.trimStart((String)""));
        EmailAllCommentsFormatterTest.assertEquals((String)"", (String)EmailAllCommentsFormatter.trimStart((String)"  \t"));
        EmailAllCommentsFormatterTest.assertEquals((String)"foo", (String)EmailAllCommentsFormatter.trimStart((String)"   \t foo"));
        EmailAllCommentsFormatterTest.assertEquals((String)"foo bar", (String)EmailAllCommentsFormatter.trimStart((String)"   \t foo bar"));
        EmailAllCommentsFormatterTest.assertEquals((String)"foo bar   \t ", (String)EmailAllCommentsFormatter.trimStart((String)"   \t foo bar   \t "));
    }

    public void testWrapSingleLine() {
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{""}, EmailAllCommentsFormatter.wrapLine((String)"", (int)10).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{" "}, EmailAllCommentsFormatter.wrapLine((String)" ", (int)10).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"foo bar"}, EmailAllCommentsFormatter.wrapLine((String)"foo bar", (int)10).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"foo bar"}, EmailAllCommentsFormatter.wrapLine((String)"foo bar", (int)7).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"foo", "bar"}, EmailAllCommentsFormatter.wrapLine((String)"foo bar", (int)6).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"foo", "bar"}, EmailAllCommentsFormatter.wrapLine((String)"foo  bar", (int)6).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"foobar"}, EmailAllCommentsFormatter.wrapLine((String)"foobar", (int)4).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"   foo", "bar"}, EmailAllCommentsFormatter.wrapLine((String)"   foo bar", (int)6).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"   foo", "bar   "}, EmailAllCommentsFormatter.wrapLine((String)"   foo bar   ", (int)6).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"foo", ""}, EmailAllCommentsFormatter.wrapLine((String)"foo   ", (int)3).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"foo", ""}, EmailAllCommentsFormatter.wrapLine((String)"foo      ", (int)3).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"foo", "foobar"}, EmailAllCommentsFormatter.wrapLine((String)"foo foobar", (int)5).toArray()));
        EmailAllCommentsFormatterTest.assertTrue((boolean)Arrays.equals(new String[]{"foobar", "foo"}, EmailAllCommentsFormatter.wrapLine((String)"foobar foo", (int)5).toArray()));
    }
}

