/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.commons.collections.BeanMap;

public class AssertUtils {
    public static void assertBeansEqual(Object desired, Object actual, String ... ignore) {
        BeanMap desiredMap = new BeanMap(desired);
        BeanMap actualMap = new BeanMap(actual);
        HashSet<String> ignoreSet = new HashSet<String>(Arrays.asList(ignore));
        for (String key : desiredMap.keySet()) {
            if (ignoreSet.contains(key)) continue;
            Object desiredElement = desiredMap.get((Object)key);
            Object actualElement = actualMap.get((Object)key);
            if (desiredElement instanceof Collection && actualElement instanceof Collection) {
                AssertUtils.assertCollectionEqual(key, (Collection)desiredElement, (Collection)actualElement);
                continue;
            }
            TestCase.assertEquals((String)key, (Object)desiredElement, (Object)actualElement);
        }
    }

    public static void assertCollectionEqual(String name, Collection expected, Collection actual) {
        TestCase.assertEquals((String)("size(" + name + ")"), (int)expected.size(), (int)actual.size());
        ArrayList copy = new ArrayList(expected);
        for (Object obj : actual) {
            TestCase.assertTrue((String)name, (boolean)copy.remove(obj));
        }
        TestCase.assertTrue((String)name, (boolean)copy.isEmpty());
    }
}

