/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.util;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.util.AlsoViewingCache;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AlsoViewingCacheTest {
    @Test
    public void testAlsoViewingCacheExpiry() throws Exception {
        final AtomicLong time = new AtomicLong();
        AlsoViewingCache alsoViewingCache = new AlsoViewingCache(){

            protected <K, V> CacheBuilder<K, V> newCacheBuilder(CacheBuilder<K, V> builder) {
                return super.newCacheBuilder(builder.ticker(new Ticker(){

                    public long read() {
                        return time.get();
                    }
                }));
            }
        };
        FecruUser user1 = AlsoViewingCacheTest.createMockUser("user1");
        FecruUser user2 = AlsoViewingCacheTest.createMockUser("user2");
        FecruUser user3 = AlsoViewingCacheTest.createMockUser("user3");
        Assert.assertThat((String)"Expecting no entries for anon user, first call", (Object)alsoViewingCache.updateAndGetUsersViewingReview("CR-1", null), (Matcher)Matchers.empty());
        Assert.assertThat((String)"Expecting no entries if first user", (Object)alsoViewingCache.updateAndGetUsersViewingReview("CR-1", user1), (Matcher)Matchers.empty());
        Assert.assertThat((String)"Expecting to see other user", (Object)alsoViewingCache.updateAndGetUsersViewingReview("CR-1", user2), (Matcher)Matchers.contains((Object[])new FecruUser[]{user1}));
        Assert.assertThat((String)"Expecting to see other user", (Object)alsoViewingCache.updateAndGetUsersViewingReview("CR-1", user1), (Matcher)Matchers.contains((Object[])new FecruUser[]{user2}));
        Assert.assertThat((String)"Expecting to see both users as anon", (Object)alsoViewingCache.updateAndGetUsersViewingReview("CR-1", null), (Matcher)Matchers.containsInAnyOrder((Object[])new FecruUser[]{user1, user2}));
        Assert.assertThat((String)"Expecting to see both users as 3rd user", (Object)alsoViewingCache.updateAndGetUsersViewingReview("CR-1", user3), (Matcher)Matchers.containsInAnyOrder((Object[])new FecruUser[]{user1, user2}));
        time.set(1L + TimeUnit.SECONDS.toNanos(25L));
        Assert.assertThat((String)"Expecting no entries after expiry", (Object)alsoViewingCache.updateAndGetUsersViewingReview("CR-1", user3), (Matcher)Matchers.empty());
        Assert.assertThat((String)"Expecting to see other user", (Object)alsoViewingCache.updateAndGetUsersViewingReview("CR-1", user1), (Matcher)Matchers.contains((Object[])new FecruUser[]{user3}));
    }

    private static FecruUser createMockUser(String username) {
        FecruUser user = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)user.getUsername()).thenReturn((Object)username);
        return user;
    }
}

