/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.upload;

import com.cenqua.crucible.upload.UploadManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.ByteOrderMark;
import org.junit.Assert;
import org.junit.Test;

public class UploadManagerTest {
    @Test
    public void testIsText() throws IOException {
        ByteOrderMark[] boms = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, new ByteOrderMark("UTF-32BE", new int[]{0, 0, 254, 255}), new ByteOrderMark("UTF-32LE", new int[]{254, 255, 0, 0})};
        for (Charset charset : Charset.availableCharsets().values()) {
            if (!charset.displayName().startsWith("UTF")) continue;
            byte[] stringBytes = "foo bar 1234".getBytes(charset);
            ByteOrderMark bom = null;
            for (ByteOrderMark b : boms) {
                if (!b.getCharsetName().equals(charset.name())) continue;
                bom = b;
            }
            if (bom == null) continue;
            byte[] bytes = new byte[stringBytes.length + bom.length()];
            System.arraycopy(bom.getBytes(), 0, bytes, 0, bom.length());
            System.arraycopy(stringBytes, 0, bytes, bom.length(), stringBytes.length);
            boolean text = UploadManager.isText((String)"application/binary", (InputStream)new ByteArrayInputStream(bytes));
            Assert.assertTrue((String)("Charset " + charset.displayName() + " not text."), (boolean)text);
        }
    }
}

