/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tetris;

import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.tetris.TetrisGrid;
import com.cenqua.crucible.tetris.TetrisLine;
import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.DiffSequences;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.ListDiffSequences;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class TetrisGridTest {
    private FRXRevision from;
    private TetrisGrid grid;
    String[] names1 = new String[]{"fred", "joe", "matt"};
    String[] names2 = new String[]{"fred", "matt"};
    String[] names3 = new String[]{"freddy", "joe", "jim", "matt"};
    String[] names4 = new String[]{"bob", "jim", "matt"};
    String[] names5 = new String[]{"bill", "jim", "matt"};
    String[] names6 = new String[]{"bill", "jim", "matt", "tim"};
    String[] names7 = new String[]{"tim", "bill", "jim", "matt"};
    private static final String[] lao = new String[]{"The Way that can be told of is not the eternal Way;", "The name that can be named is not the eternal name.", "The Nameless is the origin of Heaven and Earth;", "The Named is the mother of all things.", "Therefore let there always be non-being,", "  so we may see their subtlety,", "And let there always be being,", "  so we may see their outcome.", "The two are the same,", "But after they are produced,", "  they have different names."};
    private static final String[] tzu = new String[]{"The Nameless is the origin of Heaven and Earth;", "The named is the mother of all things.", "", "Therefore let there always be non-being,", "  so we may see their subtlety,", "And let there always be being,", "  so we may see their outcome.", "The two are the same,", "But after they are produced,", "  they have different names.", "They both may be called deep and profound.", "Deeper and more profound,", "The door of all subtleties!"};

    @Before
    public void setUp() {
        this.grid = new TetrisGrid();
        this.from = new FRXRevision();
        this.from.setId(Integer.valueOf(0));
    }

    @After
    public void tearDown() {
        this.grid = null;
    }

    @Test
    public void testLaoTzu() throws Exception {
        TetrisGrid grid = new TetrisGrid();
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])lao, (Object[])tzu));
        grid.setHunkList(this.from, hunkList);
        Map map = grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 11 ? 1 : 0) != 0);
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(0)).isDelete());
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(1)).isDelete());
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(2)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(2)).isEqual());
        Assert.assertEquals((String)"1-2", (String)((TetrisLine)lines.get(3)).getLineRange());
        Assert.assertFalse((boolean)((TetrisLine)lines.get(3)).isEqual());
        Assert.assertEquals((String)"3", (String)((TetrisLine)lines.get(4)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(4)).isEqual());
        Assert.assertEquals((String)"4", (String)((TetrisLine)lines.get(5)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(5)).isEqual());
        Assert.assertEquals((String)"5", (String)((TetrisLine)lines.get(6)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(6)).isEqual());
        Assert.assertEquals((String)"6", (String)((TetrisLine)lines.get(7)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(7)).isEqual());
        Assert.assertEquals((String)"7", (String)((TetrisLine)lines.get(8)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(8)).isEqual());
        Assert.assertEquals((String)"8", (String)((TetrisLine)lines.get(9)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(9)).isEqual());
        Assert.assertEquals((String)"9", (String)((TetrisLine)lines.get(10)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(10)).isEqual());
    }

    @Test
    public void testNoChange() throws Exception {
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])this.names1, (Object[])this.names1));
        this.grid.setHunkList(this.from, hunkList);
        Map map = this.grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(0)).isEqual());
        Assert.assertEquals((String)"1", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(1)).isEqual());
        Assert.assertEquals((String)"2", (String)((TetrisLine)lines.get(2)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(2)).isEqual());
    }

    @Test
    public void testAddLineFront() throws Exception {
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])this.names5, (Object[])this.names7));
        this.grid.setHunkList(this.from, hunkList);
        Map map = this.grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"1", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(0)).isEqual());
        Assert.assertEquals((String)"2", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(1)).isEqual());
        Assert.assertEquals((String)"3", (String)((TetrisLine)lines.get(2)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(2)).isEqual());
    }

    @Test
    public void testAddLineMiddle() throws Exception {
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])this.names2, (Object[])this.names1));
        this.grid.setHunkList(this.from, hunkList);
        Map map = this.grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(0)).isEqual());
        Assert.assertEquals((String)"2", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(1)).isEqual());
    }

    @Test
    public void testAddLineEnd() throws Exception {
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])this.names5, (Object[])this.names6));
        this.grid.setHunkList(this.from, hunkList);
        Map map = this.grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(0)).isEqual());
        Assert.assertEquals((String)"1", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(1)).isEqual());
        Assert.assertEquals((String)"2", (String)((TetrisLine)lines.get(2)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(2)).isEqual());
    }

    @Test
    public void testDeleteLinesMiddle() throws Exception {
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])this.names1, (Object[])this.names2));
        this.grid.setHunkList(this.from, hunkList);
        Map map = this.grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(0)).isEqual());
        Assert.assertEquals((String)"1", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertFalse((boolean)((TetrisLine)lines.get(1)).isEqual());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(1)).isDelete());
        Assert.assertEquals((String)"1", (String)((TetrisLine)lines.get(2)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(2)).isEqual());
    }

    @Test
    public void testDeleteLineEnd() throws Exception {
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])this.names6, (Object[])this.names5));
        this.grid.setHunkList(this.from, hunkList);
        Map map = this.grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(0)).isEqual());
        Assert.assertEquals((String)"1", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(1)).isEqual());
        Assert.assertEquals((String)"2", (String)((TetrisLine)lines.get(2)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(2)).isEqual());
        Assert.assertEquals((String)"3", (String)((TetrisLine)lines.get(3)).getLineRange());
        Assert.assertFalse((boolean)((TetrisLine)lines.get(3)).isEqual());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(3)).isDelete());
    }

    @Test
    public void testChangeIncreaseLines() throws Exception {
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])this.names2, (Object[])this.names3));
        this.grid.setHunkList(this.from, hunkList);
        Map map = this.grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"0-2", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertFalse((boolean)((TetrisLine)lines.get(0)).isEqual());
        Assert.assertEquals((String)"3", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(1)).isEqual());
    }

    @Test
    public void testChangeDecreaseLines() throws Exception {
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])this.names3, (Object[])this.names4));
        this.grid.setHunkList(this.from, hunkList);
        Map map = this.grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertFalse((boolean)((TetrisLine)lines.get(0)).isEqual());
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertFalse((boolean)((TetrisLine)lines.get(1)).isEqual());
        Assert.assertEquals((String)"1", (String)((TetrisLine)lines.get(2)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(2)).isEqual());
        Assert.assertEquals((String)"2", (String)((TetrisLine)lines.get(3)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(3)).isEqual());
    }

    @Test
    public void testChangeLine() throws Exception {
        HunkList hunkList = Diff.diff((DiffSequences)new ListDiffSequences((Object[])this.names4, (Object[])this.names5));
        this.grid.setHunkList(this.from, hunkList);
        Map map = this.grid.getTetrisGrid();
        Assert.assertTrue((map.size() == 1 ? 1 : 0) != 0);
        List lines = (List)map.get(this.from);
        Assert.assertTrue((lines.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"0", (String)((TetrisLine)lines.get(0)).getLineRange());
        Assert.assertFalse((boolean)((TetrisLine)lines.get(0)).isEqual());
        Assert.assertEquals((String)"1", (String)((TetrisLine)lines.get(1)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(1)).isEqual());
        Assert.assertEquals((String)"2", (String)((TetrisLine)lines.get(2)).getLineRange());
        Assert.assertTrue((boolean)((TetrisLine)lines.get(2)).isEqual());
    }
}

