/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.tags;

import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.tags.ProjectUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.model.ContentRoot;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class ProjectUtilTest {
    @Test
    public void testNoDefaultProjectConstraintsAndNoPaths() {
        DetachedProject project = new DetachedProject();
        project.setId(0);
        RepositoryConstraints constraints = ProjectUtil.generateRepositoryConstraint((Project)project);
        Assert.assertFalse((boolean)constraints.isIncludeWholeRepository("repo"));
        junit.framework.Assert.assertEquals((int)0, (int)constraints.getReps().size());
    }

    @Test
    public void testDefaultProjectConstraintsAndNoPaths() {
        DetachedProject project = new DetachedProject();
        project.setId(0);
        project.setDefaultRepositoryName("repo");
        RepositoryConstraints constraints = ProjectUtil.generateRepositoryConstraint((Project)project);
        Assert.assertTrue((boolean)constraints.isIncludeWholeRepository("repo"));
        junit.framework.Assert.assertEquals((int)1, (int)constraints.getReps().size());
        junit.framework.Assert.assertEquals((String)"repo", (String)((String)constraints.getReps().iterator().next()));
    }

    @Test
    public void testDefaultProjectConstraintsWithPathWithin() {
        DetachedProject project = new DetachedProject();
        project.setId(0);
        project.setDefaultRepositoryName("repo");
        ContentRoot contentRoot = new ContentRoot((Project)project, "repo", "/apath");
        contentRoot.setId(0);
        project.addContentRoot(contentRoot);
        RepositoryConstraints constraints = ProjectUtil.generateRepositoryConstraint((Project)project);
        Assert.assertFalse((boolean)constraints.isIncludeWholeRepository("repo"));
        junit.framework.Assert.assertEquals((int)1, (int)constraints.getReps().size());
        junit.framework.Assert.assertEquals((String)"repo", (String)((String)constraints.getReps().iterator().next()));
        junit.framework.Assert.assertEquals((int)1, (int)constraints.getConstraintsForRep("repo").getPaths().size());
        junit.framework.Assert.assertEquals((String)"apath", (String)((Path)constraints.getConstraintsForRep("repo").getPaths().iterator().next()).toString());
    }

    @Test
    public void testNoDefaultProjectConstraintsButWithPaths() {
        DetachedProject project = new DetachedProject();
        project.setId(0);
        ContentRoot contentRoot = new ContentRoot((Project)project, "repo", "/apath");
        contentRoot.setId(0);
        project.addContentRoot(contentRoot);
        ContentRoot contentRoot2 = new ContentRoot((Project)project, "repo2", "/apath2");
        contentRoot2.setId(1);
        project.addContentRoot(contentRoot2);
        ContentRoot contentRoot3 = new ContentRoot((Project)project, "repo2", "/apath3");
        contentRoot3.setId(2);
        project.addContentRoot(contentRoot3);
        RepositoryConstraints constraints = ProjectUtil.generateRepositoryConstraint((Project)project);
        Assert.assertFalse((boolean)constraints.isIncludeWholeRepository("repo"));
        Assert.assertFalse((boolean)constraints.isIncludeWholeRepository("repo2"));
        junit.framework.Assert.assertEquals((int)2, (int)constraints.getReps().size());
        Assert.assertTrue((boolean)constraints.getReps().contains("repo"));
        Assert.assertTrue((boolean)constraints.getReps().contains("repo2"));
        junit.framework.Assert.assertEquals((int)1, (int)constraints.getConstraintsForRep("repo").getPaths().size());
        junit.framework.Assert.assertEquals((int)2, (int)constraints.getConstraintsForRep("repo2").getPaths().size());
        junit.framework.Assert.assertEquals((String)"apath", (String)((Path)constraints.getConstraintsForRep("repo").getPaths().iterator().next()).toString());
        junit.framework.Assert.assertEquals((Object)new HashSet<Path>(){
            {
                this.add(new Path((CharSequence)"apath2"));
                this.add(new Path((CharSequence)"apath3"));
            }
        }, (Object)constraints.getConstraintsForRep("repo2").getPaths());
    }

    private class DetachedProject
    extends Project {
        private DetachedProject() {
        }

        protected boolean hasExtantDefaultFisheyeRepo() {
            return true;
        }
    }
}

