/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.spi;

import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.crucible.spi.services.NotFoundException;
import com.atlassian.crucible.spi.services.NotPermittedException;
import com.atlassian.crucible.spi.services.ReviewService;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserPermissionsTestRule;
import com.atlassian.fisheye.scm.SCMModuleManager;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.services.RevisionDataService;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.DefaultSourceFactory;
import com.cenqua.crucible.util.AssertUtils;
import com.cenqua.crucible.util.DummyScmModuleManager;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import java.util.concurrent.Callable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mockito;

public abstract class ServiceTestBase
extends UseTestSpringContextTestCase {
    protected FecruUser currentCrucibleUser;
    protected FecruUser fred;
    protected FecruUser joe;
    protected FecruUser jim;
    protected UserLogin currentUser;
    protected TxTemplate txTemplate;
    protected DefaultReviewManager reviewManager;
    protected ReviewService reviewService;
    protected RevisionDataService revisionService;
    protected SPIUtils spiUtils;
    protected DefaultSourceFactory sourceFactory;
    protected ContentManager contentManager;
    protected UserManager userManager;
    protected GroupMembershipManager groupMembershipManager;
    protected CommentManager commentManager;
    protected EffectiveUserProviderImpl effectiveUserProvider;
    protected PermissionManager permissionManager;
    public UserPermissionsTestRule userPermissionsTestRule;

    @Before
    public void setupServiceTest() throws Exception {
        TestFishEyeInstances.checkCleanStart();
        TestFishEyeInstances.deleteData0();
        Disposer.pushThreadInstance();
        TestFishEyeInstances.loadSanity1();
        this.userManager = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        this.userManager.addGroup("team-1");
        this.userPermissionsTestRule = (UserPermissionsTestRule)((Object)SpringContext.createComponent(UserPermissionsTestRule.class));
        this.userPermissionsTestRule.before();
        this.joe = this.userPermissionsTestRule.addFecruUser("joe", "joe", "joe");
        this.jim = this.userPermissionsTestRule.addFecruUser("jim", "jim", "jim");
        this.fred = this.currentCrucibleUser = this.userPermissionsTestRule.addFecruUser("fred", "fred", "fred");
        this.groupMembershipManager = (GroupMembershipManager)SpringContext.getComponentByClass(GroupMembershipManager.class);
        UserActionManager.resetForTests();
        UserActionManager.getInstance();
        this.permissionManager = (PermissionManager)SpringContext.getComponentByClass(PermissionManager.class);
        this.permissionManager.getDefaultPermissionScheme().removeAnonAction(UserActionManager.ACTION_VIEW);
        this.currentUser = this.createTrustedUserLogin("fred");
        this.effectiveUserProvider = (EffectiveUserProviderImpl)SpringContext.getComponent(EffectiveUserProviderImpl.class, (String)"effectiveUserProvider");
        this.txTemplate = (TxTemplate)SpringContext.getComponent((String)"txTemplate");
        this.txTemplate.setEffectivePrincipal((Principal)this.currentUser, this.currentCrucibleUser);
        this.reviewManager = (DefaultReviewManager)SpringContext.getComponentByClass(ReviewManager.class);
        this.reviewService = (ReviewService)SpringContext.getComponent((String)"reviewService");
        this.revisionService = (RevisionDataService)SpringContext.getComponent((String)"revisionDataService");
        this.spiUtils = (SPIUtils)SpringContext.getComponentByClass(SPIUtils.class);
        this.contentManager = (ContentManager)SpringContext.getComponentByClass(ContentManager.class);
        this.sourceFactory = new DefaultSourceFactory();
        this.sourceFactory.setScmModuleManager((SCMModuleManager)new DummyScmModuleManager());
        this.sourceFactory.setNotificationManager((NotificationManager)Mockito.mock(NotificationManager.class));
        this.sourceFactory.setContentManager(this.contentManager);
        this.commentManager = (CommentManager)SpringContext.getComponent((String)"commentManager");
    }

    @After
    public final void tearDownServiceTest() throws Exception {
        HibernateUtil.forceRollbackTransaction();
        HibernateUtil.closeSession();
        this.userPermissionsTestRule.after();
        HibernateUtil.closeSession();
        this.txTemplate.setEffectivePrincipal((Principal)Principal.Anonymous.ANON, null);
        Disposer.popThreadInstance();
        this.currentCrucibleUser = null;
        this.currentUser = null;
        this.fred = null;
        this.joe = null;
        this.jim = null;
        this.txTemplate = null;
        this.reviewManager = null;
        this.spiUtils = null;
        this.contentManager = null;
        this.sourceFactory = null;
        TestFishEyeInstances.stop();
    }

    protected void useAnonUser() {
        this.txTemplate.setEffectivePrincipal((Principal)Principal.Anonymous.ANON, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doAsAnonUser(Callable<T> callable) throws Exception {
        try {
            T result;
            this.txTemplate.pushEffectivePrincipal((Principal)Principal.Anonymous.ANON, null);
            T t = result = callable.call();
            return t;
        }
        finally {
            this.txTemplate.popEffectivePrincipal();
        }
    }

    protected UserLogin createTrustedUserLogin(String username) throws DbException, LicensePolicyException {
        UserLogin ul = this.userManager.createTrustedUserLogin(username);
        this.groupMembershipManager.addUserToGroup("team-1", ul.getUsername());
        return ul;
    }

    protected void assertDocumentNotFound(Runnable action) {
        this.assertException("Non-existent document should not have been found.", NotFoundException.class, action);
    }

    protected void assertAnonUserCannotDo(Runnable action, String type) {
        this.assertAnonUserCannotDo(action, type, true);
    }

    protected void assertAnonUserCannotDo(Runnable action, String type, boolean autoAnonymize) {
        if (autoAnonymize) {
            this.useAnonUser();
        }
        this.assertException("anon user should not have been allowed to " + type, NotPermittedException.class, action);
    }

    protected void assertException(String message, Class<? extends Exception> expectedException, Runnable action) {
        try {
            action.run();
            Assert.fail((String)(expectedException.getName() + " expected: " + message));
        }
        catch (Exception e) {
            Assert.assertTrue((String)String.format("Unexpected exception occured. Expected: %s, actual: %s", expectedException.getName(), e.getClass().getName()), (boolean)expectedException.isAssignableFrom(e.getClass()));
        }
    }

    protected void assertBeansEqual(Object desired, Object actual) {
        AssertUtils.assertBeansEqual(desired, actual, new String[0]);
    }

    protected void assertNoSession() {
        Assert.assertFalse((boolean)HibernateUtil.isCurrentSession());
    }
}

