/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.spi;

import com.cenqua.crucible.spi.ServiceTestBase;
import java.util.concurrent.CyclicBarrier;
import org.junit.Assert;

public abstract class MultithreadedServiceTestBase
extends ServiceTestBase {
    public static final int N = 10;
    int threadcount = 0;
    CyclicBarrier rendevous = new CyclicBarrier(10);

    protected void startWorkers() throws Exception {
        Worker[] workers = new Worker[10];
        for (int i = 0; i < 10; ++i) {
            workers[i] = this.getWorker();
            workers[i].start();
        }
        boolean workerExceptions = false;
        for (Worker worker : workers) {
            worker.join(100000L);
            if (worker.ex != null) {
                worker.ex.printStackTrace();
                workerExceptions = true;
            }
            worker.verifyStateOnShutdown();
        }
        if (workerExceptions) {
            Assert.fail((String)"Workers got exceptions");
        }
    }

    public abstract Worker getWorker();

    public abstract class Worker
    extends Thread {
        int threadnum;
        Exception ex;

        public Worker() {
            this.threadnum = MultithreadedServiceTestBase.this.threadcount++;
            this.setName("worker" + this.threadnum);
        }

        @Override
        public void run() {
            this.log("started...");
            try {
                MultithreadedServiceTestBase.this.rendevous.await();
                this.runImpl();
            }
            catch (Exception e) {
                this.ex = e;
                e.printStackTrace();
            }
        }

        public abstract void runImpl() throws Exception;

        protected void log(String msg) {
            System.out.println("[" + this.threadnum + "] " + msg);
        }

        public void verifyStateOnShutdown() {
        }
    }
}

