/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.source;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.spi.ServiceTestBase;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.web.DummyCommitterUserMappingManager;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RepositorySourceTest
extends ServiceTestBase {
    private ContentManager contentManager = null;
    private Source source = null;
    private RepositorySource repoSource = null;

    @Before
    public void setUp() throws Exception {
        this.source = this.sourceFactory.getSource("svn", (Principal)this.txTemplate.getEffectiveUserLogin());
        this.contentManager = (ContentManager)SpringContext.getComponentByClass(ContentManager.class);
        this.repoSource = new RepositorySource(this.source.getName(), this.txTemplate.getEffectivePrincipal(), this.contentManager, (NotificationManager)Mockito.mock(NotificationManager.class), this.commentManager, (EncodedContentProvider)Mockito.mock(EncodedContentProvider.class), (CommitterUserMappingManager)new DummyCommitterUserMappingManager());
    }

    @Test
    public void testIsOnAncestryLine() throws Exception {
        CrucibleRevision r9 = this.contentManager.getCrucibleRevision(this.source, "iterativeReviews/file1", "9");
        CrucibleRevision r10 = this.contentManager.getCrucibleRevision(this.source, "iterativeReviews/file1", "10");
        CrucibleRevision r13 = this.contentManager.getCrucibleRevision(this.source, "branches/iterativeReviewsBranch/file1", "13");
        CrucibleRevision r14 = this.contentManager.getCrucibleRevision(this.source, "branches/iterativeReviewsBranch/file1", "14");
        ArrayList<CrucibleRevision> existingRevisions = new ArrayList<CrucibleRevision>();
        existingRevisions.add(r10);
        existingRevisions.add(r13);
        boolean result = this.repoSource.isOnAncestryLine(existingRevisions, null, r14);
        Assert.assertTrue((boolean)result);
        result = this.repoSource.isOnAncestryLine(existingRevisions, null, r9);
        Assert.assertTrue((boolean)result);
        existingRevisions.clear();
        existingRevisions.add(r9);
        existingRevisions.add(r10);
        result = this.repoSource.isOnAncestryLine(existingRevisions, null, r14);
        Assert.assertFalse((boolean)result);
        result = this.repoSource.isOnAncestryLine(existingRevisions, r13, r14);
        Assert.assertFalse((boolean)result);
    }
}

