/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.managers;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.revision.managers.DefaultEncodedContentProvider;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.upload.UploadManager;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.util.Disposer;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultEncodedContentProviderTest {
    DefaultEncodedContentProvider encodedContentProvider = new DefaultEncodedContentProvider();
    @Mock
    private DefaultEncodedContentProvider.ContentWriter contentWriter;
    @Mock
    private Source source;
    @Mock
    private IndexedLineReader indexedLineReader;
    @Mock
    private UploadManager uploadManager;
    private Disposer disposer = new Disposer();

    @Test
    public void testGetCachedEncodedFileContents() throws Exception {
        CrucibleRevision cruRev = new CrucibleRevision();
        cruRev.setId(Integer.valueOf(1));
        Mockito.when((Object)this.source.getFileContents(cruRev, null, this.disposer)).thenReturn((Object)this.indexedLineReader);
        Mockito.when((Object)this.indexedLineReader.readline()).thenReturn((Object)"hi\n").thenReturn(null);
        IndexedLineReader cachedLineReader = this.encodedContentProvider.getCachedEncodedFileContents(cruRev, this.source, this.disposer);
        Assert.assertEquals((String)"hi\n", (String)cachedLineReader.readline());
        Assert.assertEquals(null, (String)cachedLineReader.readline());
        Mockito.when((Object)this.source.getFileContents(cruRev, null, this.disposer)).thenThrow(new Throwable[]{new RuntimeException("should not be called again!")});
        cachedLineReader = this.encodedContentProvider.getCachedEncodedFileContents(cruRev, this.source, this.disposer);
        Assert.assertEquals((String)"hi\n", (String)cachedLineReader.readline());
        Assert.assertEquals(null, (String)cachedLineReader.readline());
    }

    @Test
    public void testGetContentFromUploadItem() throws Exception {
        final File testFile = FisheyeTestUtil.createTempFile("testFile");
        Files.write((CharSequence)"test file content\nyay\n", (File)testFile, (Charset)Charsets.ISO_8859_1);
        UploadItem uploadItem = new UploadItem(){

            public File getItemFile() {
                return testFile;
            }
        };
        uploadItem.setId(Integer.valueOf(6));
        uploadItem.setCharset(Charsets.ISO_8859_1.name());
        IndexedLineReader cachedLineReader = this.encodedContentProvider.getContent(uploadItem, this.disposer);
        Assert.assertEquals((String)"test file content\n", (String)cachedLineReader.readline());
        Assert.assertEquals((String)"yay\n", (String)cachedLineReader.readline());
        Assert.assertEquals(null, (String)cachedLineReader.readline());
        testFile.delete();
        cachedLineReader = this.encodedContentProvider.getContent(uploadItem, this.disposer);
        Assert.assertEquals((String)"test file content\n", (String)cachedLineReader.readline());
        Assert.assertEquals((String)"yay\n", (String)cachedLineReader.readline());
        Assert.assertEquals(null, (String)cachedLineReader.readline());
    }

    @Test
    public void testCreateAndPopulateFileWhenAbsent() throws Exception {
        File testFile = new File(FisheyeTestUtil.createTempDir("encodedcontenttest"), "foo");
        this.encodedContentProvider.createAndPopulateFileIfAbsent(testFile, this.contentWriter);
        ((DefaultEncodedContentProvider.ContentWriter)Mockito.verify((Object)this.contentWriter)).writeContent(testFile);
    }

    @Test
    public void testCreateAndPopulateFileWhenPresent() throws Exception {
        File testFile = new File(FisheyeTestUtil.createTempDir("encodedcontenttest"), "foo");
        testFile.createNewFile();
        this.encodedContentProvider.createAndPopulateFileIfAbsent(testFile, this.contentWriter);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.contentWriter});
    }

    @Test
    public void testCreateAndPopulateFileIfPresentConcurrency() throws Exception {
        File testFile = new File(FisheyeTestUtil.createTempDir("encodedcontenttest"), "foo");
        AtomicLong callsToWriteContent = new AtomicLong(0L);
        AtomicLong completeWritesOfContent = new AtomicLong(0L);
        AtomicLong completeCallsToCreateAndPopulate = new AtomicLong(0L);
        DefaultEncodedContentProvider.ContentWriter slowCountingContentWriter = cacheFile -> {
            Assert.assertEquals((String)"should only get called once", (long)1L, (long)callsToWriteContent.incrementAndGet());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread was interrupted", e);
            }
            Assert.assertEquals((String)"should only complete once", (long)1L, (long)completeWritesOfContent.incrementAndGet());
        };
        ArrayList createAndPopulateCalls = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            createAndPopulateCalls.add(() -> {
                this.encodedContentProvider.createAndPopulateFileIfAbsent(testFile, slowCountingContentWriter);
                Assert.assertEquals((String)"expected to only call writeContent once", (long)1L, (long)callsToWriteContent.longValue());
                Assert.assertEquals((String)"should always have completely written content exactly once by return", (long)1L, (long)completeWritesOfContent.get());
                completeCallsToCreateAndPopulate.incrementAndGet();
                return null;
            });
        }
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        List futures = executorService.invokeAll(createAndPopulateCalls);
        for (Future future : futures) {
            future.get();
        }
        Assert.assertEquals((String)"expected to only call writeContent once", (long)1L, (long)callsToWriteContent.longValue());
        Assert.assertEquals((String)"that call should complete once", (long)1L, (long)completeWritesOfContent.get());
        Assert.assertEquals((String)"should be 20 complete calls to createAndGet", (long)20L, (long)completeCallsToCreateAndPopulate.get());
    }
}

