/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.managers;

import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.revision.managers.DefaultContentManager;
import com.cenqua.crucible.revision.managers.EncodedContentProvider;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.util.Disposer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultContentManagerTest {
    @Mock
    private Source source;
    @Mock
    private Project project;
    @Mock
    private CrucibleRevision crucibleRevision;
    @Mock
    private Disposer disposer;
    @Mock
    private UploadItem uploadItem;
    @Mock
    private IndexedLineReader indexedLineReader;
    @Mock
    private EncodedContentProvider encodedContentProvider;
    @Mock
    private PatchManager patchManager;
    private DefaultContentManager contentManager;

    @Before
    public void setUp() throws Exception {
        this.contentManager = new DefaultContentManager(null, null, null, null, this.encodedContentProvider, (TxTemplate)new DummyTxTemplate(), (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), this.patchManager);
    }

    @Test
    public void testGetContentsDeletion() throws Exception {
        Mockito.when((Object)this.crucibleRevision.isDeletion()).thenReturn((Object)Boolean.TRUE);
        IndexedLineReader contents = this.contentManager.getContents(this.source, this.project, this.crucibleRevision, this.disposer, null);
        Assert.assertThat((String)"empty content returned - zero length", (Object)contents.length(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"empty content returned - zero lines", (Object)contents.getTotalLines(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testGetContentsStored() throws Exception {
        Mockito.when((Object)this.crucibleRevision.isStored()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.crucibleRevision.getUploadItem()).thenReturn((Object)this.uploadItem);
        Mockito.when((Object)this.encodedContentProvider.getContent(this.uploadItem, this.disposer)).thenReturn((Object)this.indexedLineReader);
        IndexedLineReader contents = this.contentManager.getContents(this.source, this.project, this.crucibleRevision, this.disposer, null);
        Assert.assertThat((String)"indexedLineReader from upload item returned", (Object)contents, (Matcher)Matchers.is((Object)this.indexedLineReader));
    }

    @Test
    public void testGetContentsFromSource() throws Exception {
        Mockito.when((Object)this.source.isAvailable()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.source.getCachedEncodedFileContents(this.crucibleRevision, this.disposer)).thenReturn((Object)this.indexedLineReader);
        IndexedLineReader contents = this.contentManager.getContents(this.source, this.project, this.crucibleRevision, this.disposer, null);
        Assert.assertThat((String)"indexedLineReader from source returned", (Object)contents, (Matcher)Matchers.is((Object)this.indexedLineReader));
    }
}

