/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.managers;

import com.atlassian.crucible.scm.RevisionKey;
import com.atlassian.fugue.Option;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.StoredPath;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.managers.CrucibleRevisionCreator;
import com.cenqua.crucible.revision.source.DisplayRevisionMapper;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.Session;
import org.hibernate.stat.EntityStatistics;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CrucibleRevisionCreatorTest
extends UseTestSpringContextTestCase {
    private static final List<RevInfoKey> REVS = ImmutableList.of((Object)new RevInfoKey(new RevisionKey("/foobar/README.txt", "1234")), (Object)new RevInfoKey(new RevisionKey("/java.java", "1234")), (Object)new RevInfoKey(new RevisionKey("/file", "12")));
    private static final DisplayRevisionMapper IDENTITY_MAPPER = revision -> revision;
    private static final Option<Function<RevInfoKey, FileRevisionInfo>> NO_FRI_FUNCTION = Option.none();
    private ModelUtils modelUtils;

    @Before
    public void setUp() throws Exception {
        this.modelUtils = new ModelUtils();
        this.modelUtils.createBlankDB();
    }

    @Test
    public void testCreateRevisionsInSeparateTransaction_shouldCreateRevisionsOnce() throws Exception {
        List firstRunIds = CrucibleRevisionCreator.createRevisionsInSeparateTransaction((String)"source", (Set)ImmutableSet.copyOf(REVS), (DisplayRevisionMapper)IDENTITY_MAPPER, (Date)new Date(), NO_FRI_FUNCTION);
        List secondRunIds = CrucibleRevisionCreator.createRevisionsInSeparateTransaction((String)"source", (Set)ImmutableSet.copyOf(REVS), (DisplayRevisionMapper)IDENTITY_MAPPER, (Date)new Date(), NO_FRI_FUNCTION);
        Assert.assertThat((Object)firstRunIds, (Matcher)Matchers.contains((Object[])new Integer[]{1, 2, 3}));
        Assert.assertThat((Object)secondRunIds, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void testFindStoredPath_shouldNotFetchPathsOneByOne() throws Exception {
        CrucibleRevisionCreator.createRevisionsInSeparateTransaction((String)"source", (Set)ImmutableSet.copyOf(REVS), (DisplayRevisionMapper)IDENTITY_MAPPER, (Date)new Date(), NO_FRI_FUNCTION);
        Session session = HibernateUtil.currentSession();
        session.getSessionFactory().getStatistics().clear();
        session.getSessionFactory().getCache().evictEntityRegions();
        Map storedPaths = CrucibleRevisionCreator.findStoredPaths((Session)session, (List)Lists.transform(REVS, (Function)new Function<RevInfoKey, String>(){

            public String apply(RevInfoKey input) {
                return input.getPathAsString();
            }
        }));
        EntityStatistics storedPathStats = session.getSessionFactory().getStatistics().getEntityStatistics(StoredPath.class.getName());
        Assert.assertThat((String)"Shouldn't fetch stored paths one-by-one", (Object)storedPathStats.getFetchCount(), (Matcher)Matchers.equalTo((Object)0L));
        Assert.assertThat((String)"Should see stored paths as loaded", (Object)storedPathStats.getLoadCount(), (Matcher)Matchers.equalTo((Object)3L));
        Assert.assertThat((String)"Should actually return the path", storedPaths.entrySet(), (Matcher)Matchers.hasSize((int)REVS.size()));
    }

    @Test
    public void testCreateRevisionsInSeparateTransaction_shouldUseExistingPaths() throws Exception {
        Session session = HibernateUtil.currentSession();
        HibernateUtil.beginTransaction();
        StoredPath existingPath = CrucibleRevisionCreator.createPathIfNotFound((Session)session, (String)REVS.get(2).getPathAsString());
        HibernateUtil.commitTransaction();
        HibernateUtil.closeSession();
        CrucibleRevisionCreator.createRevisionsInSeparateTransaction((String)"source", (Set)ImmutableSet.copyOf(REVS), (DisplayRevisionMapper)IDENTITY_MAPPER, (Date)new Date(), NO_FRI_FUNCTION);
        List<StoredPath> paths = this.getStoredPaths();
        Assert.assertThat(paths, (Matcher)Matchers.hasSize((int)REVS.size()));
        Assert.assertThat((Object)Lists.transform(paths, (Function)new Function<StoredPath, Integer>(){

            public Integer apply(StoredPath input) {
                return input.getId();
            }
        }), (Matcher)Matchers.hasItem((Object)existingPath.getId()));
    }

    private List<StoredPath> getStoredPaths() {
        Session session = HibernateUtil.currentSession();
        List paths = session.createQuery("from StoredPath").list();
        HibernateUtil.closeSession();
        return paths;
    }

    @Test
    public void testCreateRevisionsInSeparateTransaction_shouldInsertPathsOnlyOnce() throws Exception {
        CrucibleRevisionCreator.createRevisionsInSeparateTransaction((String)"source", (Set)ImmutableSet.of((Object)new RevInfoKey(new RevisionKey("file", "1")), (Object)new RevInfoKey(new RevisionKey("file", "2")), (Object)new RevInfoKey(new RevisionKey("file", "3"))), (DisplayRevisionMapper)IDENTITY_MAPPER, (Date)new Date(), NO_FRI_FUNCTION);
        List<StoredPath> storedPaths = this.getStoredPaths();
        Assert.assertThat(storedPaths, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)storedPaths.get(0).getPath(), (Matcher)Matchers.equalTo((Object)"file"));
    }

    @Test
    public void testFindStoredPaths() throws Exception {
        Session session = HibernateUtil.currentSession();
        HibernateUtil.beginTransaction();
        CrucibleRevisionCreator.createPathIfNotFound((Session)session, (String)REVS.get(2).getPathAsString());
        CrucibleRevisionCreator.createPathIfNotFound((Session)session, (String)REVS.get(0).getPathAsString());
        HibernateUtil.commitTransaction();
        Map storedPaths = CrucibleRevisionCreator.findStoredPaths((Session)session, (List)Lists.transform(REVS, (Function)new Function<RevInfoKey, String>(){

            public String apply(@Nullable RevInfoKey input) {
                return input.getPathAsString();
            }
        }));
        Assert.assertThat((Object)storedPaths, (Matcher)Matchers.allOf((Matcher)Matchers.hasKey((Object)REVS.get(0).getPathAsString()), (Matcher)Matchers.hasKey((Object)REVS.get(2).getPathAsString())));
        Assert.assertThat(storedPaths.entrySet(), (Matcher)Matchers.hasSize((int)2));
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.closeSession();
        this.modelUtils.destroyDB();
    }
}

