/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.crucible.revision.diff.patchDiff.PatchDiffListener;
import com.cenqua.crucible.revision.diff.unified.RevisionHeader;
import com.cenqua.crucible.revision.diff.unified.UnifiedDiffListener;
import com.cenqua.crucible.revision.diff.unified.UnifiedDiffParser;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnifiedDiffParserTest {
    private UnifiedDiffParser udp;
    private File testPatchDir = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/cru-testfiles/diff/unified");

    @Before
    public void setUp() throws Exception {
        this.udp = new UnifiedDiffParser();
    }

    private ReaderLineReader getLineReader(File file) throws Exception {
        return new ReaderLineReader((Reader)new BufferedReader(new FileReader(file)));
    }

    private void compareProcess(String patch, String comparison, int index, boolean processAllRevisions) throws Exception {
        File patchFile = new File(this.testPatchDir, patch);
        DiffListener dl = new DiffListener();
        ReaderLineReader lr = this.getLineReader(patchFile);
        if (processAllRevisions) {
            this.udp.processAllRevisions(lr, (UnifiedDiffListener)dl);
        } else {
            this.udp.processRevision(lr, (UnifiedDiffListener)dl, index);
        }
        System.out.println(dl.dump);
        File compare = new File(this.testPatchDir, comparison);
        String cmp = IOHelper.copyFileToString((Charset)Charsets.UTF_8, (File)compare);
        cmp = cmp.replaceAll("\r\n", "\n");
        dl.dump = dl.dump.replaceAll("\r\n", "\n");
        Assert.assertEquals((String)"Processed revision file doesn't match", (Object)cmp, (Object)dl.dump);
    }

    private void compareProcessAllRevisions(String patch, String comparison) throws Exception {
        this.compareProcess(patch, comparison, 0, true);
    }

    private void compareProcessRevision(String patch, String comparison, int index) throws Exception {
        this.compareProcess(patch, comparison, index, false);
    }

    @Test
    public void testProcessP4DCU() throws Exception {
        this.compareProcessRevision("p4diff-dcu.txt", "p4diff-dcu.cmp", 1);
    }

    @Test
    public void testProcessP4ZTag0() throws Exception {
        this.compareProcessRevision("p4diff-ztag.txt", "p4diff-ztag.cmp", 0);
    }

    @Test
    public void testProcessP4ZTag1() throws Exception {
        this.compareProcessRevision("p4diff-ztag.txt", "p4diff-ztag-1.cmp", 1);
    }

    @Test
    public void testProcessP4ZTagWithBinaries() throws Exception {
        this.compareProcessAllRevisions("p4diff-ztag-withbinary.txt", "p4diff-ztag-withbinary.cmp");
    }

    @Test
    public void testProcessP4ZTagWithBinariesLast() throws Exception {
        this.compareProcessAllRevisions("p4diff-ztag-withbinary-last.txt", "p4diff-ztag-withbinary-last.cmp");
    }

    @Test
    public void testProcessP4MixedFromCruciblePy() throws Exception {
        this.compareProcessAllRevisions("p4diff-mixed-from-crucible-py.txt", "p4diff-mixed-from-crucible-py.cmp");
    }

    @Test
    public void testProcessP4DCU_empty() throws Exception {
        this.compareProcessRevision("p4diff-dcu.txt", "p4diff-dcu-empty.cmp", 0);
    }

    @Test
    public void testProcessP4() throws Exception {
        this.compareProcessRevision("p4diff.txt", "p4diffBaseRecognizer.cmp", 0);
    }

    @Test
    public void testProcessSvn() throws Exception {
        this.compareProcessRevision("svndiff.txt", "svndiffEDiff.cmp", 1);
    }

    @Test
    public void testProcessSvnWithPropertyChanges() throws Exception {
        this.compareProcessRevision("svndiff-property-changes.txt", "svndiffPropertyChanges.cmp", 0);
    }

    @Test
    public void testProcessCvs() throws Exception {
        this.compareProcessRevision("cvsdiff.txt", "cvsdiffAdded.cmp", 0);
    }

    @Test
    public void testProcessHg() throws Exception {
        this.compareProcessRevision("hgdiff.txt", "hgdiffInlineComment.cmp", 1);
    }

    @Test
    public void testProcessGitPrefixedList() throws Exception {
        this.compareProcessRevision("gitdiff-prefixed.txt", "gitdiff-prefixed.cmp", 0);
    }

    @Test
    public void testProcessGitList() throws Exception {
        this.compareProcessRevision("gitdiff-no-prefix.txt", "gitdiff-no-prefix.cmp", 0);
    }

    @Test
    public void testProcessGitWithBinaries() throws Exception {
        this.compareProcessAllRevisions("gitdiff-withbinaries.txt", "gitdiff-withbinaries.cmp");
    }

    @Test
    public void testProcessMultipatch4Files() throws Exception {
        this.compareProcessAllRevisions("unified-multipatch-4-files.txt", "unified-multipatch-4-files.cmp");
    }

    @Test
    public void testProcessMultipatch7Files() throws Exception {
        this.compareProcessAllRevisions("unified-multipatch-7-files.txt", "unified-multipatch-7-files.cmp");
    }

    @Test
    public void testPatchDiffListener() {
        PatchDiffListener pdl = new PatchDiffListener();
        pdl.section(1, 2, 1, 2);
        pdl.contextLine("context");
        pdl.contextLine("more context");
        PatchDiffListener.Sect s = (PatchDiffListener.Sect)pdl.getSects().get(0);
        Assert.assertEquals((long)0L, (long)s.getFromLineOffset(0));
        Assert.assertEquals((long)7L, (long)s.getFromLineOffset(1));
        Assert.assertEquals((long)19L, (long)s.getFromLineOffset(2));
    }

    @Test
    public void testLenientPatch() throws Exception {
        try {
            AppConfig.Hacks.LENIENT_PATCHES = true;
            this.compareProcessRevision("sectionless-patch-in-context.txt", "sectionless-patch-in-context.cmp", 1);
        }
        finally {
            AppConfig.Hacks.LENIENT_PATCHES = false;
        }
    }

    @Test
    public void testPatchCRUC856() throws Exception {
        this.compareProcessRevision("CRUC-856.patch", "CRUC-856.cmp", 0);
    }

    class DiffListener
    implements UnifiedDiffListener {
        public String dump = "";
        private String fromPath;
        private String toPath;

        DiffListener() {
        }

        public void fromHeader(RevisionHeader header) {
            this.fromPath = header.getPath();
            this.fromTimeStamp(header.getRevision());
        }

        public void toHeader(RevisionHeader header) {
            this.toPath = header.getPath();
            this.toTimeStamp(header.getRevision());
        }

        public void section(int fromLine, int numFromLines, int toLine, int numToLines) {
            this.dump = this.dump + "@@ -" + fromLine + "," + numFromLines + " +" + toLine + "," + numToLines + " @@\n";
        }

        public void fromTimeStamp(String date) {
            this.dump = this.dump + "--- " + this.fromPath + "\t" + date + "\n";
        }

        public void toTimeStamp(String date) {
            this.dump = this.dump + "+++ " + this.toPath + "\t" + date + "\n";
        }

        public void addLine(String line) {
            this.dump = this.dump + "+" + line;
        }

        public void contextLine(String line) {
            this.dump = this.dump + " " + line;
        }

        public void removeLine(String line) {
            this.dump = this.dump + "-" + line;
        }

        public void eof() {
        }
    }
}

