/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.crucible.revision.diff.unified.GitDiffHeaderParser;
import com.cenqua.crucible.revision.diff.unified.RevisionHeader;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.util.Pair;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.io.Files;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import junit.framework.Assert;
import org.hamcrest.Description;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;

public class GitDiffHeaderParserTest {
    GitDiffHeaderParser parser;
    ReaderLineReader lr;
    File patchFile;
    private File testPatchDir = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/cru-testfiles/diff/unified");

    @Test
    public void testDeletionParser() throws Exception {
        this.parser = new GitDiffHeaderParser(false);
        this.getPatchFile("gitdiff-deletion-no-prefix.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("a/foobar", "b13ccef", false), (Object)new RevisionHeader("/dev/null", "0000000", true));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testDeletionPrefixedParser() throws Exception {
        this.parser = new GitDiffHeaderParser(true);
        this.getPatchFile("gitdiff-deletion-prefixed.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("a/foobar", "b13ccef", false), (Object)new RevisionHeader("/dev/null", "0000000", true));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testModificationParser() throws Exception {
        this.parser = new GitDiffHeaderParser(false);
        this.getPatchFile("gitdiff-modification-no-prefix.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("a/torename", "db0479c", false), (Object)new RevisionHeader("a/torename", "a918bc9", false));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testModificationPrefixedParser() throws Exception {
        this.parser = new GitDiffHeaderParser(true);
        this.getPatchFile("gitdiff-modification-prefixed.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("a/torename", "db0479c", false), (Object)new RevisionHeader("a/torename", "a918bc9", false));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testABFoldersMoveParser() throws Exception {
        this.parser = new GitDiffHeaderParser(true);
        this.getPatchFile("gitdiff-ab-folders-move-no-prefix.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("a/foobar", "b13ccef", false), (Object)new RevisionHeader("b/foobar", "7d3feb7", false));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testABFoldersMovePrefixedParser() throws Exception {
        this.parser = new GitDiffHeaderParser(true);
        this.getPatchFile("gitdiff-ab-folders-move-prefixed.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("a/foobar", "b13ccef", false), (Object)new RevisionHeader("b/foobar", "7d3feb7", false));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testDiffInDiffParser() throws Exception {
        this.parser = new GitDiffHeaderParser(false);
        this.getPatchFile("gitdiff-in-diff-no-prefix.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("/dev/null", "0000000", true), (Object)new RevisionHeader("0001-renamed.patch", "b1de924", false));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testDiffInDiffPrefixedParser() throws Exception {
        this.parser = new GitDiffHeaderParser(true);
        this.getPatchFile("gitdiff-in-diff-prefixed.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("/dev/null", "0000000", true), (Object)new RevisionHeader("0001-renamed.patch", "b1de924", false));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testQuotedDiffParser() throws Exception {
        this.parser = new GitDiffHeaderParser(false);
        this.getPatchFile("gitdiff-quoted-no-prefix.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("a/backs\\ashed", "c67de9c", false), (Object)new RevisionHeader("a/backs\\ashed", "17f4a9b", false));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testQuotedDiffPrefixedParser() throws Exception {
        this.parser = new GitDiffHeaderParser(true);
        this.getPatchFile("gitdiff-quoted-prefixed.txt");
        Pair expected = Pair.newInstance((Object)new RevisionHeader("a/backs\\ashed", "c67de9c", false), (Object)new RevisionHeader("a/backs\\ashed", "17f4a9b", false));
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNotNull((Object)headers);
        MatcherAssert.assertThat((Object)headers, this.getHeaderMatcher((Pair<RevisionHeader, RevisionHeader>)expected));
    }

    @Test
    public void testNoRevisionInfoPrefixedParser() throws Exception {
        this.parser = new GitDiffHeaderParser(true);
        this.getPatchFile("gitdiff-without-rev-prefixed.txt");
        Pair headers = this.parser.parseHeaders(this.lr.readLine(), this.lr);
        Assert.assertNull((String)"Headers should be null", (Object)headers);
    }

    private void getPatchFile(String filename) throws Exception {
        this.patchFile = new File(this.testPatchDir, filename);
        this.lr = new ReaderLineReader((Reader)Files.newReader((File)this.patchFile, (Charset)Charsets.UTF_8));
    }

    protected TypeSafeMatcher<Pair<RevisionHeader, RevisionHeader>> getHeaderMatcher(final Pair<RevisionHeader, RevisionHeader> expected) {
        return new TypeSafeMatcher<Pair<RevisionHeader, RevisionHeader>>(){

            protected boolean matchesSafely(Pair<RevisionHeader, RevisionHeader> item) {
                return this.compareHeaders((RevisionHeader)expected.getFirst(), (RevisionHeader)item.getFirst()) && this.compareHeaders((RevisionHeader)expected.getSecond(), (RevisionHeader)item.getSecond());
            }

            public void describeTo(Description description) {
                description.appendText(expected.getFirst() + ", " + expected.getSecond());
            }

            private boolean compareHeaders(RevisionHeader expected2, RevisionHeader actual) {
                return Objects.equal((Object)expected2.getPath(), (Object)actual.getPath()) && Objects.equal((Object)expected2.getRevision(), (Object)actual.getRevision()) && Objects.equal((Object)expected2.isNullRev(), (Object)actual.isNullRev());
            }
        };
    }
}

