/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.crucible.revision.diff.unified.DiffMatcher;
import com.cenqua.crucible.revision.diff.unified.RevisionHeader;
import com.cenqua.crucible.revision.diff.unified.SectionHeader;
import junit.framework.Assert;
import org.junit.Test;

public final class DiffMatcherTest {
    private final String fishEyeSvnHeader = "--- trunk/src/content/WEB-INF/jsp/crucible/admin/project/projectdelete.jsp\t(.../projectdelete.jsp)\t(revision 19812)";
    private final String svnHeader = "--- src/content/WEB-INF/tags/review/diffLine.tag\t(revision 20398)";
    private final String svnHeaderTimestamp = "+++ src/content/WEB-INF/tags/review/diffLine.tag\tThu Sep 25 16:55:04 EST 2008";
    private final String svnHeaderSpaces = "--- Filename With Spaces.txt\t(revision 24081)";
    private final String svnInvalidHeader = "---\r\n";

    @Test
    public void testMatchFishEyeSvnHeader() {
        RevisionHeader header = DiffMatcher.matchHeader((boolean)true, (String)"--- trunk/src/content/WEB-INF/jsp/crucible/admin/project/projectdelete.jsp\t(.../projectdelete.jsp)\t(revision 19812)");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((String)"trunk/src/content/WEB-INF/jsp/crucible/admin/project/projectdelete.jsp", (String)header.getPath());
        Assert.assertEquals((String)"19812", (String)header.getRevision());
    }

    @Test
    public void testSvnHeader() {
        RevisionHeader header = DiffMatcher.matchHeader((boolean)true, (String)"--- src/content/WEB-INF/tags/review/diffLine.tag\t(revision 20398)");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((String)"src/content/WEB-INF/tags/review/diffLine.tag", (String)header.getPath());
        Assert.assertEquals((String)"20398", (String)header.getRevision());
    }

    @Test
    public void testSvnHeaderTimestamp() {
        RevisionHeader header = DiffMatcher.matchHeader((boolean)false, (String)"+++ src/content/WEB-INF/tags/review/diffLine.tag\tThu Sep 25 16:55:04 EST 2008");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((String)"src/content/WEB-INF/tags/review/diffLine.tag", (String)header.getPath());
        Assert.assertEquals((String)"Thu Sep 25 16:55:04 EST 2008", (String)header.getRevision());
    }

    @Test
    public void testSvnHeaderFilenameWithSpaces() {
        RevisionHeader header = DiffMatcher.matchHeader((boolean)true, (String)"--- Filename With Spaces.txt\t(revision 24081)");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((String)"Filename With Spaces.txt", (String)header.getPath());
        Assert.assertEquals((String)"24081", (String)header.getRevision());
    }

    @Test
    public void testSvnInvalidHeader() {
        RevisionHeader header = DiffMatcher.matchHeader((boolean)true, (String)"---\r\n");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testMatchSection() throws Exception {
        this.assertSection(DiffMatcher.matchSection((String)"@@ -2 +1 @@"), 2, 1, 1, 1);
        this.assertSection(DiffMatcher.matchSection((String)"@@ -1,5 +3 @@"), 1, 5, 3, 1);
        this.assertSection(DiffMatcher.matchSection((String)"@@ -1 +10,5 @@"), 1, 1, 10, 5);
        this.assertSection(DiffMatcher.matchSection((String)"@@ -1,72 +1,27 @@"), 1, 72, 1, 27);
    }

    public void assertSection(SectionHeader section, Integer fromStart, Integer fromLength, Integer toStart, Integer toLength) {
        Assert.assertEquals((Object)fromStart, (Object)section.getFromLine());
        Assert.assertEquals((Object)fromLength, (Object)section.getNumberFromLines());
        Assert.assertEquals((Object)toStart, (Object)section.getToLine());
        Assert.assertEquals((Object)toLength, (Object)section.getNumberToLines());
    }
}

