/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.cenqua.crucible.revision.diff.unified.DiffHeader;
import com.cenqua.crucible.revision.diff.unified.DiffHeaderParser;
import com.cenqua.fisheye.io.ReaderLineReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class DiffHeaderParserTest {
    @Rule
    public CaptureLog4jLogsRule captureLog4jLogsRule = new CaptureLog4jLogsRule();

    @Test
    public void P4NewShouldReturnLinesOnIncompleteHeaders() throws Exception {
        DiffHeaderParser parser = DiffHeaderParser.P4NEW;
        List<String> patchLines = Arrays.asList("... depotFile //depot/x.txt", "... clientFile /Users/tdavies/tmp/p4work/x.txt", "... rev 3", "some rubbish");
        ReaderLineReader reader = new ReaderLineReader((Reader)new StringReader(patchLines.stream().skip(1L).collect(Collectors.joining("\n"))));
        DiffHeader diffHeader = parser.parseHeaders(patchLines.get(0), reader);
        Assert.assertThat((Object)diffHeader, (Matcher)Matchers.nullValue());
        Assert.assertThat(this.captureLog4jLogsRule.getEvents(), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.WARN), (Matcher)new CaptureLog4jLogsRule.LogWithMessage("Incomplete match for Perforce diff header. Found: ... depotFile //depot/x.txt, ... clientFile /Users/tdavies/tmp/p4work/x.txt, ... rev 3"))));
        for (String patchLine : patchLines) {
            Assert.assertThat((Object)reader.readLine(), (Matcher)Matchers.equalTo((Object)patchLine));
        }
    }
}

