/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.diff.unified.DiffDirectory;
import com.cenqua.crucible.revision.diff.unified.HashMatchType;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DiffDirectoryListenerTest {
    private static final File PATCH_DIR = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/cru-testfiles/diff/unified");

    private List<Matcher<? super DiffRevisionsInfo>> getFilesMatchers(List<DiffRevisionsInfo> testFiles) {
        return Lists.transform(testFiles, (Function)new Function<DiffRevisionsInfo, Matcher<? super DiffRevisionsInfo>>(){

            public Matcher<? super DiffRevisionsInfo> apply(@Nullable DiffRevisionsInfo input) {
                return new DiffRevisionInfoMatcher(input);
            }
        });
    }

    private List<DiffRevisionsInfo> getDiffRevisionsFromPatch(File file) throws IOException, PatchException {
        junit.framework.Assert.assertTrue((String)"Test file doesn't exist", (boolean)file.exists());
        return DiffDirectory.list((File)file, (Charset)Charsets.UTF_8);
    }

    @After
    public void tearDown() {
        AppConfig.Hacks.LENIENT_PATCHES = false;
    }

    @Test
    public void testProcessGitFormatPatch() throws Exception {
        File patch = new File(PATCH_DIR, "gitdiff-format-patch.txt");
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        DiffRevisionsInfo dri = this.createDRI("a/torename", "d845796", 1, 0, 0);
        dri.setDeleted(true);
        testFiles.add(dri);
        testFiles.add(this.createDRI("b/tocopy", null, 0, 1, 1));
        testFiles.add(this.createDRI("b/torename", null, 0, 1, 2));
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test
    public void testProcessGitPrefixedList() throws Exception {
        File patch = new File(PATCH_DIR, "gitdiff-prefixed.txt");
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        testFiles.add(this.createDRI("dir/file", "8ea8d73", 22, 21, 0));
        testFiles.add(this.createDRI("dir/file2", null, 0, 2, 1));
        DiffRevisionsInfo dri = this.createDRI("masterFile", "59d0017", 3, 0, 2);
        dri.setDeleted(true);
        testFiles.add(dri);
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test
    public void testProcessGitList() throws Exception {
        File patch = new File(PATCH_DIR, "gitdiff-no-prefix.txt");
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        testFiles.add(this.createDRI("dir/file", "8ea8d73", 22, 21, 0));
        testFiles.add(this.createDRI("dir/file2", null, 0, 2, 1));
        DiffRevisionsInfo dri = this.createDRI("masterFile", "59d0017", 3, 0, 2);
        dri.setDeleted(true);
        testFiles.add(dri);
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test
    public void testProcessP4List() throws Exception {
        File patch = new File(PATCH_DIR, "gp4diff.txt");
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        testFiles.add(this.createDRI("file3.txt", null, 0, 1, 0));
        testFiles.add(this.createDRI("file1.txt", "2007-08-03 14:39:28.000000000 +1000", 1, 2, 1));
        DiffRevisionsInfo dri = this.createDRI("file2.txt", "2007-08-03 14:39:28.000000000 +1000", 1, 0, 2);
        dri.setDeleted(true);
        testFiles.add(dri);
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test
    public void testProcessP4ListDCU() throws Exception {
        File patch = new File(PATCH_DIR, "p4diff-dcu.txt");
        ImmutableList testFiles = ImmutableList.of((Object)this.createDRI("//mainline/rel1/TemplateRenderer.java", "3", 0, 0, 0), (Object)this.createDRI("//depot/test/com/perforce/api/diffTest.txt", "1", 3, 9, 1));
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers((List<DiffRevisionsInfo>)testFiles)));
    }

    @Test
    public void testProcessSvnList() throws Exception {
        File patch = new File(PATCH_DIR, "svndiff.txt");
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        testFiles.add(this.createDRI("src/java/com/cenqua/fisheye/diff/LinePair.java", null, 0, 7, 0));
        testFiles.add(this.createDRI("src/java/com/cenqua/fisheye/diff/EDiff.java", "11741", 12, 17, 1));
        testFiles.add(this.createDRI("src/crucible/com/cenqua/crucible/filters/SourceException.java", "11741", 12, 0, 2));
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test
    public void testProcessSvnPropertyChangesList() throws Exception {
        File patch = new File(PATCH_DIR, "svndiff-property-changes.txt");
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        testFiles.add(this.createDRI("123", null, 0, 8, 0));
        testFiles.add(this.createDRI("asd", null, 0, 0, 1));
        testFiles.add(this.createDRI("6758", null, 0, 0, 2));
        testFiles.add(this.createDRI("098", null, 0, 5, 3));
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test(expected=PatchException.class)
    public void testProcessSvnNoPropertyChangesException() throws Exception {
        File patch = new File(PATCH_DIR, "svndiff-no-prop-changes-exception.txt");
        this.getDiffRevisionsFromPatch(patch);
    }

    @Test
    public void testProcessCvsList() throws Exception {
        File patch = new File(PATCH_DIR, "cvsdiff2.txt");
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        testFiles.add(this.createDRI("src/b.txt", "1.2", 1, 2, 0));
        DiffRevisionsInfo dri = this.createDRI("test/added.txt", "26 Jul 2007 05:22:53 -0000\t1.2", 2, 0, 1);
        dri.setDeleted(true);
        testFiles.add(dri);
        testFiles.add(this.createDRI("test/b.txt", "1.5", 2, 5, 2));
        testFiles.add(this.createDRI("test/newfile.txt", null, 0, 1, 3));
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test
    public void testCRUC284() throws Exception {
        File patch = new File(PATCH_DIR, "CRUC-284.patch");
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        DiffRevisionsInfo dri = this.createDRI("plugins/StandardGadgets/src/atlassian-plugin.xml", null, 11, 16, 0);
        testFiles.add(dri);
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test
    public void testAllScmHeaders() throws Exception {
        File patch = new File(PATCH_DIR, "allScms.txt");
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        testFiles.add(this.createDRI("a/src/content/static/2static/script/cru/review/comment/comment-nav.js", "c746c3cc0052", 7, 7, 0));
        testFiles.add(this.createDRI("a/src/content/static/2static/script/cru/review/comment/comment-nav.js", "(no revision)", 7, 7, 1));
        testFiles.add(this.createDRI("modification/mod_file.txt", "b1d99e5", 2, 3, 2));
        testFiles.add(this.createDRI("//depot/test/test.txt", "2", 2, 3, 3));
        testFiles.add(this.createDRI("b.txt", "1.3", 2, 3, 4));
        testFiles.add(this.createDRI("src/java/com/cenqua/fisheye/web/BaseAction.java", "107859", 7, 7, 5));
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test
    public void testLenientHeaders() throws Exception {
        File patch = new File(PATCH_DIR, "sectionless-patch.txt");
        AppConfig.Hacks.LENIENT_PATCHES = true;
        ImmutableList testFiles = ImmutableList.of((Object)this.createDRI("123", null, 0, 8, 0));
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers((List<DiffRevisionsInfo>)testFiles)));
    }

    @Test
    public void testCommitHashFromIdeaPatch() throws Exception {
        File patch = new File(PATCH_DIR, "jqcdiff-idea.txt");
        List<DiffRevisionsInfo> dris = this.getDiffRevisionsFromPatch(patch);
        DiffRevisionsInfo info = dris.get(0);
        junit.framework.Assert.assertEquals((String)("Expected hash match type COMMIT, got " + info.getFromRevisionType()), (Object)HashMatchType.COMMIT, (Object)info.getFromRevisionType());
    }

    @Test
    public void testContentHashFromGitPatch() throws Exception {
        File patch = new File(PATCH_DIR, "jqcdiff-git.txt");
        List<DiffRevisionsInfo> dris = this.getDiffRevisionsFromPatch(patch);
        DiffRevisionsInfo info = dris.get(0);
        junit.framework.Assert.assertEquals((String)("Expected hash match type CONTENT, got " + info.getFromRevisionType()), (Object)HashMatchType.CONTENT, (Object)info.getFromRevisionType());
    }

    @Test
    public void test3DashesInSection() throws Exception {
        File patch = new File(PATCH_DIR, "svndiff-3dashes-in-section.txt");
        DiffRevisionsInfo dri1 = this.createDRI("main/098", "19", 6, 0, 0);
        DiffRevisionsInfo dri2 = this.createDRI("a/foobar", "(no revision)", 2, 0, 1);
        dri2.setDeleted(true);
        ArrayList<DiffRevisionsInfo> testFiles = new ArrayList<DiffRevisionsInfo>();
        testFiles.add(dri1);
        testFiles.add(dri2);
        List<DiffRevisionsInfo> diffRevisionsFromPatch = this.getDiffRevisionsFromPatch(patch);
        Assert.assertThat(diffRevisionsFromPatch, (Matcher)Matchers.contains(this.getFilesMatchers(testFiles)));
    }

    @Test(expected=PatchException.class)
    public void testUnrecognizedDiff() throws Exception {
        File patch = new File(PATCH_DIR, "sectionless-patch.txt");
        this.getDiffRevisionsFromPatch(patch);
    }

    protected DiffRevisionsInfo createDRI(String path, String fromRev, int fromLines, int toLines, int index) {
        DiffRevisionsInfo dri = new DiffRevisionsInfo();
        dri.setPath(new Path((CharSequence)path));
        dri.setFromRevisionName(fromRev);
        dri.setFromLines(fromLines);
        dri.setToLines(toLines);
        dri.setIndex(index);
        return dri;
    }

    private static class DiffRevisionInfoMatcher
    extends TypeSafeMatcher<DiffRevisionsInfo> {
        private final DiffRevisionsInfo input;

        public DiffRevisionInfoMatcher(DiffRevisionsInfo input) {
            this.input = input;
        }

        protected boolean matchesSafely(DiffRevisionsInfo item) {
            return Objects.equal((Object)this.input.getPath(), (Object)item.getPath()) && Objects.equal((Object)this.input.getFromRevisionName(), (Object)item.getFromRevisionName()) && Objects.equal((Object)this.input.getFromLines(), (Object)item.getFromLines()) && Objects.equal((Object)this.input.getToLines(), (Object)item.getToLines()) && Objects.equal((Object)this.input.getIndex(), (Object)item.getIndex()) && Objects.equal((Object)this.input.isDeleted(), (Object)item.isDeleted());
        }

        public void describeTo(Description description) {
            description.appendText("index: " + this.input.getIndex() + "; path: " + this.input.getPath() + "; fromPath: " + this.input.getFromPath() + "; fromRevisionName: " + this.input.getFromRevisionName() + "; fromLines " + this.input.getFromLines() + "; toLines: " + this.input.getToLines() + "; index: " + this.input.getIndex() + "; deleted: " + this.input.isDeleted());
        }
    }
}

