/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff;

import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.StoredPathFactoryTestHelper;
import com.cenqua.crucible.revision.diff.DiffRevisionsInfo;
import com.cenqua.crucible.revision.diff.patchDiff.PatchDiff;
import com.cenqua.crucible.revision.diff.patchDiff.PatchException;
import com.cenqua.crucible.revision.diff.patchDiff.PatchSectionView;
import com.cenqua.crucible.revision.diff.unified.DiffDirectory;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class PatchDiffTest {
    private static final File BASE_DIR = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/cru-testfiles/diff/unified");

    private PatchDiff getPatchDiff(File patchFile) throws IOException, PatchException {
        MockPatch p = new MockPatch();
        p.setId(1);
        ArrayList<CrucibleRevision> fileRevs = new ArrayList<CrucibleRevision>();
        CrucibleRevision toRev = null;
        List files = DiffDirectory.list((File)patchFile, (Charset)Charsets.UTF_8);
        for (DiffRevisionsInfo dri : files) {
            if (dri.getFromRevisionName() != null) {
                fileRevs.add(this.createRevision(dri.getPath().getPath(), dri.getFromRevisionName(), dri.getFromRevisionName()));
            }
            toRev = this.createRevision(dri.getPath().getPath(), String.format("0:%s:T", dri.getIndex()), DiffRevisionsInfo.getToRevisionName((int)1));
            fileRevs.add(toRev);
        }
        p.setFileRevisions(fileRevs);
        p.setPatchFile(patchFile);
        return new PatchDiff(toRev, (Patch)p, SyntaxDefinition.PASS_THRU);
    }

    @Test
    public void testGetSectionViewsFullContextPatch() throws Exception {
        File patchFile = new File(BASE_DIR, "FullContextDiff.patch");
        PatchDiff patchDiff = this.getPatchDiff(patchFile);
        List views = patchDiff.getSectionViews(0);
        boolean[] common = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false};
        boolean[] gap = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true};
        int[] fromLineCount = new int[]{15, 0, 0, 1, 1, 0, 0, 13, 1, 1, 1, 1};
        int[] toLineCount = new int[]{3, 10, 1, 1, 1, 1, 13, 0, 1, 18, 1, 1};
        this.checkViews(views, 12, common, gap, fromLineCount, toLineCount);
        views = patchDiff.getSectionViews(-1);
        common = new boolean[]{true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true};
        gap = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        fromLineCount = new int[]{38, 15, 2, 0, 10, 0, 7, 1, 11, 1, 1, 0, 10, 0, 33, 13, 6, 1, 6, 1, 6, 1, 3, 1, 4};
        toLineCount = new int[]{38, 3, 2, 10, 10, 1, 7, 1, 11, 1, 1, 1, 10, 13, 33, 0, 6, 1, 6, 18, 6, 1, 3, 1, 4};
        this.checkViews(views, 25, common, gap, fromLineCount, toLineCount);
        views = patchDiff.getSectionViews(3);
        common = new boolean[]{true, false, true, false, true, true, false, true, true, false, true, true, false, true, false, true, true, false, true, true, false, true, false, true, false, true, false, true, false, true};
        gap = new boolean[]{false, false, false, false, false, true, false, false, true, false, false, true, false, false, false, false, true, false, false, true, false, false, false, false, false, false, false, false, false, false};
        fromLineCount = new int[]{3, 15, 2, 0, 3, 3, 0, 3, 3, 1, 3, 3, 1, 1, 0, 3, 3, 0, 3, 3, 13, 6, 1, 6, 1, 6, 1, 3, 1, 3};
        toLineCount = new int[]{3, 3, 2, 10, 3, 3, 1, 3, 3, 1, 3, 3, 1, 1, 1, 3, 3, 13, 3, 3, 0, 6, 1, 6, 18, 6, 1, 3, 1, 3};
        this.checkViews(views, 30, common, gap, fromLineCount, toLineCount);
        views = patchDiff.getSectionViews(10);
        common = new boolean[]{true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, true, false, true, false, true, false, true, false, true, false, true};
        gap = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false};
        fromLineCount = new int[]{10, 15, 2, 0, 10, 0, 7, 1, 11, 1, 1, 0, 10, 0, 10, 10, 13, 6, 1, 6, 1, 6, 1, 3, 1, 4};
        toLineCount = new int[]{10, 3, 2, 10, 10, 1, 7, 1, 11, 1, 1, 1, 10, 13, 10, 10, 0, 6, 1, 6, 18, 6, 1, 3, 1, 4};
        this.checkViews(views, 26, common, gap, fromLineCount, toLineCount);
    }

    private CrucibleRevision createRevision(String path, String rev, String revName) {
        CrucibleRevision r = new CrucibleRevision();
        r.setSourceName("Dummy");
        r.setRevision(rev);
        r.setRevisionDisplayName(revName);
        r.setStoredPath(StoredPathFactoryTestHelper.makeStoredPath(path));
        return r;
    }

    private void checkViews(List<PatchSectionView> views, int viewCount, boolean[] common, boolean[] gap, int[] fromLineCount, int[] toLineCount) throws Exception {
        Assert.assertEquals((int)viewCount, (int)common.length);
        Assert.assertEquals((int)viewCount, (int)gap.length);
        Assert.assertEquals((int)viewCount, (int)fromLineCount.length);
        Assert.assertEquals((int)viewCount, (int)toLineCount.length);
        Assert.assertEquals((int)viewCount, (int)views.size());
        for (int i = 0; i < viewCount; ++i) {
            Assert.assertEquals((String)("View " + i + " mismatch"), (boolean)common[i], (boolean)views.get(i).getSection().isCommonSubsequence());
            Assert.assertEquals((String)("View " + i + " mismatch"), (boolean)gap[i], (boolean)views.get(i).getSection().isSkippedPrevious());
            Assert.assertEquals((String)("View " + i + " mismatch"), (int)fromLineCount[i], (int)views.get(i).getSection().getFromLength());
            Assert.assertEquals((String)("View " + i + " mismatch"), (int)toLineCount[i], (int)views.get(i).getSection().getToLength());
        }
    }

    @Test
    public void testGetSectionViewsGappyPatch() throws Exception {
        File patchFile = new File(BASE_DIR, "3lineContextDiff.patch");
        PatchDiff patchDiff = this.getPatchDiff(patchFile);
        List views = patchDiff.getSectionViews(-1);
        boolean[] common = new boolean[]{true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true};
        boolean[] gap = new boolean[]{false, false, false, false, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        int[] fromLineCount = new int[]{3, 0, 1, 1, 3, 3, 4, 1, 0, 2, 7, 3, 3, 7, 1, 10, 1, 9, 1, 10, 1, 1, 2, 7, 1, 10, 1, 0, 1, 1, 1};
        int[] toLineCount = new int[]{3, 7, 1, 1, 3, 3, 32, 1, 1, 2, 1, 3, 3, 1, 1, 12, 1, 6, 1, 8, 1, 27, 2, 1, 1, 5, 1, 29, 1, 0, 1};
        this.checkViews(views, 31, common, gap, fromLineCount, toLineCount);
        views = patchDiff.getSectionViews(3);
        common = new boolean[]{true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true};
        gap = new boolean[]{false, false, false, false, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        fromLineCount = new int[]{3, 0, 1, 1, 3, 3, 4, 1, 0, 2, 7, 3, 3, 7, 1, 10, 1, 9, 1, 10, 1, 1, 2, 7, 1, 10, 1, 0, 1, 1, 1};
        toLineCount = new int[]{3, 7, 1, 1, 3, 3, 32, 1, 1, 2, 1, 3, 3, 1, 1, 12, 1, 6, 1, 8, 1, 27, 2, 1, 1, 5, 1, 29, 1, 0, 1};
        this.checkViews(views, 31, common, gap, fromLineCount, toLineCount);
        views = patchDiff.getSectionViews(10);
        common = new boolean[]{true, false, true, false, true, true, false, true, false, true, false, true, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true, false, true};
        gap = new boolean[]{false, false, false, false, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        fromLineCount = new int[]{3, 0, 1, 1, 3, 3, 4, 1, 0, 2, 7, 3, 3, 7, 1, 10, 1, 9, 1, 10, 1, 1, 2, 7, 1, 10, 1, 0, 1, 1, 1};
        toLineCount = new int[]{3, 7, 1, 1, 3, 3, 32, 1, 1, 2, 1, 3, 3, 1, 1, 12, 1, 6, 1, 8, 1, 27, 2, 1, 1, 5, 1, 29, 1, 0, 1};
        this.checkViews(views, 31, common, gap, fromLineCount, toLineCount);
        views = patchDiff.getSectionViews(0);
        common = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        gap = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true};
        fromLineCount = new int[]{0, 1, 4, 0, 7, 7, 10, 9, 10, 1, 7, 10, 0, 1};
        toLineCount = new int[]{7, 1, 32, 1, 1, 1, 12, 6, 8, 27, 1, 5, 29, 0};
        this.checkViews(views, 14, common, gap, fromLineCount, toLineCount);
    }

    @Test
    public void testGetSectionViewsCRC478Patch() throws Exception {
        File patchFile = new File(BASE_DIR, "CRC-478.patch");
        PatchDiff patchDiff = this.getPatchDiff(patchFile);
        List views = patchDiff.getSectionViews(-1);
        boolean[] common = new boolean[]{true, false, true, false, true, false, true};
        boolean[] gap = new boolean[]{false, false, false, false, false, false, false};
        int[] fromLineCount = new int[]{6, 4, 1, 2, 13, 2, 4};
        int[] toLineCount = new int[]{6, 0, 1, 2, 13, 2, 4};
        this.checkViews(views, 7, common, gap, fromLineCount, toLineCount);
        views = patchDiff.getSectionViews(3);
        common = new boolean[]{true, false, true, false, true, true, false, true};
        gap = new boolean[]{false, false, false, false, false, true, false, false};
        fromLineCount = new int[]{3, 4, 1, 2, 3, 3, 2, 3};
        toLineCount = new int[]{3, 0, 1, 2, 3, 3, 2, 3};
        this.checkViews(views, 8, common, gap, fromLineCount, toLineCount);
        views = patchDiff.getSectionViews(10);
        common = new boolean[]{true, false, true, false, true, false, true};
        gap = new boolean[]{false, false, false, false, false, false, false};
        fromLineCount = new int[]{6, 4, 1, 2, 13, 2, 4};
        toLineCount = new int[]{6, 0, 1, 2, 13, 2, 4};
        this.checkViews(views, 7, common, gap, fromLineCount, toLineCount);
        views = patchDiff.getSectionViews(0);
        common = new boolean[]{false, false, false};
        gap = new boolean[]{false, true, true};
        fromLineCount = new int[]{4, 2, 2};
        toLineCount = new int[]{0, 2, 2};
        this.checkViews(views, 3, common, gap, fromLineCount, toLineCount);
    }

    private void printViews(List<PatchSectionView> views) throws Exception {
        System.out.println("viewCount = " + views.size());
        System.out.print("Common ");
        for (PatchSectionView view : views) {
            System.out.print(view.getSection().isCommonSubsequence() + ",");
        }
        System.out.print("\nGap ");
        for (PatchSectionView view : views) {
            System.out.print(view.getSection().isSkippedPrevious() + ",");
        }
        System.out.print("\nFrom lnes ");
        for (PatchSectionView view : views) {
            System.out.print(view.getSection().getFromLength() + ",");
        }
        System.out.print("\nTo lines ");
        for (PatchSectionView view : views) {
            System.out.print(view.getSection().getToLength() + ",");
        }
        System.out.println("\n---------------------");
        for (PatchSectionView view : views) {
            if (view.getSection().isSkippedPrevious()) {
                System.out.println("*** Gap ***");
            }
            if (view.getSection().isCommonSubsequence()) {
                System.out.print(view.getFromLines());
            }
            if (!view.getSection().isDiff()) continue;
            String f = view.getFromLines().length() != 0 ? "- " + view.getFromLines().toString().replaceAll("\n[^$]", "\n- ") : "";
            String t = view.getToLines().length() != 0 ? "+ " + view.getToLines().toString().replaceAll("\n[^$]", "\n+ ") : "";
            System.out.print(f);
            System.out.print(t);
        }
        System.out.println("---------------------");
    }

    class MockPatch
    extends Patch {
        File patchFile;

        MockPatch() {
        }

        public void setPatchFile(File file) {
            this.patchFile = file;
        }

        public File getPatchFile() {
            return this.patchFile;
        }

        public UploadItem getUploadItem() {
            return new UploadItem();
        }
    }
}

