/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.reviews;

import com.cenqua.crucible.reports.reviews.StateCountCache;
import java.util.Calendar;
import java.util.Date;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class StateCountCacheTest {
    @Before
    public void setUp() {
        StateCountCache.flush();
    }

    @After
    public void tearDown() {
        StateCountCache.flush();
    }

    @Test
    public void testCache() {
        int i;
        Calendar cal = Calendar.getInstance();
        cal.set(2000, 0, 1, 12, 0, 0);
        for (i = 0; i < 20; ++i) {
            StateCountCache.put((Date)cal.getTime(), (String)"Review", (String)"CR", (long)i);
            StateCountCache.put((Date)cal.getTime(), (String)"Review", (String)"CR-BAM", (long)(20 - i));
            cal.add(5, 1);
        }
        cal.set(2000, 0, 1);
        Assert.assertEquals((long)0L, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
        Assert.assertEquals((long)0L, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
        Assert.assertEquals((long)20L, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
        Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-FEDORA"));
        cal.set(2000, 0, 10);
        Assert.assertEquals((long)9L, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
        Assert.assertEquals((long)11L, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
        cal.set(2010, 2, 4);
        Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
        Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
        cal.set(2000, 0, 10);
        StateCountCache.expireOlderThan((Date)cal.getTime());
        cal.set(2000, 0, 1);
        for (i = 0; i < 9; ++i) {
            Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
            Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
            cal.add(5, 1);
        }
        for (i = 9; i < 20; ++i) {
            Assert.assertEquals((long)i, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
            Assert.assertEquals((long)(20L - (long)i), (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
            cal.add(5, 1);
        }
        cal.set(2000, 0, 8);
        StateCountCache.expireOlderThan((Date)cal.getTime());
        cal.set(2000, 0, 1);
        for (i = 0; i < 9; ++i) {
            Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
            Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
            cal.add(5, 1);
        }
        for (i = 9; i < 20; ++i) {
            Assert.assertEquals((long)i, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
            Assert.assertEquals((long)(20L - (long)i), (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
            cal.add(5, 1);
        }
        cal.set(2000, 0, 19);
        StateCountCache.expireOlderThan((Date)cal.getTime());
        cal.set(2000, 0, 17);
        Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
        Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
        cal.set(2000, 0, 18);
        Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
        Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
        cal.set(2000, 0, 19);
        Assert.assertEquals((long)18L, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
        Assert.assertEquals((long)2L, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
        cal.set(2000, 0, 20);
        Assert.assertEquals((long)19L, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
        Assert.assertEquals((long)1L, (long)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
        StateCountCache.flush();
        cal.set(2000, 0, 20);
        Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR"));
        Assert.assertNull((Object)StateCountCache.get((Date)cal.getTime(), (String)"Review", (String)"CR-BAM"));
    }
}

