/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.reviews;

import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.reports.reviews.ReviewChart;
import com.cenqua.crucible.util.DummyReviewItemIndexer;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ReviewChartTest
extends UseTestSpringContextTestCase {
    private Date from;
    private Date to;
    private Project defaultProject;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
        DefaultReviewManager reviewManager = ModelUtils.getReviewManagerWithMockedManagersAndRealDAOs();
        reviewManager.setReviewItemIndexer((ReviewItemIndexer)new DummyReviewItemIndexer());
        DefaultReviewManager.set((ReviewManager)reviewManager);
        HibernateUtil.beginTransaction();
        Review review1 = ModelUtils.createBlankTestReview("review1");
        Review review2 = ModelUtils.createBlankTestReview("review2");
        Review review3 = ModelUtils.createBlankTestReview("review3");
        this.defaultProject = ((ProjectManager)SpringContext.getComponent(ProjectManager.class, (String)"projectManager")).getDefaultProject();
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        GregorianCalendar cal = new GregorianCalendar(2008, 0, 20);
        ((Calendar)cal).add(12, 20);
        StateChangeLog changeLog = new StateChangeLog("Review", review3.getId(), review3.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 2);
        changeLog = new StateChangeLog("Draft", review1.getId(), review1.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(6, 1);
        this.from = cal.getTime();
        changeLog = new StateChangeLog("Draft", review2.getId(), review2.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 2);
        changeLog = new StateChangeLog("Approval", review1.getId(), review1.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 15);
        changeLog = new StateChangeLog("Review", review1.getId(), review1.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(12, 4);
        changeLog = new StateChangeLog("Approval", review2.getId(), review2.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(6, 1);
        changeLog = new StateChangeLog("Review", review2.getId(), review2.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(6, 1);
        changeLog = new StateChangeLog("Summarize", review1.getId(), review1.getCreator());
        changeLog.setTimeStamp(cal.getTime());
        HibernateUtil.currentSession().save((Object)changeLog);
        ((Calendar)cal).add(6, 4);
        this.to = cal.getTime();
        HibernateUtil.commitTransaction();
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.commitTransaction();
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChart() throws IOException {
        File tempFile = FisheyeTestUtil.createTempFile("openReviewsChart");
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            ReviewChart reviewChart = new ReviewChart();
            reviewChart.getRenderChart((OutputStream)out, 400, 120, this.from, this.to, this.defaultProject, "Review");
        }
    }
}

