/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.commentsDefects;

import com.atlassian.crucible.actions.search.comment.CommentSearchData;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.reports.PieDatasetAdjuster;
import com.cenqua.crucible.reports.commentsDefects.DefectRepDatasetMaker;
import com.cenqua.crucible.reports.commentsDefects.DefectReportDO;
import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsEqual;
import org.jfree.data.general.DefaultPieDataset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DefectRepDatasetMakerTest {
    private DefectRepDatasetMaker defectRepDatasetMaker;
    private CommentSearchData commentSearchDataMock;
    private CommentManager commentManagerMock;
    private String metric = "metric1";

    @Before
    public void setUp() {
        this.commentSearchDataMock = (CommentSearchData)Mockito.mock(CommentSearchData.class);
        this.commentManagerMock = (CommentManager)Mockito.mock(CommentManager.class);
        this.defectRepDatasetMaker = new DefectRepDatasetMaker(this.commentManagerMock, this.commentSearchDataMock, this.metric);
        Mockito.when((Object)this.commentSearchDataMock.isDefects()).thenReturn((Object)true);
        Mockito.when((Object)this.commentSearchDataMock.isComments()).thenReturn((Object)false);
    }

    @Test
    public void testGetPieDataSetIsEmptyWhenCommentSearchDataIsNotADefect() throws Exception {
        Mockito.when((Object)this.commentSearchDataMock.isDefects()).thenReturn((Object)false);
        Mockito.when((Object)this.commentSearchDataMock.isComments()).thenReturn((Object)true);
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(Arrays.asList(new DefectReportDO("groupA", "labelA", Long.valueOf(10L)), new DefectReportDO("groupA", "labelB", Long.valueOf(10L))));
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getItemCount(), (Matcher)IsEqual.equalTo((Object)0));
    }

    @Test
    public void testGetPieDataSetIsNotEmptyWhenCommentSearchDataIsADefect() throws Exception {
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(Arrays.asList(new DefectReportDO("groupA", "labelA", Long.valueOf(10L)), new DefectReportDO("groupA", "labelB", Long.valueOf(10L))));
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getItemCount(), (Matcher)IsEqual.equalTo((Object)2));
    }

    @Test
    public void testGetPieDataSetKeysCorrectLabels() throws Exception {
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(Arrays.asList(new DefectReportDO("groupA", "labelA", Long.valueOf(10L)), new DefectReportDO("groupA", "labelB", Long.valueOf(10L))));
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getKeys(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"50% labelA", "50% labelB"}));
    }

    @Test
    public void testGetPieDataSetLabelsPercentValueSumsTo100() throws Exception {
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(Arrays.asList(new DefectReportDO("groupA", "labelA", Long.valueOf(10L)), new DefectReportDO("groupA", "labelB", Long.valueOf(10L)), new DefectReportDO("groupA", "labelC", Long.valueOf(10L))));
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getKeys(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"33% labelA", "33% labelB", "34% labelC"}));
    }

    @Test
    public void testGetPieDataSetLabelsPercentValueRoundingSumExceed100() throws Exception {
        ArrayList<DefectReportDO> defects = new ArrayList<DefectReportDO>();
        for (int i = 0; i < 110; ++i) {
            defects.add(new DefectReportDO("groupA", "label" + i, Long.valueOf(1L)));
        }
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(defects);
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getKeys(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"1% label0", "1% label50", "1% label99", "0% label100", "0% label105", "0% label109"}));
    }

    @Test
    public void testGetPieDataSetLabelsAllCountersAreZero() throws Exception {
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(Arrays.asList(new DefectReportDO("groupA", "labelA", Long.valueOf(0L)), new DefectReportDO("groupA", "labelB", Long.valueOf(0L)), new DefectReportDO("groupA", "labelC", Long.valueOf(0L))));
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getKeys(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"0% labelA", "0% labelB", "0% labelC"}));
    }

    @Test
    public void testGetPieDataSetWithOneDefectReport() throws Exception {
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(Arrays.asList(new DefectReportDO("groupA", "labelA", Long.valueOf(100000L))));
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getKeys(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"100% labelA"}));
    }

    @Test
    public void testGetPieDataSetWithHundred1PercentDefectReports() throws Exception {
        ArrayList<DefectReportDO> defects = new ArrayList<DefectReportDO>();
        for (int i = 0; i < 100; ++i) {
            defects.add(new DefectReportDO("groupA", "label" + i, Long.valueOf(1L)));
        }
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(defects);
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getKeys(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"1% label0", "1% label50", "1% label99"}));
    }

    @Test
    public void testGetPieDataSetBigDiffInCountersLast() throws Exception {
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(Arrays.asList(new DefectReportDO("groupA", "labelA", Long.valueOf(1L)), new DefectReportDO("groupA", "labelB", Long.valueOf(1L)), new DefectReportDO("groupA", "labelC", Long.valueOf(10000L))));
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getKeys(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"0% labelA", "0% labelB", "100% labelC"}));
    }

    @Test
    public void testGetPieDataSetBigDiffInCountersFirst() throws Exception {
        Mockito.when((Object)this.commentManagerMock.getDefectReports(this.commentSearchDataMock, this.metric)).thenReturn(Arrays.asList(new DefectReportDO("groupA", "labelA", Long.valueOf(10000L)), new DefectReportDO("groupA", "labelB", Long.valueOf(1L)), new DefectReportDO("groupA", "labelC", Long.valueOf(1L))));
        Assert.assertThat((Object)PieDatasetAdjuster.addPercentToLabels((DefaultPieDataset)this.defectRepDatasetMaker.getPieDataSet()).getKeys(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"100% labelA", "0% labelB", "0% labelC"}));
    }
}

