/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.commentsDefects;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.reports.commentsDefects.CommentChart;
import com.cenqua.crucible.util.UseTestSpringContextTestCase;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CommentChartTest
extends UseTestSpringContextTestCase {
    private Date from;
    private Date to;
    private Project project;
    private CommentManager commentManager;

    @Before
    public void setUp() throws Exception {
        Comment c;
        int i;
        TestFishEyeInstances.loadSanity1();
        HibernateUtil.beginTransaction();
        Review review = ModelUtils.createBlankTestReview("testreview");
        HibernateUtil.commitTransaction();
        HibernateUtil.beginTransaction();
        this.project = ((ProjectManager)SpringContext.getComponent(ProjectManager.class, (String)"projectManager")).getDefaultProject();
        this.commentManager = (CommentManager)SpringContext.getComponent((String)"commentManager");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2008, 0, 20, 0, 0, 0);
        for (i = 0; i < 3; ++i) {
            c = this.commentManager.createComment("test comment Sunday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        this.from = cal.getTime();
        for (i = 0; i < 3; ++i) {
            c = this.commentManager.createComment("test defect Monday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setDefectRaised(true);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        for (i = 0; i < 5; ++i) {
            c = this.commentManager.createComment("test comment Monday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 6; ++i) {
            c = this.commentManager.createComment("test comment Tuesday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 12; ++i) {
            c = this.commentManager.createComment("test comment Wednesday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 9; ++i) {
            c = this.commentManager.createComment("test comment Thursday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 8; ++i) {
            c = this.commentManager.createComment("test defect Friday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setDefectRaised(true);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        for (i = 0; i < 15; ++i) {
            c = this.commentManager.createComment("test comment Friday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 1; ++i) {
            c = this.commentManager.createComment("test comment Saturday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        ((Calendar)cal).add(6, 1);
        for (i = 0; i < 3; ++i) {
            c = this.commentManager.createComment("test comment Following Monday " + i, review, review.getAuthor());
            ((Calendar)cal).add(12, 1);
            c.setCreateDate(cal.getTime());
            review.addComment(c);
        }
        this.to = cal.getTime();
        HibernateUtil.commitTransaction();
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.commitTransaction();
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChart() throws IOException {
        File tempFile = FisheyeTestUtil.createTempFile("commentChart");
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            CommentChart commentChart = new CommentChart(this.commentManager);
            commentChart.getRenderChart((OutputStream)out, 400, 120, this.from, this.to, this.project);
        }
    }
}

