/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports;

import com.cenqua.crucible.reports.PieDatasetAdjuster;
import junit.framework.TestCase;
import org.jfree.data.general.DefaultPieDataset;

public class PieDatasetAdjusterTest
extends TestCase {
    DefaultPieDataset startDs;

    public void setUp() {
        this.startDs = new DefaultPieDataset();
        this.startDs.setValue((Comparable)((Object)"A"), 360.0);
        this.startDs.setValue((Comparable)((Object)"B"), 30.0);
        this.startDs.setValue((Comparable)((Object)"C"), 1.0);
    }

    public void testNoChange() {
        PieDatasetAdjusterTest.assertEquals((Object)this.startDs, (Object)PieDatasetAdjuster.adjustPieDataset((DefaultPieDataset)this.startDs, (int)3, (double)0.0));
    }

    public void testEmptyData() {
        DefaultPieDataset out = PieDatasetAdjuster.adjustPieDataset((DefaultPieDataset)new DefaultPieDataset(), (int)5, (double)2.0);
        PieDatasetAdjusterTest.assertEquals((int)0, (int)out.getItemCount());
    }

    public void testNoOtherMaxSegs() {
        PieDatasetAdjusterTest.assertEquals((Object)this.startDs, (Object)PieDatasetAdjuster.adjustPieDataset((DefaultPieDataset)this.startDs, (int)2, (double)0.0));
    }

    public void testNoOtherSize() {
        PieDatasetAdjusterTest.assertEquals((Object)this.startDs, (Object)PieDatasetAdjuster.adjustPieDataset((DefaultPieDataset)this.startDs, (int)5, (double)1.0));
    }

    public void testOtherMaxSegs() {
        this.startDs.setValue((Comparable)((Object)"D"), 1.0);
        DefaultPieDataset finalDs = PieDatasetAdjuster.adjustPieDataset((DefaultPieDataset)this.startDs, (int)2, (double)0.0);
        PieDatasetAdjusterTest.assertEquals((int)3, (int)finalDs.getItemCount());
        PieDatasetAdjusterTest.assertEquals((Object)360.0, (Object)finalDs.getValue((Comparable)((Object)"A")));
        PieDatasetAdjusterTest.assertEquals((Object)30.0, (Object)finalDs.getValue((Comparable)((Object)"B")));
        PieDatasetAdjusterTest.assertEquals((Object)2.0, (Object)finalDs.getValue((Comparable)((Object)"Other")));
    }

    public void testOtherSize() {
        this.startDs.setValue((Comparable)((Object)"D"), 1.0);
        DefaultPieDataset finalDs = PieDatasetAdjuster.adjustPieDataset((DefaultPieDataset)this.startDs, (int)5, (double)1.0);
        PieDatasetAdjusterTest.assertEquals((int)3, (int)finalDs.getItemCount());
        PieDatasetAdjusterTest.assertEquals((Object)360.0, (Object)finalDs.getValue((Comparable)((Object)"A")));
        PieDatasetAdjusterTest.assertEquals((Object)30.0, (Object)finalDs.getValue((Comparable)((Object)"B")));
        PieDatasetAdjusterTest.assertEquals((Object)2.0, (Object)finalDs.getValue((Comparable)((Object)"Other")));
    }
}

