/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.StateNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.creators.BatchCreatorTestBase;
import com.cenqua.crucible.notification.batch.creators.StateChangeBatchCreator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class StateChangeBatchCreatorTest
extends BatchCreatorTestBase {
    @Test
    public void testSummarizeAndCloseOneReview() throws Exception {
        StateChangeBatchCreator batcher = this.withMockedTemplateRenderer(new StateChangeBatchCreator());
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        FecruUser user = new FecruUser(Integer.valueOf(1), "actioner");
        Review review = new Review();
        review.setId(Integer.valueOf(1));
        review.setName("review");
        Project project = new Project();
        project.setId(Integer.valueOf(1));
        review.setProject(project);
        State summarize = new State("Summarize", "Summarize", StateManager.States.SUMMARIZE_STATE, StateManager.MetaState.OPEN);
        State closed = new State("Closed", "Closed", StateManager.States.CLOSED_STATE, StateManager.MetaState.CLOSED);
        review.setState(summarize);
        Notification summarizeNotification = new Notification();
        summarizeNotification.setId(Integer.valueOf(1));
        StateNotificationEvent summarizeNote = new StateNotificationEvent(user, review);
        summarizeNotification.setEvent((NotificationEvent)summarizeNote);
        notifications.add(summarizeNotification);
        review.setState(closed);
        Notification closeNotification = new Notification();
        closeNotification.setId(Integer.valueOf(2));
        StateNotificationEvent closeNote = new StateNotificationEvent(user, review);
        closeNotification.setEvent((NotificationEvent)closeNote);
        notifications.add(closeNotification);
        Batch batch = batcher.getEmailSegment(notifications, null, false);
        Assert.assertTrue((batch.getNotifications().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)batch.getNotifications().contains(summarizeNotification));
        Assert.assertTrue((boolean)batch.getNotifications().contains(closeNotification));
        Map<String, Object> templateAttributes = this.verifyRenderCrucibleTemplate(false, "batch-state-note.ftl");
        Assert.assertTrue((((List)templateAttributes.get("stateChanges")).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((List)templateAttributes.get("stateChanges")).contains(summarizeNote));
        Assert.assertTrue((boolean)((List)templateAttributes.get("stateChanges")).contains(closeNote));
        Assert.assertEquals((Object)(review.getPermaId() + ": " + review.getName()), (Object)batch.getSubject());
        Assert.assertEquals((Object)"State changed to Closed", (Object)batch.getSummary());
        Assert.assertEquals((Object)StateChangeBatchCreatorTest.getExpectedThreadIdForReview(review), (Object)batch.getMailThreadId());
    }
}

