/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.MockModelUtil;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.SharableContentType;
import com.cenqua.crucible.notification.ShareContentNotificationEvent;
import com.cenqua.crucible.notification.batch.creators.BatchCreatorTestBase;
import com.cenqua.crucible.notification.batch.creators.ShareContentBatchCreator;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class ShareContentBatchCreatorTest
extends BatchCreatorTestBase {
    private MockModelUtil modelUtil = new MockModelUtil();

    @Test
    public void testShareContent() throws Exception {
        ShareContentBatchCreator batchCreator = this.withMockedTemplateRenderer(new ShareContentBatchCreator());
        FecruUser sharer = this.modelUtil.createUser("sharer");
        ShareContentNotificationEvent event = new ShareContentNotificationEvent(sharer, (List)Lists.newArrayList(), (List)Lists.newArrayList(), "url", "objectName", "objectRepository", "objectId", SharableContentType.CHANGESET, "note");
        Notification not2 = this.createNotification(this.modelUtil.createUser("sharee1"));
        Notification not3 = this.createNotification("sharee2@noop");
        Notification notification = new Notification();
        notification.setEvent((NotificationEvent)event);
        notification.setUser(sharer);
        event.setNotifications((Set)Sets.newHashSet((Object[])new Notification[]{this.createNotification(sharer), not2, not3}));
        batchCreator.getEmailSegment(Collections.singletonList(notification), null, false);
        Map<String, Object> templateAttributes = this.verifyRenderCrucibleTemplate(false, "share-notification.ftl");
        Assert.assertSame((Object)event, (Object)templateAttributes.get("notificationEvent"));
        ShareContentBatchCreator.Share share = (ShareContentBatchCreator.Share)templateAttributes.get("share");
        junit.framework.Assert.assertNotNull((Object)share);
        junit.framework.Assert.assertEquals((String)event.getObjectUrl(), (String)share.getUrl());
        junit.framework.Assert.assertEquals((String)(event.getObjectId() + ": " + event.getObjectName()), (String)share.getLinkText());
        junit.framework.Assert.assertEquals((Object)event.getActioner(), (Object)share.getFrom());
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new FecruUser[]{not2.getUser()}), (Object)share.getOtherUsers());
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{not3.getEmailAddress()}), (Object)share.getOtherEmails());
        junit.framework.Assert.assertEquals((String)"a changeset", (String)share.getTypeDescription());
        junit.framework.Assert.assertEquals((String)event.getNote(), (String)share.getMessage());
        junit.framework.Assert.assertEquals((String)event.getObjectRepository(), (String)share.getRepository());
    }

    private Notification createNotification(FecruUser user) {
        Notification notification = new Notification();
        notification.setUser(user);
        return notification;
    }

    private Notification createNotification(String email) {
        Notification notification = new Notification();
        notification.setEmailAddress(email);
        return notification;
    }
}

