/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.RevisionAddedNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.creators.BatchCreatorTestBase;
import com.cenqua.crucible.notification.batch.creators.RevisionAddedBatchCreator;
import com.cenqua.fisheye.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class RevisionAddedBatchCreatorTest
extends BatchCreatorTestBase {
    @Test
    public void testThreeAddedRevisions() throws Exception {
        RevisionAddedBatchCreator batcher = this.withMockedTemplateRenderer(new RevisionAddedBatchCreator());
        FecruUser feCommenter = new FecruUser("actioner");
        FecruUser actioner = new FecruUser(Integer.valueOf(1), feCommenter.getUsername());
        Project project = new Project();
        project.setId(Integer.valueOf(1));
        MyReview review = new MyReview();
        review.setId(1);
        review.setProject(project);
        review.setName("review");
        Date createDate = new Date();
        MyFRX aaa = new MyFRX(review, createDate, new Path((CharSequence)"/a/a/a.txt"));
        MyFRX aab = new MyFRX(review, createDate, new Path((CharSequence)"/a/a/b.txt"));
        MyFRX aac = new MyFRX(review, createDate, new Path((CharSequence)"/a/a/c.txt"));
        MyFRX bbb = new MyFRX(review, createDate, new Path((CharSequence)"/b/b/b.txt"));
        MyFRX ccc = new MyFRX(review, createDate, new Path((CharSequence)"/c/c/c.txt"));
        aaa.setId(1);
        aab.setId(2);
        aac.setId(3);
        bbb.setId(4);
        ccc.setId(5);
        HashSet<FileRevisionExtraInfo> frxs = new HashSet<FileRevisionExtraInfo>();
        frxs.add(aaa);
        frxs.add(aab);
        frxs.add(aac);
        frxs.add(bbb);
        frxs.add(ccc);
        review.setPublicFrxs(frxs);
        MyFRXRevision rev1 = new MyFRXRevision(aab, null, createDate, "rev1");
        MyFRXRevision rev2 = new MyFRXRevision(bbb, null, createDate, "rev2");
        MyFRXRevision rev3 = new MyFRXRevision(bbb, null, createDate, "rev3");
        aab.setFrxRevisions(Collections.singletonList(rev1));
        ArrayList<MyFRXRevision> bbbRevisions = new ArrayList<MyFRXRevision>();
        bbbRevisions.add(rev2);
        bbbRevisions.add(rev3);
        bbb.setFrxRevisions(bbbRevisions);
        RevisionAddedNotificationEvent rev1Added = new RevisionAddedNotificationEvent(actioner, (Review)review, (FRXRevision)rev1);
        RevisionAddedNotificationEvent rev2Added = new RevisionAddedNotificationEvent(actioner, (Review)review, (FRXRevision)rev2);
        RevisionAddedNotificationEvent rev3Added = new RevisionAddedNotificationEvent(actioner, (Review)review, (FRXRevision)rev3);
        Notification recipient1 = new Notification();
        recipient1.setId(Integer.valueOf(1));
        recipient1.setEvent((NotificationEvent)rev1Added);
        Notification recipient2 = new Notification();
        recipient2.setId(Integer.valueOf(2));
        recipient2.setEvent((NotificationEvent)rev2Added);
        Notification recipient3 = new Notification();
        recipient3.setId(Integer.valueOf(3));
        recipient3.setEvent((NotificationEvent)rev3Added);
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        notifications.add(recipient1);
        notifications.add(recipient2);
        notifications.add(recipient3);
        Batch batch = batcher.getEmailSegment(notifications, null, false);
        Assert.assertTrue((batch.getNotifications().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)batch.getNotifications().contains(recipient1));
        Assert.assertTrue((boolean)batch.getNotifications().contains(recipient2));
        Assert.assertTrue((boolean)batch.getNotifications().contains(recipient3));
        Assert.assertEquals((Object)actioner, (Object)batch.getCommonActioner());
        Map<String, Object> templateAttributes = this.verifyRenderCrucibleTemplate(false, "batch-revision-added-note.ftl");
        List orderedFrxs = (List)templateAttributes.get("orderedFrxs");
        Assert.assertEquals((long)5L, (long)orderedFrxs.size());
        Assert.assertEquals((Object)((Object)aab), orderedFrxs.get(0));
        Assert.assertEquals((Object)((Object)bbb), orderedFrxs.get(1));
        Assert.assertEquals((Object)((Object)aaa), orderedFrxs.get(2));
        Assert.assertEquals((Object)((Object)aac), orderedFrxs.get(3));
        Assert.assertEquals((Object)((Object)ccc), orderedFrxs.get(4));
        Map newRevisions = (Map)templateAttributes.get("newRevisions");
        Assert.assertEquals((long)2L, (long)newRevisions.size());
        Assert.assertEquals((long)1L, (long)((Set)newRevisions.get(aab.getPermaId())).size());
        Assert.assertTrue((boolean)((Set)newRevisions.get(aab.getPermaId())).contains(rev1Added));
        Assert.assertEquals((long)2L, (long)((Set)newRevisions.get(bbb.getPermaId())).size());
        Assert.assertTrue((boolean)((Set)newRevisions.get(bbb.getPermaId())).contains(rev2Added));
        Assert.assertTrue((boolean)((Set)newRevisions.get(bbb.getPermaId())).contains(rev3Added));
        Assert.assertEquals((Object)(review.getPermaId() + ": " + review.getName()), (Object)batch.getSubject());
        Assert.assertEquals((Object)"3 file revisions added", (Object)batch.getSummary());
        Assert.assertEquals((Object)RevisionAddedBatchCreatorTest.getExpectedThreadIdForReview(review), (Object)batch.getMailThreadId());
    }

    public static class MyReview
    extends Review {
        public void setPublicFrxs(Set<FileRevisionExtraInfo> frxs) {
            super.setFrxs(frxs);
        }
    }

    public static class MyFRXRevision
    extends FRXRevision {
        String revisionDisplayName;

        public MyFRXRevision(FileRevisionExtraInfo frx, CrucibleRevision fr, Date dateAdded, String revisionDisplayName) {
            super(frx, fr, dateAdded);
            this.revisionDisplayName = revisionDisplayName;
        }
    }

    public static class MyFRX
    extends FileRevisionExtraInfo {
        Path fePath;

        public MyFRX(Review review, Date whenAdded, Path fePath) {
            super(review, whenAdded);
            this.fePath = fePath;
            this.frxRevisionsIsClean = true;
        }

        public Path getFePath() {
            return this.fePath;
        }
    }
}

