/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.AllCompletedNotificationEvent;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.creators.BatchCreatorTestBase;
import com.cenqua.crucible.notification.batch.creators.ReviewerBatchCreator;
import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ReviewerBatchCreatorTest
extends BatchCreatorTestBase {
    @Test
    public void testOneUserAllCompleteOneReview() throws Exception {
        ReviewerBatchCreator batcher = this.withMockedTemplateRenderer(new ReviewerBatchCreator());
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        Notification r = new Notification();
        r.setId(Integer.valueOf(1));
        FecruUser user = new FecruUser(Integer.valueOf(1), "actioner");
        Review review = new Review();
        review.setId(Integer.valueOf(1));
        Project project = new Project();
        project.setId(Integer.valueOf(1));
        review.setProject(project);
        AllCompletedNotificationEvent note = new AllCompletedNotificationEvent(user, review);
        r.setEvent((NotificationEvent)note);
        notifications.add(r);
        Batch batch = batcher.getEmailSegment(notifications, null, false);
        Assert.assertTrue((batch.getNotifications().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)batch.getNotifications().contains(r));
        Assert.assertEquals((Object)(review.getPermaId() + ": " + review.getName()), (Object)batch.getSubject());
        Assert.assertEquals((Object)"Everyone has finished reviewing", (Object)batch.getSummary());
        Assert.assertEquals((Object)ReviewerBatchCreatorTest.getExpectedThreadIdForReview(review), (Object)batch.getMailThreadId());
        Map<String, Object> templateAttributes = this.verifyRenderCrucibleTemplate(false, "batch-reviewer-note.ftl");
        Assert.assertEquals((Object)review, (Object)templateAttributes.get("review"));
        Assert.assertTrue((boolean)((Boolean)templateAttributes.get("allComplete")));
        Assert.assertFalse((boolean)((Boolean)templateAttributes.get("allUncomplete")));
    }
}

