/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.cenqua.crucible.notification.CommentNotificationEvent;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.PluginNotificationEvent;
import com.cenqua.crucible.notification.batch.creators.PluginBatchCreator;
import org.junit.Assert;
import org.junit.Test;

public class PluginBatchCreatorTest {
    @Test
    public void testDoesntAcceptForeignEvents() {
        PluginBatchCreator messageCreator = new PluginBatchCreator();
        Assert.assertFalse((boolean)messageCreator.accepts(null, (NotificationEvent)new CommentNotificationEvent()));
    }

    @Test
    public void testGroupsPluginNotificationEvents() {
        PluginBatchCreator messageCreator = new PluginBatchCreator();
        Assert.assertTrue((boolean)messageCreator.accepts(null, (NotificationEvent)new PluginNotificationEvent()));
    }

    @Test
    public void testGroupsPluginNotificationEventsWithSameSubjectAndGroupType() {
        PluginBatchCreator messageCreator = new PluginBatchCreator();
        Assert.assertTrue((boolean)messageCreator.accepts((NotificationEvent)new PluginNotificationEvent(null, "foo", "bar", "baz", "bam"), (NotificationEvent)new PluginNotificationEvent(null, "foo", "bar", "baz", "bam")));
    }

    @Test
    public void testGroupsPluginNotificationEventsWithDifferentSubjectAndGroupType() {
        PluginBatchCreator messageCreator = new PluginBatchCreator();
        Assert.assertFalse((boolean)messageCreator.accepts((NotificationEvent)new PluginNotificationEvent(null, "foo", "bar", "baz", "bam"), (NotificationEvent)new PluginNotificationEvent(null, "foo1", "bar1", "baz", "bam")));
    }

    @Test
    public void testGroupsPluginNotificationEventsWithDifferentSubject() {
        PluginBatchCreator messageCreator = new PluginBatchCreator();
        Assert.assertFalse((boolean)messageCreator.accepts((NotificationEvent)new PluginNotificationEvent(null, "foo", "bar", "baz", "bam"), (NotificationEvent)new PluginNotificationEvent(null, "foo", "bar1", "baz", "bam")));
    }

    @Test
    public void testGroupsPluginNotificationEventsWithDifferentGroupType() {
        PluginBatchCreator messageCreator = new PluginBatchCreator();
        Assert.assertFalse((boolean)messageCreator.accepts((NotificationEvent)new PluginNotificationEvent(null, "foo", "bar", "baz", "bam"), (NotificationEvent)new PluginNotificationEvent(null, "foo1", "bar", "baz", "bam")));
    }
}

