/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.CommentPropertiesChangedNotificationEvent;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.ShareContentNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.EmailThreadingHelper;
import com.cenqua.crucible.notification.batch.creators.CommentPropertiesChangeBatchCreator;
import com.cenqua.crucible.notification.batch.creators.EmailTemplateRender;
import com.cenqua.crucible.util.HtmlAndTextPair;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.WebServerType;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnitParamsRunner.class)
public class CommentPropertiesChangeBatchCreatorTest {
    @Mock
    private EmailTemplateRender emailTemplateRender;
    @InjectMocks
    private CommentPropertiesChangeBatchCreator batchCreator;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        WebServerType webServerType = (WebServerType)Mockito.mock(WebServerType.class);
        Mockito.when((Object)webServerType.isSetSiteUrl()).thenReturn((Object)true);
        Mockito.when((Object)webServerType.getSiteUrl()).thenReturn((Object)"http://localhost:3990/fecru");
        ConfigDocument.Config config = (ConfigDocument.Config)Mockito.mock(ConfigDocument.Config.class);
        Mockito.when((Object)config.getWebServer()).thenReturn((Object)webServerType);
        ConfigDocument configDocument = (ConfigDocument)Mockito.mock(ConfigDocument.class);
        Mockito.when((Object)configDocument.getConfig()).thenReturn((Object)config);
        AppConfig.getsConfig().setConfig(configDocument);
    }

    @Test
    @Parameters(method="parametersForTestAccepts")
    public void testAccepts(NotificationEvent existing, NotificationEvent newNote, boolean expectedResult) throws Exception {
        MatcherAssert.assertThat((Object)this.batchCreator.accepts(existing, newNote), (Matcher)CoreMatchers.is((Object)expectedResult));
    }

    private Object[] parametersForTestAccepts() throws Exception {
        NotificationEvent propertiesChangedEvent = (NotificationEvent)Mockito.mock(CommentPropertiesChangedNotificationEvent.class);
        NotificationEvent otherNotificationEvent = (NotificationEvent)Mockito.mock(ShareContentNotificationEvent.class);
        return JUnitParamsRunner.$((Object[])new Object[]{JUnitParamsRunner.$((Object[])new Object[]{null, null, false}), JUnitParamsRunner.$((Object[])new Object[]{null, otherNotificationEvent, false}), JUnitParamsRunner.$((Object[])new Object[]{null, propertiesChangedEvent, true}), JUnitParamsRunner.$((Object[])new Object[]{otherNotificationEvent, null, false}), JUnitParamsRunner.$((Object[])new Object[]{otherNotificationEvent, propertiesChangedEvent, false}), JUnitParamsRunner.$((Object[])new Object[]{propertiesChangedEvent, null, false}), JUnitParamsRunner.$((Object[])new Object[]{propertiesChangedEvent, propertiesChangedEvent, false})});
    }

    @Test
    public void testGetEmailSegmentNoNotifications() throws Exception {
        List notifications = Collections.emptyList();
        Batch emailSegment = this.batchCreator.getEmailSegment(notifications, TimeZone.getDefault(), true);
        MatcherAssert.assertThat((Object)emailSegment, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetEmailSegmentAggregation() throws Exception {
        ImmutableList notifications = ImmutableList.of((Object)Mockito.mock(Notification.class), (Object)Mockito.mock(Notification.class));
        this.batchCreator.getEmailSegment((List)notifications, TimeZone.getDefault(), true);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetEmailSegmentUnsupportedEvent() throws Exception {
        Notification notification = (Notification)Mockito.mock(Notification.class);
        NotificationEvent otherNotificationEvent = (NotificationEvent)Mockito.mock(ShareContentNotificationEvent.class);
        Mockito.when((Object)notification.getEvent()).thenReturn((Object)otherNotificationEvent);
        this.batchCreator.getEmailSegment((List)ImmutableList.of((Object)notification), TimeZone.getDefault(), true);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetEmailSegmentNoComment() throws Exception {
        Notification notification = (Notification)Mockito.mock(Notification.class);
        CommentPropertiesChangedNotificationEvent event = (CommentPropertiesChangedNotificationEvent)Mockito.mock(CommentPropertiesChangedNotificationEvent.class);
        Mockito.when((Object)notification.getEvent()).thenReturn((Object)event);
        Mockito.when((Object)event.getComment()).thenReturn(null);
        this.batchCreator.getEmailSegment((List)ImmutableList.of((Object)notification), TimeZone.getDefault(), true);
    }

    @Test
    @Parameters(value={"true", "false"})
    public void testGetEmailSegmentSuccessfulPath(boolean isHtml) throws Exception {
        Comment comment = (Comment)Mockito.mock(Comment.class);
        Comment rootComment = (Comment)Mockito.mock(Comment.class);
        Mockito.when((Object)comment.getRootComment()).thenReturn((Object)rootComment);
        Review review = (Review)Mockito.mock(Review.class);
        Mockito.when((Object)review.getPermaId()).thenReturn((Object)"FOO-BAR");
        Mockito.when((Object)review.getName()).thenReturn((Object)"Lorem ipsum");
        HtmlAndTextPair headerNote = HtmlAndTextPair.of((String)"Lorem", (String)"Ipsum");
        CommentPropertiesChangedNotificationEvent event = (CommentPropertiesChangedNotificationEvent)Mockito.mock(CommentPropertiesChangedNotificationEvent.class);
        Mockito.when((Object)event.getComment()).thenReturn((Object)comment);
        Mockito.when((Object)event.getReview()).thenReturn((Object)review);
        Mockito.when((Object)event.getHeaderNote()).thenReturn((Object)headerNote);
        Notification notification = (Notification)Mockito.mock(Notification.class);
        Mockito.when((Object)notification.getEvent()).thenReturn((Object)event);
        Batch emailSegment = this.batchCreator.getEmailSegment((List)ImmutableList.of((Object)notification), TimeZone.getDefault(), isHtml);
        ((EmailTemplateRender)Mockito.verify((Object)this.emailTemplateRender)).renderCrucibleTemplate(Matchers.anyMapOf(String.class, Object.class), Matchers.eq((boolean)isHtml), (String)Matchers.eq((Object)"custom-comment-change-note.ftl"));
        MatcherAssert.assertThat((Object)emailSegment.getSubject(), (Matcher)CoreMatchers.is((Object)EmailThreadingHelper.buildSubjectForReview((Review)review)));
    }
}

