/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.MockModelUtil;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.CommentNotificationEvent;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.notification.ReplyNotificationEvent;
import com.cenqua.crucible.notification.RevisionAddedNotificationEvent;
import com.cenqua.crucible.notification.batch.Batch;
import com.cenqua.crucible.notification.batch.creators.BatchCreatorTestBase;
import com.cenqua.crucible.notification.batch.creators.CommentBatchCreator;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.util.Pair;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CommentBatchCreatorTest
extends BatchCreatorTestBase {
    private MockModelUtil modelUtil;
    private Project project;
    CommentBatchCreator batcher;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.modelUtil = new MockModelUtil();
        this.project = this.modelUtil.createProject();
        this.batcher = this.withMockedTemplateRenderer(new CommentBatchCreator());
    }

    @Test
    public void testBatchesWithDifferentAmountsOfCommentsWillUseSameSubjectAndThreadIdForCorrectThreading() throws Exception {
        FecruUser commenter = this.modelUtil.createUser(new FecruUser("commenter"));
        Review review = this.modelUtil.createReview(this.project, "review");
        Comment comment1 = this.modelUtil.createComment(review, commenter);
        CommentNotificationEvent comment1Event = new CommentNotificationEvent(review, comment1);
        Comment comment2 = this.modelUtil.createComment(review, commenter);
        CommentNotificationEvent comment2Event = new CommentNotificationEvent(review, comment2);
        Batch batchFor1Comment = this.batcher.getEmailSegment((List)ImmutableList.of((Object)this.modelUtil.createNotification((NotificationEvent)comment1Event)), TimeZone.getDefault(), false);
        Batch batchFor2Comments = this.batcher.getEmailSegment((List)ImmutableList.of((Object)this.modelUtil.createNotification((NotificationEvent)comment1Event), (Object)this.modelUtil.createNotification((NotificationEvent)comment2Event)), TimeZone.getDefault(), false);
        Assert.assertThat((Object)batchFor1Comment.getSubject(), (Matcher)Matchers.is((Object)batchFor2Comments.getSubject()));
        Assert.assertThat((Object)batchFor1Comment.getMailThreadId(), (Matcher)Matchers.is((Object)batchFor2Comments.getMailThreadId()));
    }

    @Test
    public void testTwoNewReplies() throws Exception {
        FecruUser commenter = this.modelUtil.createUser(new FecruUser("commenter"));
        Review review = this.modelUtil.createReview(this.project, "review");
        Comment root = this.modelUtil.createComment(review, commenter);
        Comment reply = this.modelUtil.createReply(review, commenter, root);
        Comment deepReply = this.modelUtil.createReply(review, commenter, reply);
        List<Comment> rootComments = Collections.singletonList(root);
        ReplyNotificationEvent replyNote = new ReplyNotificationEvent(review, root, reply);
        ReplyNotificationEvent deepReplyNote = new ReplyNotificationEvent(review, reply, deepReply);
        Notification replyNotification = this.modelUtil.createNotification((NotificationEvent)replyNote);
        Notification deepReplyNotification = this.modelUtil.createNotification((NotificationEvent)deepReplyNote);
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        notifications.add(replyNotification);
        notifications.add(deepReplyNotification);
        Batch batch = this.batcher.getEmailSegment(notifications, TimeZone.getDefault(), false);
        this.assertRecipients(batch, notifications);
        this.assertCommonParts(batch, commenter);
        this.assertRootComments(rootComments);
        Assert.assertEquals((Object)(review.getPermaId() + ": " + review.getName()), (Object)batch.getSubject());
        Assert.assertEquals((Object)"2 comments added", (Object)batch.getSummary());
        Assert.assertEquals((Object)CommentBatchCreatorTest.getExpectedThreadIdForReview(review), (Object)batch.getMailThreadId());
    }

    @Test
    public void testOneNewComment() throws Exception {
        FecruUser commenter = this.modelUtil.createUser(new FecruUser("commenter"));
        Review review = this.modelUtil.createReview(this.project, "review");
        Comment comment = this.modelUtil.createComment(review, commenter);
        List<Comment> rootComments = Collections.singletonList(comment);
        CommentNotificationEvent commentNote = new CommentNotificationEvent(review, comment);
        Notification commentNotification = this.modelUtil.createNotification((NotificationEvent)commentNote);
        List<Notification> notifications = Collections.singletonList(commentNotification);
        Batch batch = this.batcher.getEmailSegment(notifications, TimeZone.getDefault(), false);
        this.assertRecipients(batch, notifications);
        this.assertCommonParts(batch, commenter);
        this.assertRootComments(rootComments);
        Assert.assertEquals((Object)(review.getPermaId() + ": " + review.getName()), (Object)batch.getSubject());
        Assert.assertEquals((Object)"1 comment added", (Object)batch.getSummary());
        Assert.assertEquals((Object)CommentBatchCreatorTest.getExpectedThreadIdForReview(review), (Object)batch.getMailThreadId());
    }

    private void assertRecipients(Batch batch, List<Notification> notifications) {
        Assert.assertTrue((batch.getNotifications().size() == notifications.size() ? 1 : 0) != 0);
        for (Notification notification : notifications) {
            Assert.assertTrue((boolean)batch.getNotifications().contains(notification));
        }
    }

    private void assertRootComments(List<Comment> comments) throws Exception {
        Map<String, Object> templateAttributes = this.verifyRenderCrucibleTemplate(false, "batch-comment-note.ftl");
        List rootComments = (List)templateAttributes.get("rootComments");
        Assert.assertTrue((rootComments.size() == comments.size() ? 1 : 0) != 0);
        for (Comment comment : comments) {
            Assert.assertTrue((boolean)rootComments.contains(Pair.newInstance(null, (Object)comment)));
        }
    }

    private void assertCommonParts(Batch batch, FecruUser commonUser) {
        Assert.assertEquals((Object)commonUser, (Object)batch.getCommonActioner());
    }

    @Test
    public void testAccepts() throws Exception {
        Review review1 = this.modelUtil.createReview(this.project, "review1");
        Review review2 = this.modelUtil.createReview(this.project, "review2");
        FecruUser commenter = this.modelUtil.createUser(new FecruUser("commenter"));
        Comment comment1 = this.modelUtil.createComment(review1, commenter);
        Comment reply1 = this.modelUtil.createReply(review1, commenter, comment1);
        Comment comment2 = this.modelUtil.createComment(review2, commenter);
        RevisionAddedNotificationEvent note1 = new RevisionAddedNotificationEvent();
        CommentNotificationEvent note2 = new CommentNotificationEvent(review1, comment1);
        ReplyNotificationEvent note3 = new ReplyNotificationEvent(review1, comment1, reply1);
        CommentNotificationEvent note4 = new CommentNotificationEvent(review2, comment2);
        Assert.assertFalse((String)"comment batcher should not accept revision added note", (boolean)this.batcher.accepts(null, (NotificationEvent)note1));
        Assert.assertTrue((String)"should accept first comment note", (boolean)this.batcher.accepts(null, (NotificationEvent)note2));
        Assert.assertTrue((String)"should accept comment reply with parent", (boolean)this.batcher.accepts((NotificationEvent)note2, (NotificationEvent)note3));
        Assert.assertFalse((String)"should not accept comments from two different reviews", (boolean)this.batcher.accepts((NotificationEvent)note3, (NotificationEvent)note4));
    }

    @Test
    public void testComparator() throws Exception {
        FileRevisionExtraInfo frxA = new FileRevisionExtraInfo(){

            public Path getFePath() {
                return new Path((CharSequence)"A");
            }
        };
        FileRevisionExtraInfo frxB = new FileRevisionExtraInfo(){

            public Path getFePath() {
                return new Path((CharSequence)"B");
            }
        };
        Comment c1 = new Comment();
        c1.setCreateDateTime(Long.valueOf(1000L));
        Comment c2 = new Comment();
        c2.setCreateDateTime(Long.valueOf(2000L));
        Comment c3 = new Comment();
        c3.setCreateDateTime(Long.valueOf(3000L));
        Comment c4 = new Comment();
        c4.setCreateDateTime(Long.valueOf(4000L));
        Comment c5 = new Comment();
        c5.setCreateDateTime(Long.valueOf(5000L));
        Comment c6 = new Comment();
        c6.setCreateDateTime(Long.valueOf(6000L));
        ArrayList<Pair> comments = new ArrayList<Pair>();
        comments.add(Pair.newInstance((Object)null, (Object)c1));
        comments.add(Pair.newInstance((Object)null, (Object)c2));
        comments.add(Pair.newInstance((Object)frxA, (Object)c3));
        comments.add(Pair.newInstance((Object)frxA, (Object)c4));
        comments.add(Pair.newInstance((Object)frxB, (Object)c5));
        comments.add(Pair.newInstance((Object)frxB, (Object)c6));
        Collections.sort(comments, CommentBatchCreator.commentPathComparator);
        Assert.assertEquals((String)"comment 1 should be ordered 1st", (Object)c1, (Object)((Pair)comments.get(0)).getSecond());
        Assert.assertEquals((String)"comment 2 should be ordered 2nd", (Object)c2, (Object)((Pair)comments.get(1)).getSecond());
        Assert.assertEquals((String)"comment 3 should be ordered 3rd", (Object)c3, (Object)((Pair)comments.get(2)).getSecond());
        Assert.assertEquals((String)"comment 4 should be ordered 4th", (Object)c4, (Object)((Pair)comments.get(3)).getSecond());
        Assert.assertEquals((String)"comment 5 should be ordered 5th", (Object)c5, (Object)((Pair)comments.get(4)).getSecond());
        Assert.assertEquals((String)"comment 6 should be ordered 6th", (Object)c6, (Object)((Pair)comments.get(5)).getSecond());
    }

    @Test
    public void testDeletedAndDraftComments() throws Exception {
        FecruUser commenter = this.modelUtil.createUser(new FecruUser("commenter"));
        Review review = this.modelUtil.createReview(this.project, "review");
        Comment commentNormal = this.modelUtil.createComment(review, commenter);
        Comment commentDeleted = this.modelUtil.createComment(review, commenter);
        commentDeleted.setDeleted(true);
        Comment commentDraft = this.modelUtil.createComment(review, commenter);
        commentDraft.setDraft(true);
        CommentNotificationEvent commentNoteNormal = new CommentNotificationEvent(review, commentNormal);
        Notification commentNotificationNormal = this.modelUtil.createNotification((NotificationEvent)commentNoteNormal);
        CommentNotificationEvent commentNoteDeleted = new CommentNotificationEvent(review, commentDeleted);
        Notification commentNotificationDeleted = this.modelUtil.createNotification((NotificationEvent)commentNoteDeleted);
        CommentNotificationEvent commentNoteDraft = new CommentNotificationEvent(review, commentDraft);
        Notification commentNotificationDraft = this.modelUtil.createNotification((NotificationEvent)commentNoteDraft);
        Batch batch = this.batcher.getEmailSegment((List)ImmutableList.of((Object)commentNotificationNormal, (Object)commentNotificationDeleted, (Object)commentNotificationDraft), TimeZone.getTimeZone("UTC"), false);
        this.assertRecipients(batch, (List<Notification>)ImmutableList.of((Object)commentNotificationNormal));
    }
}

