/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification.batch.creators;

import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.batch.creators.AbstractBatchCreator;
import com.cenqua.crucible.notification.batch.creators.EmailTemplateRender;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class BatchCreatorTestBase {
    private RootConfig oldRootConfig;
    @Mock
    protected EmailTemplateRender emailTemplateRender;
    @Captor
    private ArgumentCaptor<Map<String, Object>> templateAttributesCaptor;

    protected <T extends AbstractBatchCreator> T withMockedTemplateRenderer(T batchCreator) throws Exception {
        batchCreator.setEmailTemplateRender(this.emailTemplateRender);
        return batchCreator;
    }

    protected Map<String, Object> verifyRenderCrucibleTemplate(boolean html, String templateName) throws Exception {
        ((EmailTemplateRender)Mockito.verify((Object)this.emailTemplateRender)).renderCrucibleTemplate((Map)this.templateAttributesCaptor.capture(), Matchers.eq((boolean)html), (String)Matchers.eq((Object)templateName));
        return (Map)this.templateAttributesCaptor.getValue();
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.oldRootConfig = AppConfig.getsConfig();
        RootConfig rootConfig = (RootConfig)Mockito.mock(RootConfig.class);
        Mockito.when((Object)rootConfig.getSiteURL()).thenReturn((Object)"http://fisheye");
        AppConfig.resetConfig((RootConfig)rootConfig);
        Mockito.when((Object)this.emailTemplateRender.renderSubject(Matchers.anyString())).thenAnswer(AdditionalAnswers.returnsFirstArg());
        Mockito.when((Object)this.emailTemplateRender.renderSubject(Matchers.anyString())).thenAnswer(AdditionalAnswers.returnsFirstArg());
    }

    @After
    public void tearDown() throws Exception {
        AppConfig.resetConfig((RootConfig)this.oldRootConfig);
    }

    protected static String getExpectedThreadIdForReview(Review review) {
        return "<r" + review.getPermaId() + ".d" + Long.toString(review.getCreateDate().getTime()) + "@cruciblethreadindicator>";
    }
}

