/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.notification.ReplyNotificationEvent;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ReplyNotificationEventTest {
    @Test
    public void testGetUsersToNotify() throws Exception {
        FecruUser firstUser = new FecruUser("first");
        FecruUser secondUser = new FecruUser("second");
        FecruUser thirdUser = new FecruUser("third");
        FecruUser author = new FecruUser("author");
        FecruUser reviewer = new FecruUser("reviewer");
        Review review = (Review)Mockito.mock(Review.class);
        HashSet<FecruUser> usersFromReview = new HashSet<FecruUser>();
        usersFromReview.add(author);
        usersFromReview.add(reviewer);
        Mockito.when((Object)review.getUsersFromRoles(Mockito.anyList())).thenReturn(usersFromReview);
        Comment comment = new Comment();
        comment.setUser(firstUser);
        Comment reply = new Comment();
        reply.setUser(secondUser);
        reply.setReplyToComment(comment);
        Comment nestedReply = new Comment();
        nestedReply.setUser(thirdUser);
        nestedReply.setReplyToComment(reply);
        ReplyNotificationEvent replyEvent = new ReplyNotificationEvent(review, comment, reply);
        Assert.assertEquals((int)3, (int)replyEvent.getUsersToNotify().size());
        Assert.assertTrue((boolean)replyEvent.getUsersToNotify().contains(firstUser));
        Assert.assertTrue((boolean)replyEvent.getUsersToNotify().contains(author));
        Assert.assertTrue((boolean)replyEvent.getUsersToNotify().contains(reviewer));
        ReplyNotificationEvent nestedReplyEvent = new ReplyNotificationEvent(review, reply, nestedReply);
        Assert.assertEquals((int)4, (int)nestedReplyEvent.getUsersToNotify().size());
        Assert.assertTrue((boolean)nestedReplyEvent.getUsersToNotify().contains(firstUser));
        Assert.assertTrue((boolean)nestedReplyEvent.getUsersToNotify().contains(secondUser));
        Assert.assertTrue((boolean)replyEvent.getUsersToNotify().contains(author));
        Assert.assertTrue((boolean)replyEvent.getUsersToNotify().contains(reviewer));
    }
}

