/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.atlassian.crucible.event.CommentPropertiesChangedEvent;
import com.atlassian.crucible.event.CommentPropertiesChangedEventImpl;
import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.data.UserData;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.FRXRevision;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.CommentPropertiesChangedNotificationEvent;
import com.cenqua.crucible.notification.DefaultNotificationManager;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationEvent;
import com.cenqua.crucible.util.HtmlAndTextPair;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.TestUtil;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hibernate.Session;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.transaction.TransactionStatus;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultNotificationManagerTest {
    @Mock
    private DBControlFactory dbControlFactory;
    @Mock
    private Session session;
    @Mock
    private TxTemplate txTemplate;
    @Mock
    private UserManager userManager;
    @Mock
    private ReviewManager reviewManager;
    @Mock
    private CommentManager commentManager;
    @Mock
    private TransactionStatus transactionStatus;
    @Mock
    private FRXRevision frxRevision;
    @Mock
    private State state;
    @Mock
    private GlobalPermissionManager globalPermissionManager;
    @InjectMocks
    private DefaultNotificationManager notificationManager;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.txTemplate.execute((TxCallback)Matchers.any(TxCallback.class))).thenAnswer(invocation -> {
            TxCallback txCallback = (TxCallback)invocation.getArguments()[0];
            return txCallback.doInTransaction(this.transactionStatus);
        });
        Mockito.when((Object)this.session.isOpen()).thenReturn((Object)true);
        TestUtil.mockHibernateUtilSession(this.session);
    }

    @After
    public void tearDown() throws Exception {
        TestUtil.restoreHibernateUtilSession();
    }

    @Test
    public void testOnReviewCommentPropertiesChangedEventListener() throws Exception {
        FecruUser author = this.mockUser("author");
        FecruUser reviewer = this.mockUser("reviewer");
        Review review = this.mockReview(Review.ReviewType.REVIEW, "review", author, (Set<FecruUser>)ImmutableSet.of((Object)reviewer));
        Comment comment = this.mockComment(reviewer);
        HtmlAndTextPair headerNote = HtmlAndTextPair.of((String)"Foo", (String)"Bar");
        HtmlAndTextPair commentNote = HtmlAndTextPair.of((String)"Lorem", (String)"Ipsum");
        CommentPropertiesChangedEventImpl event = new CommentPropertiesChangedEventImpl(review.getPermId(), Review.ReviewType.REVIEW, this.getUserData(reviewer), comment.getPermId(), headerNote, commentNote);
        this.notificationManager.onReviewCommentPropertiesChanged((CommentPropertiesChangedEvent)event);
        InOrder sessionVerification = Mockito.inOrder((Object[])new Object[]{this.session});
        ((Session)sessionVerification.verify((Object)this.session)).save(Matchers.any(CommentPropertiesChangedNotificationEvent.class));
        for (int i = 0; i < 2; ++i) {
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Object.class);
            ((Session)sessionVerification.verify((Object)this.session)).save(argumentCaptor.capture());
            Object capturedObject = argumentCaptor.getValue();
            MatcherAssert.assertThat((Object)capturedObject, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Notification.class)));
            Notification notification = (Notification)capturedObject;
            MatcherAssert.assertThat((Object)notification.getUser(), (Matcher)CoreMatchers.either((Matcher)CoreMatchers.is((Object)author)).or(CoreMatchers.is((Object)reviewer)));
            NotificationEvent notificationEvent = notification.getEvent();
            MatcherAssert.assertThat((Object)notificationEvent, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(CommentPropertiesChangedNotificationEvent.class)));
            CommentPropertiesChangedNotificationEvent typedNotificationEvent = (CommentPropertiesChangedNotificationEvent)notificationEvent;
            MatcherAssert.assertThat((Object)typedNotificationEvent.getHeaderNote(), (Matcher)CoreMatchers.is((Object)headerNote));
            MatcherAssert.assertThat((Object)typedNotificationEvent.getCommentNote(), (Matcher)CoreMatchers.is((Object)commentNote));
            MatcherAssert.assertThat((Object)typedNotificationEvent.getComment(), (Matcher)CoreMatchers.is((Object)comment));
        }
    }

    @Test
    public void testNoteFRXRevisionAdded_shouldUncompleteReviewers() {
        FecruUser author = this.mockUser("author");
        FecruUser reviewer = this.mockUser("reviewer");
        FecruUser reviewer2 = this.mockUser("reviewer2");
        Review review = this.mockReview(Review.ReviewType.REVIEW, "review", author, (Set<FecruUser>)ImmutableSet.of((Object)reviewer, (Object)reviewer2));
        ReviewParticipant reviewParticipant = this.mockParticipant(review, reviewer, true, false);
        ReviewParticipant reviewParticipant2 = this.mockParticipant(review, reviewer2, true, false);
        Mockito.when((Object)review.getState()).thenReturn((Object)this.state);
        Mockito.when((Object)this.state.isApprovalState()).thenReturn((Object)true);
        Mockito.when((Object)reviewer.getUserProfile().getUncompleteOnRevisionAdded()).thenReturn((Object)true);
        Mockito.when((Object)reviewer2.getUserProfile().getUncompleteOnRevisionAdded()).thenReturn((Object)false);
        this.notificationManager.noteFRXRevisionAdded(review, this.frxRevision, author);
        ((Review)Mockito.verify((Object)review, (VerificationMode)Mockito.times((int)1))).setReviewerIncomplete((ReviewParticipant)Matchers.eq((Object)reviewParticipant));
        ((Review)Mockito.verify((Object)review, (VerificationMode)Mockito.never())).setReviewerIncomplete((ReviewParticipant)Matchers.eq((Object)reviewParticipant2));
    }

    @Test
    public void testProcessNotificationWithNullRecipient() {
        Notification notification = this.mockNotification(null, false);
        this.notificationManager.processNotification(notification);
        ((Notification)Mockito.verify((Object)notification, (VerificationMode)Mockito.times((int)1))).setEmail(DeliverySchedule.DISABLE);
    }

    @Test
    public void testProcessNotificationWhenRecipientNotEnabled() {
        FecruUser notEnabled = this.mockUser("recipient1");
        Mockito.when((Object)notEnabled.isEnabled()).thenReturn((Object)false);
        Notification notification = this.mockNotification(notEnabled, false);
        this.notificationManager.processNotification(notification);
        ((Notification)Mockito.verify((Object)notification, (VerificationMode)Mockito.times((int)1))).setEmail(DeliverySchedule.DISABLE);
    }

    @Test
    public void testProcessNotificationWhenRecipientDoestHavePermissions() {
        FecruUser fisheyeOnly = this.mockUser("recipient2");
        FecruUser fecruUser = this.mockUser("recipient3");
        Mockito.when((Object)fisheyeOnly.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)fecruUser.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.globalPermissionManager.hasPermissions("recipient2", EnumSet.of(GlobalPermissionType.FISHEYE_USER))).thenReturn((Object)false);
        Mockito.when((Object)this.globalPermissionManager.hasPermissions("recipient3", GlobalPermissionType.FISHEYE_AND_CRUCIBLE)).thenReturn((Object)false);
        Notification notificationWithoutCru = this.mockNotification(fisheyeOnly, false);
        Notification notificationWithCru = this.mockNotification(fisheyeOnly, true);
        this.notificationManager.processNotification(notificationWithoutCru);
        this.notificationManager.processNotification(notificationWithCru);
        ((Notification)Mockito.verify((Object)notificationWithoutCru, (VerificationMode)Mockito.times((int)1))).setEmail(DeliverySchedule.DISABLE);
        ((Notification)Mockito.verify((Object)notificationWithCru, (VerificationMode)Mockito.times((int)1))).setEmail(DeliverySchedule.DISABLE);
    }

    private Notification mockNotification(FecruUser User2, boolean needCrucible) {
        Notification notification = (Notification)Mockito.mock(Notification.class);
        NotificationEvent event = (NotificationEvent)Mockito.mock(NotificationEvent.class);
        Mockito.when((Object)notification.getEvent()).thenReturn((Object)event);
        Mockito.when((Object)notification.getEmail()).thenReturn((Object)DeliverySchedule.IMMEDIATE);
        Mockito.when((Object)notification.getUser()).thenReturn((Object)User2);
        Mockito.when((Object)event.needsCrucible()).thenReturn((Object)needCrucible);
        return notification;
    }

    private ReviewParticipant mockParticipant(Review review, FecruUser user, boolean isReviewer, boolean isAuthor) {
        ReviewParticipant participant = new ReviewParticipant();
        participant.setUser(user);
        Mockito.when((Object)review.getParticipant((FecruUser)Matchers.eq((Object)user))).thenReturn((Object)participant);
        participant.setReviewer(isReviewer);
        participant.setAuthor(isAuthor);
        return participant;
    }

    private FecruUser mockUser(String userName) {
        UserProfile userProfile = (UserProfile)Mockito.mock(UserProfile.class);
        FecruUser user = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)user.getUsername()).thenReturn((Object)userName);
        Mockito.when((Object)this.globalPermissionManager.hasPermissions((String)Matchers.eq((Object)userName), (Set)Matchers.eq((Object)GlobalPermissionType.FISHEYE_AND_CRUCIBLE))).thenReturn((Object)true);
        Mockito.when((Object)this.globalPermissionManager.hasPermission((String)Matchers.eq((Object)userName), (GlobalPermissionType)Matchers.eq((Object)GlobalPermissionType.FISHEYE_USER))).thenReturn((Object)true);
        Mockito.when((Object)user.getUserProfile()).thenReturn((Object)userProfile);
        Mockito.when((Object)this.userManager.getUser((String)Matchers.eq((Object)userName))).thenReturn((Object)user);
        Mockito.when((Object)this.userManager.getLicensedUser((String)Matchers.eq((Object)userName))).thenReturn((Object)user);
        return user;
    }

    private UserData getUserData(FecruUser user) {
        String username = user.getUsername();
        UserData userData = (UserData)Mockito.mock(UserData.class);
        Mockito.when((Object)userData.getUserName()).thenReturn((Object)username);
        return userData;
    }

    private Review mockReview(Review.ReviewType reviewType, String reviewId, FecruUser author, Set<FecruUser> reviewers) {
        PermId reviewPermId = (PermId)Mockito.mock(PermId.class);
        Mockito.when((Object)reviewPermId.getId()).thenReturn((Object)reviewId);
        Review review = (Review)Mockito.mock(Review.class);
        Mockito.when((Object)review.getPermId()).thenReturn((Object)reviewPermId);
        Mockito.when((Object)review.getType()).thenReturn((Object)reviewType);
        Mockito.when((Object)review.getAuthor()).thenReturn((Object)author);
        Mockito.when((Object)review.getReviewers()).thenReturn(reviewers);
        Mockito.when((Object)review.getUsersFromRoles(Matchers.anyList())).thenCallRealMethod();
        Mockito.when((Object)this.reviewManager.getReviewByPermaId((String)Matchers.eq((Object)reviewId))).thenReturn((Object)review);
        return review;
    }

    private Comment mockComment(FecruUser user) {
        PermId commentPermId = (PermId)Mockito.mock(PermId.class);
        Comment comment = (Comment)Mockito.mock(Comment.class);
        Mockito.when((Object)comment.getPermId()).thenReturn((Object)commentPermId);
        Mockito.when((Object)comment.getUser()).thenReturn((Object)user);
        Mockito.when((Object)this.commentManager.getByPermId((PermId)Matchers.eq((Object)commentPermId))).thenReturn((Object)comment);
        return comment;
    }
}

