/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.dao.ContentRootDAO;
import com.cenqua.crucible.model.dao.ProjectDAO;
import com.cenqua.crucible.model.dao.ReviewDAO;
import com.cenqua.crucible.model.dao.ReviewPermaIdDAO;
import com.cenqua.crucible.model.managers.PermaIdCacheManager;
import com.cenqua.crucible.model.managers.impl.DefaultProjectManager;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.test.util.ReflectionTestUtils;

public class ProjectManagerAllowedReviewerTest {
    private GroupMembershipManager groupMembershipManager;
    private DefaultProjectManager projectManager;

    @Before
    public void setup() {
        this.groupMembershipManager = (GroupMembershipManager)Mockito.mock(GroupMembershipManager.class);
        this.projectManager = new DefaultProjectManager((ProjectDAO)Mockito.mock(ProjectDAO.class), (ReviewDAO)Mockito.mock(ReviewDAO.class), (ReviewPermaIdDAO)Mockito.mock(ReviewPermaIdDAO.class), (ContentRootDAO)Mockito.mock(ContentRootDAO.class), (EventPublisher)Mockito.mock(EventPublisher.class), (PermaIdCacheManager)Mockito.mock(PermaIdCacheManager.class));
        this.projectManager.setGroupMembershipManager(this.groupMembershipManager);
        ReflectionTestUtils.setField((Object)this.projectManager, (String)"self", (Object)this.projectManager);
    }

    @Test
    public void testAllowedReviewers() {
        Project project = new Project();
        FecruUser user1 = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)user1.getUsername()).thenReturn((Object)"user1");
        FecruUser user2 = (FecruUser)Mockito.mock(FecruUser.class);
        Mockito.when((Object)user2.getUsername()).thenReturn((Object)"user2");
        Assert.assertTrue((String)"Any user should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user1));
        Assert.assertTrue((String)"Any user should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user2));
        project.setAllowedReviewerUsers((Set)ImmutableSet.of((Object)user1));
        Assert.assertTrue((String)"Only named users should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user1));
        Assert.assertFalse((String)"Only named users should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user2));
        project.setAllowedReviewerUsers((Set)ImmutableSet.of());
        String group1 = "group1";
        String group2 = "group2";
        Mockito.when((Object)this.groupMembershipManager.isUserInGroup(group1, user1.getUsername())).thenReturn((Object)true);
        Mockito.when((Object)this.groupMembershipManager.isUserInGroup(group2, user2.getUsername())).thenReturn((Object)true);
        project.setAllowedReviewerGroups((Set)ImmutableSet.of((Object)group1));
        Assert.assertTrue((String)"Only group members should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user1));
        Assert.assertFalse((String)"Only group members should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user2));
        project.setAllowedReviewerGroups((Set)ImmutableSet.of((Object)group2));
        Assert.assertFalse((String)"Only group members should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user1));
        Assert.assertTrue((String)"Only group members should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user2));
        project.setAllowedReviewerUsers((Set)ImmutableSet.of((Object)user1));
        Assert.assertTrue((String)"named user should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user1));
        Assert.assertTrue((String)"group members should be allowed", (boolean)this.projectManager.isAllowedReviewer(project, user2));
        project.setAllowedReviewerGroups((Set)ImmutableSet.of((Object)group1));
        Assert.assertFalse((String)"Anonymous user is not allowed", (boolean)this.projectManager.isAllowedReviewer(project, null));
    }
}

