/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.cenqua.crucible.model.dao.ReviewPermaIdDAO;
import com.cenqua.crucible.model.managers.impl.DefaultPermaIdCacheManager;
import com.google.common.base.Throwables;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PermaIdCacheTest {
    private DefaultPermaIdCacheManager permaIdCacheManager;
    private ReviewPermaIdDAO reviewPermaIdDAOMock;

    @Before
    public void setUp() throws Exception {
        this.reviewPermaIdDAOMock = (ReviewPermaIdDAO)Mockito.mock(ReviewPermaIdDAO.class);
        this.permaIdCacheManager = new DefaultPermaIdCacheManager(this.reviewPermaIdDAOMock);
    }

    @Test
    public void testGetNextPermaIdValueNotFoundInDB() throws Exception {
        Mockito.when((Object)this.reviewPermaIdDAOMock.getMaxNumberForProject("projectA")).thenReturn(null);
        Mockito.when((Object)this.reviewPermaIdDAOMock.getMaxNumberForProject("projectB")).thenReturn(null);
        Assert.assertThat((Object)this.permaIdCacheManager.getNextPermaId("projectA"), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)this.permaIdCacheManager.getNextPermaId("projectA"), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)this.permaIdCacheManager.getNextPermaId("projectB"), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)this.permaIdCacheManager.getNextPermaId("projectB"), (Matcher)Matchers.equalTo((Object)2));
        ((ReviewPermaIdDAO)Mockito.verify((Object)this.reviewPermaIdDAOMock, (VerificationMode)Mockito.times((int)1))).getMaxNumberForProject("projectA");
        ((ReviewPermaIdDAO)Mockito.verify((Object)this.reviewPermaIdDAOMock, (VerificationMode)Mockito.times((int)1))).getMaxNumberForProject("projectB");
    }

    @Test
    public void testGetNextPermaIdValueFoundInDB() throws Exception {
        Mockito.when((Object)this.reviewPermaIdDAOMock.getMaxNumberForProject("projectA")).thenReturn((Object)5);
        Mockito.when((Object)this.reviewPermaIdDAOMock.getMaxNumberForProject("projectB")).thenReturn((Object)10);
        Assert.assertThat((Object)this.permaIdCacheManager.getNextPermaId("projectA"), (Matcher)Matchers.equalTo((Object)6));
        Assert.assertThat((Object)this.permaIdCacheManager.getNextPermaId("projectA"), (Matcher)Matchers.equalTo((Object)7));
        Assert.assertThat((Object)this.permaIdCacheManager.getNextPermaId("projectB"), (Matcher)Matchers.equalTo((Object)11));
        Assert.assertThat((Object)this.permaIdCacheManager.getNextPermaId("projectB"), (Matcher)Matchers.equalTo((Object)12));
        ((ReviewPermaIdDAO)Mockito.verify((Object)this.reviewPermaIdDAOMock, (VerificationMode)Mockito.times((int)1))).getMaxNumberForProject("projectA");
        ((ReviewPermaIdDAO)Mockito.verify((Object)this.reviewPermaIdDAOMock, (VerificationMode)Mockito.times((int)1))).getMaxNumberForProject("projectB");
    }

    @Test
    public void testRemovePermaIdFromCache() throws Exception {
        Mockito.when((Object)this.reviewPermaIdDAOMock.getMaxNumberForProject("projectA")).thenReturn((Object)5);
        Mockito.when((Object)this.reviewPermaIdDAOMock.getMaxNumberForProject("projectB")).thenReturn((Object)10);
        this.permaIdCacheManager.getNextPermaId("projectA");
        this.permaIdCacheManager.getNextPermaId("projectB");
        this.permaIdCacheManager.removePermaIdFromCache("projectB");
        this.permaIdCacheManager.getNextPermaId("projectA");
        this.permaIdCacheManager.getNextPermaId("projectB");
        this.permaIdCacheManager.getNextPermaId("projectA");
        this.permaIdCacheManager.getNextPermaId("projectB");
        ((ReviewPermaIdDAO)Mockito.verify((Object)this.reviewPermaIdDAOMock, (VerificationMode)Mockito.times((int)1))).getMaxNumberForProject("projectA");
        ((ReviewPermaIdDAO)Mockito.verify((Object)this.reviewPermaIdDAOMock, (VerificationMode)Mockito.times((int)2))).getMaxNumberForProject("projectB");
    }

    private Callable<Integer> createTaskGettingNextPermId(CountDownLatch clientsStartedSignal, String projectKey) {
        return () -> {
            clientsStartedSignal.countDown();
            return this.permaIdCacheManager.getNextPermaId(projectKey);
        };
    }

    @Test
    public void testConcurrentProjectKeyGen() throws Exception {
        int numberOfConcurrentClients = 10;
        CountDownLatch clientsStartedSignal = new CountDownLatch(numberOfConcurrentClients);
        CountDownLatch startTestSignal = new CountDownLatch(1);
        int idInDB = 5;
        Mockito.when((Object)this.reviewPermaIdDAOMock.getMaxNumberForProject("projectA")).thenAnswer(invocation -> {
            startTestSignal.await();
            clientsStartedSignal.await();
            return 5;
        });
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfConcurrentClients);
        ArrayList taskResults = Lists.newArrayList();
        for (int i = 0; i < numberOfConcurrentClients; ++i) {
            taskResults.add(executorService.submit(this.createTaskGettingNextPermId(clientsStartedSignal, "projectA")));
        }
        startTestSignal.countDown();
        List results = Lists.transform((List)taskResults, taskResult -> {
            try {
                return (Integer)taskResult.get();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
        ContiguousSet expectedValues = ContiguousSet.create((Range)Range.openClosed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(15)), (DiscreteDomain)DiscreteDomain.integers());
        Assert.assertThat((Object)results, (Matcher)Matchers.containsInAnyOrder((Object[])expectedValues.toArray()));
        ((ReviewPermaIdDAO)Mockito.verify((Object)this.reviewPermaIdDAOMock, (VerificationMode)Mockito.times((int)1))).getMaxNumberForProject("projectA");
    }
}

