/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers.impl;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.managers.impl.DefaultSecureProjectManager;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.BasePrincipalAssociation;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.UserPA;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserTestHelper;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level3-manager.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class DefaultSecureProjectManagerTest {
    @Mock
    private PermissionManager permissionManager;
    @Mock
    private GroupMembershipManager groupMembershipManager;
    @Mock
    private ProjectManager projectManager;
    @Mock
    private RootConfig rootConfig;
    @Autowired
    private CurrentSessionProvider currentSessionProvider;
    private DefaultSecureProjectManager secureProjectManager;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.secureProjectManager = new DefaultSecureProjectManager(this.permissionManager, this.groupMembershipManager, this.projectManager, this.rootConfig, this.currentSessionProvider);
    }

    @Test
    public void testGetProjectsCanDoActionIn_anon_withAnonAccessDisabled() throws Exception {
        Project project = this.createAnonymouslyVisibleProject();
        Mockito.when((Object)this.rootConfig.isCruAnonAccessAllowed()).thenReturn((Object)false);
        List anonVisibleProjects = this.secureProjectManager.getProjectsCanDoActionIn((Principal)Principal.Anonymous.ANON, UserActionManager.Action.ACTION_VIEW);
        Assert.assertThat((Object)anonVisibleProjects, (Matcher)Matchers.empty());
    }

    @Test
    public void testGetProjectsCanDoActionIn_nonAnon() throws Exception {
        Project project = this.createAnonymouslyVisibleProject();
        Mockito.when((Object)this.rootConfig.isCruAnonAccessAllowed()).thenReturn((Object)false);
        List userVisibleProjects = this.secureProjectManager.getProjectsCanDoActionIn((Principal)new UserLogin(new FecruUser("joe"), null, null), UserActionManager.Action.ACTION_VIEW);
        Assert.assertThat((Object)userVisibleProjects, (Matcher)Matchers.contains((Object[])new Project[]{project}));
    }

    @Test
    public void testGetProjectsCanDoActionIn_anon() throws Exception {
        Project project = this.createAnonymouslyVisibleProject();
        Mockito.when((Object)this.rootConfig.isCruAnonAccessAllowed()).thenReturn((Object)true);
        List visibleProjects = this.secureProjectManager.getProjectsCanDoActionIn((Principal)Principal.Anonymous.ANON, UserActionManager.Action.ACTION_VIEW);
        Assert.assertThat((Object)visibleProjects, (Matcher)Matchers.contains((Object[])new Project[]{project}));
    }

    @Test
    public void getProjectsCanDoActionInShouldIgnoreUserCase() throws Exception {
        Project restrictedProject = this.restrictedProject(scheme -> ImmutableList.of((Object)new UserPA(scheme, "tom", UserActionManager.Action.ACTION_VIEW.getName()), (Object)new UserPA(scheme, "don", UserActionManager.Action.ACTION_VIEW.getName()), (Object)new UserPA(scheme, "BOB", UserActionManager.Action.ACTION_VIEW.getName())));
        Mockito.when((Object)this.groupMembershipManager.getGroupsForUser("DON")).thenReturn((Object)ImmutableList.of((Object)"group1"));
        List tomProjects = this.secureProjectManager.getProjectsCanDoActionIn((Principal)UserTestHelper.createPrincipal("TOM"), UserActionManager.Action.ACTION_VIEW);
        List donProjects = this.secureProjectManager.getProjectsCanDoActionIn((Principal)UserTestHelper.createPrincipal("DON"), UserActionManager.Action.ACTION_VIEW);
        List bobProjects = this.secureProjectManager.getProjectsCanDoActionIn((Principal)UserTestHelper.createPrincipal("bob"), UserActionManager.Action.ACTION_VIEW);
        List noProjects = this.secureProjectManager.getProjectsCanDoActionIn((Principal)UserTestHelper.createPrincipal("NO"), UserActionManager.Action.ACTION_VIEW);
        Assert.assertThat((Object)tomProjects, (Matcher)Matchers.contains((Object[])new Project[]{restrictedProject}));
        Assert.assertThat((Object)donProjects, (Matcher)Matchers.contains((Object[])new Project[]{restrictedProject}));
        Assert.assertThat((Object)bobProjects, (Matcher)Matchers.contains((Object[])new Project[]{restrictedProject}));
        Assert.assertThat((Object)noProjects, (Matcher)Matchers.empty());
    }

    @Test
    public void getProjectsCanDoActionInShouldIgnoreGroupCase() throws Exception {
        Project userOnlyProject = this.restrictedProject(scheme -> ImmutableList.of((Object)new GroupPA(scheme, "group1", UserActionManager.Action.ACTION_VIEW.getName()), (Object)new GroupPA(scheme, "GROUP2", UserActionManager.Action.ACTION_VIEW.getName())));
        Mockito.when((Object)this.groupMembershipManager.getGroupsForUser("tom")).thenReturn((Object)ImmutableList.of((Object)"GROUP1"));
        Mockito.when((Object)this.groupMembershipManager.getGroupsForUser("don")).thenReturn((Object)ImmutableList.of((Object)"group2"));
        List tomProjects = this.secureProjectManager.getProjectsCanDoActionIn((Principal)UserTestHelper.createPrincipal("tom"), UserActionManager.Action.ACTION_VIEW);
        List donProjects = this.secureProjectManager.getProjectsCanDoActionIn((Principal)UserTestHelper.createPrincipal("don"), UserActionManager.Action.ACTION_VIEW);
        Assert.assertThat((Object)donProjects, (Matcher)Matchers.contains((Object[])new Project[]{userOnlyProject}));
        Assert.assertThat((Object)tomProjects, (Matcher)Matchers.contains((Object[])new Project[]{userOnlyProject}));
    }

    @Test
    public void isAtLeastOneProjectCanDoActionInShouldIgnoreGroupCase() throws Exception {
        this.restrictedProject(scheme -> ImmutableList.of((Object)new GroupPA(scheme, "group1", UserActionManager.Action.ACTION_VIEW.getName()), (Object)new GroupPA(scheme, "GROUP2", UserActionManager.Action.ACTION_VIEW.getName())));
        Mockito.when((Object)this.groupMembershipManager.getGroupsForUser("tom")).thenReturn((Object)ImmutableList.of((Object)"GROUP1"));
        Mockito.when((Object)this.groupMembershipManager.getGroupsForUser("don")).thenReturn((Object)ImmutableList.of((Object)"group2"));
        Mockito.when((Object)this.groupMembershipManager.getGroupsForUser("brendan")).thenReturn((Object)ImmutableList.of((Object)"otherGroup"));
        boolean tomIsAllowed = this.secureProjectManager.isAtLeastOneProjectCanDoActionIn((Principal)UserTestHelper.createPrincipal("tom"), UserActionManager.Action.ACTION_VIEW);
        boolean donIsAllowed = this.secureProjectManager.isAtLeastOneProjectCanDoActionIn((Principal)UserTestHelper.createPrincipal("don"), UserActionManager.Action.ACTION_VIEW);
        boolean brendanIsAllowed = this.secureProjectManager.isAtLeastOneProjectCanDoActionIn((Principal)UserTestHelper.createPrincipal("brendan"), UserActionManager.Action.ACTION_VIEW);
        Assert.assertTrue((String)"Tom should be allowed", (boolean)tomIsAllowed);
        Assert.assertTrue((String)"Don should be allowed", (boolean)donIsAllowed);
        Assert.assertFalse((String)"Brendan shouldn't be allowed", (boolean)brendanIsAllowed);
    }

    private Project createAnonymouslyVisibleProject() {
        return this.restrictedProject(permissionScheme -> ImmutableList.of((Object)new AnonymousPA(permissionScheme, UserActionManager.Action.ACTION_VIEW.getName())));
    }

    private Project restrictedProject(Function<PermissionScheme, Iterable<? extends BasePrincipalAssociation>> createPAs) {
        PermissionScheme scheme = new PermissionScheme("anonymousAllowedInPS");
        this.save(scheme);
        for (BasePrincipalAssociation basePrincipalAssociation : createPAs.apply(scheme)) {
            this.save(basePrincipalAssociation);
        }
        Project p = new Project();
        p.setName("AnonProject");
        p.setProjKey("AP");
        p.setPermissionScheme(scheme);
        this.save(p);
        return p;
    }

    private Serializable save(Object entity) {
        return this.currentSessionProvider.currentSession().save(entity);
    }
}

